<?php
require_once 'includes/cron_application_top.php';
require_once 'includes/classes/class.basics.php';
ini_set('memory_limit','1200M');
@set_time_limit(0);
$basics = new basics;
$offset_file = 'importdata/cron_shopgate_allocate_products.DAT';
$offset = 0;
if(!is_file($offset_file)){
	$basics->create_file($offset_file,$offset);
	echo 'SHOPGATE offsetfile created ...'."\r\n\r\n";
}else{
	$nr = $basics->read_file_content($offset_file);
	$offset = (int)trim($nr);
	echo 'SHOPGATE offset file number: '.$offset."\r\n\r\n";
}
$_SESSION['language'] = 'german';
$_SESSION['languages_id'] = 2;
##### XTC3 BOF #####
require(DIR_FS_CATALOG.'/shopgate/shopgate_library/shopgate.php');
require(DIR_FS_CATALOG.'/shopgate/base/shopgate_config.php');
include_once DIR_FS_CATALOG.'/shopgate/plugin.php';
##### XTC3 BOF #####

$encodings = array('UTF-8', 'ISO-8859-1', 'ISO-8859-15');
$error = array();

$sg_language = 'de';

$error = '';
$num = 0;
$num_allocated = 0;
$limit = 100;
$current_step = 0;
$current_offset = $offset;
$max_steps = 50;
$has_more_transactions = false; // offset file schreiben?
function _walk($offset){
	global $num,$limit,$max_steps,$current_step,$has_more_transactions,$num_allocated,$current_offset;
	try{
		$shopgateConfig = new ShopgateConfigXtc();
		$plugin = new ShopgatePluginXtc3();
		$params = array('limit'=>$limit,'offset'=>$offset*$limit);
		$res = $plugin->yes_get_items($params);
		$data = $res->getData();
		foreach($data as $k=>$item){
			$query = xtc_db_query(sprintf(
				"SELECT shopgate_status FROM %s WHERE products_id='%s'",
				TABLE_PRODUCTS,$item->getItemNumber()
			));
			if(!xtc_db_num_rows($query)){
				echo "Error: Shopgate ItemNumber ".$item->getItemNumber()." ist YES nicht bekannt.\r\n";
				continue;
			}
			$record = xtc_db_fetch_array($query);
			if($record['shopgate_status'] == 2){
				continue;
			}
			$update_sql_array = array(
				'shopgate_status'=>2,
				'shopgate_quantity'=>$item->getStockQuantity()
			);
			xtc_db_perform(TABLE_PRODUCTS,$update_sql_array,'update',"products_id='".$item->getItemNumber()."'");
			$insert_sql_array = array(
				'products_id'=>$item->getItemNumber(),
				'editor_id'=>0,
				'date_saved'=>'now()',
				'comments'=>'Shopgate Zuweisung - mit '.$item->getStockQuantity().' Stk gespeichert.'
			);
			xtc_db_perform('products_history',$insert_sql_array);
			$num_allocated++;
		}
		$num += sizeOf($data);
		if($res->getHasMoreResults() == 1){
			echo 'Aktuelles Offset: '.$res->getOffset()."\r\n";
			if($current_step < $max_steps){
				$current_step++;
				_walk($offset+1);
			}else{
				$current_offset = $offset;
				$has_more_transactions = true;
				return '';
			}
		}
		
	}catch (Exception $e){
		return $e->getMessage();
	}
}
$error = _walk($offset);

if($error != ''){
	unlink($offset_file);
	die('Shopgate ERROR: '.$error);
}

echo 'Es wurden '.$num.' Artikel geprueft und '.$num_allocated.' zugewiesen.'."\r\n";
if($has_more_transactions){
	$basics->create_file($offset_file,$current_offset+1);
	echo "Beim naechsten Aufruf der Datei werden weitere Artikel geprueft.\r\n";
}

