<?php
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$smarty->assign('REVISE_ITEM',REVISE_ITEM);
$smarty->assign('REVISE_ITEM_PRICE',REVISE_ITEM_PRICE);
$smarty->assign('REVISE_ITEM_BESTOFFER',REVISE_ITEM_BESTOFFER);
$smarty->assign('REVISE_ITEM_QTY',REVISE_ITEM_QTY);
$smarty->assign('TEXT_CARTID',TEXT_CARTID);
$smarty->assign('TEXT_AVAILABLE_QTY',TEXT_AVAILABLE_QTY);
$smarty->assign('TEXT_SELLER',TEXT_SELLER);
$smarty->assign('TYPE',$_GET['type']);
$id = intval($_GET['id']??0);
if($id < 1){
    die('Missing params');
}
$auction = new ebay_auction($id);
$SQ = new products_quantity($auction->getProductsId());
$basics = new basics;
$EBAYAPI = new ebayApi;
$smarty_auction_array = $auction->getSmartyListArray($SQ,$actions=array());

$ebay_user = $auction->getUser();
$site_id = $EBAYAPI->get_site_id_from_name($auction->getSite());
$ebay_id = $auction->getEbayId();
$seller = $ebay_user;
if(ebayApi::oauth2_refreshtoken_exists($seller)){
        if(!ebayApi::oauth2_usertoken_exists($seller) or ebayApi::get_oauth2_usertoken_lifetime($seller) < 1){
            try{
                ebayApi::refresh_oauth2_usertoken($seller);
            }catch(Exception $e){
                $api_error = 'refresh_oauth2_usertoken() for seller '.$seller.'  '.$e->getMessage();
                die($api_error);
            }
        }
}

$ebaycalls = new \YES4Trade\Model\ebaycalls();
if(isset($_REQUEST['from']) and $_REQUEST['from'] != ''){
	$smarty->assign('FROM_URL', $_REQUEST['from']);
}

switch($_REQUEST['revise_action']){
    case 'ajax_title_update':
        $item = new \stdClass();
        $item->ItemID = $ebay_id;
        $new_title = xtc_db_prepare_input($_REQUEST['title']);
        //$new_title = yes_decode_string($new_title); // ticket 2514
        $json_array = array(
            'ERROR'=>'',
            'MSG'=>'',
            'TITLE'=> $new_title
        );
        $item->Title = $new_title;
        $res = $EBAYAPI->revise_auction($id, $item);
        if($res != ''){
            $json_array['ERROR'] = yes_encode_string(strip_tags($res) );
        }else{
            \YES4Trade\Model\ebay_auctions::update_ebay_auction([ // title update
                'title'=>$_REQUEST['title'],
                'id'=>intval($id)
            ]);
            if(isset($_REQUEST['update_product']) and $_REQUEST['update_product'] == '1'){
                $pID = $auction->getProductsId();
                if($pID > 0){
                    $cID = xtc_get_site_country_id($auction->getSite());
                    $lID = xtc_is_language_installed($cID);
                    if(!$lID){
                            $lID = '2';
                    }
                    xtc_db_query(sprintf(
                        "UPDATE %s SET ebay_title='%s' WHERE products_id='%d' AND language_id='%d'",
                        TABLE_PRODUCTS_DESCRIPTION,xtc_db_input($_REQUEST['title']),$pID,$lID
                    ));
                    $insert_sql_array = array(
                        'products_id'=>$pID,
                        'editor_id'=>$_SESSION['customer_id'],
                        'date_saved'=>'now()',
                        'comments'=>sprintf(TEXT_PRODUCTS_TITLE_UPDATED,$new_title)
                    );
                    xtc_db_perform('products_history',$insert_sql_array);
                }
            }
            $json_array['MSG'] = yes_encode_string( sprintf(REVISE_ITEM_TITLE_SUCCESFUL,$ebay_id,$new_title) );
	    }
        die(json_encode($json_array));
        break;
    case 'change_bestoffer':
        $new_bestoffer_price = (float)xtc_db_input($_POST['new_bestoffer_price']);
        $new_bestoffer_price = str_replace(',','.',$new_bestoffer_price);
        $new_bestofferautoacceptprice = (float)xtc_db_input($_POST['new_bestofferautoacceptprice']);
        $new_bestofferautoacceptprice = str_replace(',','.',$new_bestofferautoacceptprice);

        $item = new \stdClass();
        $LD = new \stdClass();
        $best = new \stdClass();
        $LD->MinimumBestOfferPrice = (float)$new_bestoffer_price;
        $LD->BestOfferAutoAcceptPrice = (float)$new_bestofferautoacceptprice;
        $item->ItemID = $ebay_id;
        $best->BestOfferEnabled = true;
        $item->BestOfferDetails = $best;
        $item->ListingDetails = $LD;
        $res = $EBAYAPI->revise_auction( $id, $item );
        if($res != ''){
            $messageStack->add_session( $res,'error' );
        }else{
            \YES4Trade\Model\ebay_auctions::update_ebay_auction([
                'bestoffer_price'=>(float)$new_bestoffer_price,
                'bestofferautoacceptprice'=>(float)$new_bestofferautoacceptprice,
                'id'=>intval($id)
            ]);
            $messageStack->add_session(sprintf(REVISE_ITEM_BESTOFFER_SUCCESFUL,$ebay_id,$new_bestoffer_price,$new_bestofferautoacceptprice),'success');
        }
        if(isset($_REQUEST['from']) and $_REQUEST['from'] != ''){
            xtc_redirect($_REQUEST['from']);
        }else{
            xtc_redirect(xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(array('action','id','type'))));
        }
        break;
    case 'change_converted_start_price':
        $item = new \stdClass();
        $item->ItemID = $ebay_id;
        $return_value = '';
        if(isset($_REQUEST['new_price']) and is_array($_REQUEST['new_price'])){
            $Variations = new \stdClass();
            foreach($_REQUEST['new_price'] as $sku => $new_price){
                if(isset($_REQUEST['revise_price'][$sku]) and $_REQUEST['revise_price'][$sku] == '1'){
                    $new_price = (float)xtc_db_input(str_replace(',','.',$new_price));
                    $qty = 0;
                    foreach($auction->getVariations() as $av){
                        if($av->getSku() == $sku){
                            $qty = $av->getQuantity();
                            break;
                        }
                    }
                    $Variation = new \stdClass();
                    $Variation->StartPrice = (float)$new_price;
                    $Variation->Quantity = intval($qty);
                    $Variation->SKU = (string)$sku;
                    $Variations->Variation[] = $Variation;
                }
            }
            $item->Variations = $Variations;
        }else{
            $new_price = (float)xtc_db_input(str_replace(',','.',$_REQUEST['new_price']));
            $item->StartPrice = (float)$new_price;
        }


        $_messages = array();
        $_success = false;
        $res = $EBAYAPI->revise_auction($id, $item);
        if($res != ''){
            $_messages[] = $res;
        }else{
            $ea = new ebay_auction($id);
            if(isset($_REQUEST['new_price']) and is_array($_REQUEST['new_price'])){
                //$Variations = $EBAYAPI->get_sdk_type_class('VariationsType');
                foreach($_REQUEST['new_price'] as $sku => $new_price){
                    if(!isset($_REQUEST['revise_price'][$sku]) or $_REQUEST['revise_price'][$sku] != '1'){
                        continue;
                    }
                    $eav = \YES4Trade\Model\ebay_auctions_variations::get_by_ebay_auctions_id_and_sku(
                        intval($id),$sku,
                        ['products_id','price']
                    );
                    $orig_price = (float)$eav->price;
                    $new_price = (float)xtc_db_input(str_replace(',','.',$new_price));
                    \YES4Trade\Model\ebay_auctions_variations::update_ebay_auctions_variations_by_ebay_auctions_id_and_sku([
                        'price'=>$new_price, 
                        'ebay_auctions_id'=>intval($id),
                        'sku'=>"$sku"
                    ]);
                    $_messages[] = sprintf(REVISE_ITEM_PRICE_SUCCESFUL,$ebay_id,$new_price);
                    $EBAYAPI->save_history(
                        $ea->getEbayProductsId(),
                        sprintf('Preisrevise Auktion %s (SKU %s): von %s zu %s',
                            $ea->getEbayId(),$record['sku'],$orig_price,$new_price
                        ),
                        $_SESSION['customer_id']
                    );
                }
            }else{
                $orig_price = $ea->getAuctionprice();
                \YES4Trade\Model\ebay_auctions::update_ebay_auction([ // update auctionprice only
                    'auctionprice'=>(float)$new_price,
                    'id'=>intval($id)
                ]);
                $EBAYAPI->save_history($ea->getEbayProductsId(),sprintf(TEXT_HISTORY_REVICE_PRICE,$ea->getEbayId(),$orig_price,$new_price),$_SESSION['customer_id']);
                $_messages[] = sprintf(REVISE_ITEM_PRICE_SUCCESFUL,$ebay_id,number_format($new_price,2,',','.'));
                $return_value = number_format($new_price,2,',','.');
            }
            $_success = true;
        }
        if(isset($_REQUEST['json_response']) and $_REQUEST['json_response'] == 1){
                if(sizeOf($_messages)){
                        foreach($_messages as $k=>$_msg){
                                $_messages[$k] = yes_encode_string($_msg);
                        }
                }
            die(json_encode(array(
                'MSG'=>implode("\r\n",$_messages),
                'SUCCESS'=>$_success,
                'UPDATE_SOURCE_ELEMENT'=>(isset($_REQUEST['new_price']) and is_array($_REQUEST['new_price'])) ? false : true,
                'VALUE'=>$return_value,
                'ID'=>$id
            )));
        }else{
            xtc_redirect(xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(array('action','id','type'))));
        }
        break;
    case 'change_qty':
        if(isset($_REQUEST['new_qty']) and is_array($_REQUEST['new_qty'])){
            $item = new \stdClass();
            $Variations = new \stdClass();
            $item->ItemID = $ebay_id;
            foreach($_REQUEST['new_qty'] as $sku => $new_qty){
                if(!isset($_REQUEST['revise_qty'][$sku]) or $_REQUEST['revise_qty'][$sku] != '1'){
                    continue;
                }
                $new_qty = (int)xtc_db_input($new_qty);
                $new_qty_check = $new_qty;

                if(defined('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS') and MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS == 'True'){
                    if($auction->has_staffelpreise()){
                        $new_qty_check = $new_qty_check*$auction->get_staffelpreis_quantity_from_sku($sku);
                    }
                }
                $eav = \YES4Trade\Model\ebay_auctions_variations::get_by_ebay_auctions_id_and_sku(
                    intval($id),$sku,
                    ['products_id','quantity','quantity_sold']
                );
                $pID = intval($eav->products_id);
                $refill_qty = $new_qty-$eav->quantity;
                // BESTANDSPRUEFUNG
                $SQ = new products_quantity($pID);
                $products_stock = $SQ->get_available1_qty();

                if( $products_stock < $new_qty_check && STOCK_CHECK == 'true'){
                    $messageStack->add_session(sprintf(REVISE_ITEM_QUANTITY_ERROR,$ebay_id,$new_qty_check),'error');
                    continue;
                    xtc_redirect(xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(array('action','id','type'))));
                    exit;
                }

                $Variation = new \stdClass();
                $Variation->Quantity = (int)$new_qty;
                $Variation->SKU = (string)$sku;
                $Variations->Variation[] = $Variation;
            }
            $item->Variations = $Variations;
        }else{
                $new_qty = xtc_db_input($_POST['new_qty']);
                $refill_qty = $new_qty-$auction->getQuantity();
                // select_set_multiple handling
                if($auction->getSelectSetMultiple()>0){
                    $refill_qty = $refill_qty*$auction->getSelectSetMultiple();
                }

                // BESTANDSPRUEFUNG
                $SQ = new products_quantity($auction->getProductsId());
                $products_stock = $SQ->get_available1_qty();

                //printf('Eingabe: %s, AV1: %s, refill_qty: %s',$new_qty,$products_stock,$refill_qty);
                //exit;
    //			if( $products_stock < $refill_qty && STOCK_CHECK == 'true'){
                if( $products_stock < $new_qty && STOCK_CHECK == 'true'){
                    $messageStack->add_session(sprintf(REVISE_ITEM_QUANTITY_ERROR,$ebay_id,$new_qty).' (V1: '.$products_stock.' / Revise '.$new_qty.')','error');
                    xtc_redirect(xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(array('action','id','type'))));
                    exit;
                }

                $item = new \stdClass();
                $item->ItemID = $ebay_id;
                $item->Quantity = (int)$new_qty;
        }
        
        $res = $EBAYAPI->revise_auction($id, $item);
        if($res != ''){
            $messageStack->add_session($res,'error' );
        }else{
            if(isset($_REQUEST['new_qty']) and is_array($_REQUEST['new_qty'])){
                foreach($_REQUEST['new_qty'] as $sku => $new_qty){
                    if(!isset($_REQUEST['revise_qty'][$sku]) or $_REQUEST['revise_qty'][$sku] != '1'){
                        continue;
                    }
                    $post_qty = (int)xtc_db_input($new_qty);
                    $eav = \YES4Trade\Model\ebay_auctions_variations::get_by_ebay_auctions_id_and_sku(
                        intval($id),$sku,
                        ['products_id','quantity','quantity_sold','revise_counter']
                    );
                    $pID = intval($eav->products_id);
                    $qty_comment = sprintf(
                        'Manuelle Aenderung der Anzahl (neu: %s) in Auktion %s.',
                        $post_qty,$ebay_id
                    );
                    \YES4Trade\Model\ebay_auctions_variations::update_ebay_auctions_variations_by_ebay_auctions_id_and_sku([
                        'revise_counter'=>$eav->revise_counter + ($post_qty-$eav->quantity),
                        'quantity'=>intval($post_qty), 
                        'ebay_auctions_id'=>intval($id),
                        'sku'=>"$sku",
                    ]);
                    ebay_auction::add_history($id, $post_qty, sprintf(
                            "[%s::change_qty] Variante SKU %s: %s",
                            basename(__FILE__), $sku, $qty_comment
                    ));
                    $variation_update_qty = $post_qty-$eav->quantity;
                    $staffel_comment = '';
                    if(defined('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS') and MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS == 'True'){
                        if($auction->has_staffelpreise()){
                            $variation_update_qty = $variation_update_qty*$auction->get_staffelpreis_quantity_from_sku($sku);
                            $staffel_comment = 'Staffelpreis Menge '.$auction->get_staffelpreis_quantity_from_sku($sku);
                        }
                    }
                    yes_update_products_in_auction_quantity($pID, 
                        yes_products_calc_in_auction_quantity(intval($pID)), 
                        $qty_comment.$staffel_comment,
                        true // overwrite!
                    );
                }
            }else{
                $post_qty = $new_qty;
                $qty_comment = sprintf('Manuelle Aenderung der Anzahl (neu: %s) in Auktion %s.',$post_qty,$ebay_id);
                \YES4Trade\Model\ebay_auctions::update_ebay_auction([ // update revise_counter and quantity
                    'revise_counter'=>intval($auction->getReviseCounter()) + intval($post_qty) - intval($auction->getQuantity()),
                    'quantity'=>intval($post_qty),
                    'id'=>intval($id)
                ]);
                ebay_auction::add_history($id, $post_qty, sprintf(
                        "[%s::change_qty] %s",
                        basename(__FILE__), $qty_comment
                ));
                // wir berechnen nix selber, sondern schreiben den aktuellen
                // in_auction Wert einfach neu
                yes_update_products_in_auction_quantity($auction->getProductsId(),
                    yes_products_calc_in_auction_quantity($auction->getProductsId()),
                    $qty_comment,
                    true // overwrite!
                );
                
            }
            $messageStack->add_session(sprintf(REVISE_ITEM_QTY_SUCCESFUL,$ebay_id,$post_qty),'success');
        }
        if(isset($_REQUEST['from']) and $_REQUEST['from'] != ''){
            xtc_redirect(urldecode($_REQUEST['from']));
        }else{
            xtc_redirect(xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(array('action','id','type'))));
        }
        break;
    case 'change_description':
        if(!isset($_REQUEST['id'])){
            throw new Exception('YES: Missing "id" Request Parameter');
        }
        $id = (int)xtc_db_input($_REQUEST['id']);
        $query = xtc_db_query(sprintf(
                "SELECT ea.ebay_products_id FROM ebay_auctions ea LEFT JOIN ebay_products ep ON ep.id=ea.ebay_products_id WHERE ea.id='%s' AND ep.id IS NOT NULL",
                $id
        ));
        if(xtc_db_num_rows($query)){
            $record = xtc_db_fetch_array($query);
            $data = $EBAYAPI->getProductDetails($record['ebay_products_id']);
            $data = xtc_db_prepare_input($data);
            $wrap1 = "";
            $orig_smarty = $smarty;
            include("ebayapi_wrap.php");

            $item = new \stdClass();
            $item->ItemID = $ebay_id;
            $item->Description = $wrap1;
            $res = $EBAYAPI->revise_auction($id, $item);

            if($res != ''){
                $msg = yes_decode_string(strip_tags($res));
            }else{
                $msg = TEXT_EBAY_DESCRIPTION_UPDATED;
            }
        }else{
            $msg = ERROR_CART_ITEM_NOT_FOUND;
        }
        header('Content-Type: text/html; charset='.CHARSET);
        die($msg);
        break;
}
$res = $ebaycalls->tradingQuery($ebay_user,'GetItem',$site_id,[
    'ItemID'=>$ebay_id
]);
if($EBAYAPI->isGood($res)){
    $smarty_auction_array['converted_start_price'] = $res->Item->ListingDetails->ConvertedStartPrice;
    $smarty_auction_array['converted_buyitnow_price'] = $res->Item->ListingDetails->ConvertedBuyItNowPrice;
}else{
    die('Auction '.$ebay_id.' invalid or cancelled');
}
$smarty->assign('auction',$smarty_auction_array);

$smarty->assign('FORM',xtc_draw_form('revise','ebayapi_cart.php',xtc_get_all_get_params(),'POST','id="revise_form"'));
$variations = $EBAYAPI->get_auction_variationset_products($id);
if(sizeOf($variations)){
    $VArray = array();
    if($EBAYAPI->isGood($res)){
        $Variations = $res->Item->Variations;
        $VariationArray = $Variations->Variation??[];
        if(!is_array($VariationArray)){
            $VariationArray = [$VariationArray];
        }
        foreach($VariationArray as $VariationType){
            $VS = array();
            foreach($VariationType->VariationSpecifics->NameValueList as $NVLT){
                $VS[ $NVLT->Name ] = $NVLT->Value;
            }
            $VArray[$VariationType->SKU] = array(
                'SKU'=>$VariationType->SKU,
                'StartPrice'=>number_format($VariationType->StartPrice,2,',','.'),
                'Quantity'=>$VariationType->Quantity,
                'QuantitySold'=>$VariationType->SellingStatus->QuantitySold,
                'VariationSpecifics'=>$VS
            );
        }
    }else{
	    die(implode("\n",$EBAYAPI->getResponseErrors($res)));
    }
}

// FUER EU OSS
$country_id = yes_get_country_id_from_iso2($auction->getCountry());

switch($_GET['type']){
	case 'bestoffer':
		$smarty->assign('INPUT_REVISE_ACTION',xtc_draw_hidden_field('revise_action','change_bestoffer'));
		$smarty->assign('INPUT_BESTOFFERAUTOACCEPTPRICE',xtc_draw_input_field('new_bestofferautoacceptprice',number_format($smarty_auction_array['bestofferautoacceptprice'],2,'.',''),'size="5" maxlength="8"'));
		$smarty->assign('INPUT_BESTOFFER_PRICE',xtc_draw_input_field('new_bestoffer_price',number_format($smarty_auction_array['bestoffer_price'],2,'.',''),'size="5" maxlength="8"'));
		break;
	case 'price':
		require_once(DIR_FS_CATALOG.'includes/classes/xtcPrice.php');
		$xtPrice = new xtcPrice(DEFAULT_CURRENCY,EBAY_CUSTOMERS_STATUS);
        $tcID = yes_eu_oss_get_products_tax_class_id(
            $smarty_auction_array['products_id'], 
            $country_id, 0
        );
		$smarty->assign([
            'FORM'=>xtc_draw_form('revise','ebayapi_cart.php',xtc_get_all_get_params(),'POST','id="revise_form" onsubmit="return false;"'),
            'CUSTOMERS_GROUP'=> xtc_get_customers_status_name(EBAY_CUSTOMERS_STATUS),
            'PRICE_SHOP'=>$xtPrice->xtcGetPrice((int)$smarty_auction_array['products_id'], true, 1,$tcID),
            'COUNTRY'=> xtc_get_country_name($country_id)
        ]);
		$smarty->assign('INPUT_REVISE_ACTION',xtc_draw_hidden_field('revise_action','change_converted_start_price'));
		if(sizeOf($variations)){
			$input = array();
			foreach($variations as $prod){
			    $specs = '';
			    if(isset($VArray[ $prod['sku'] ]['VariationSpecifics'])){
                    foreach($VArray[ $prod['sku'] ]['VariationSpecifics'] as $kspec=>$spec){
                        $specs .= sprintf('%s: %s<br />',$kspec,$spec);
                    }
			    }
                $price_yes = $xtPrice->xtcGetPrice($prod['products_id'], true,1,$tcID);
                $input[] = array(
                    'input'=>xtc_draw_input_field('new_price['.$prod['sku'].']',number_format($prod['price'],2,',','.'),'size="5" maxlength="8"'),
                    'price_yes'=>$price_yes,
                    'checkbox'=>xtc_draw_checkbox_field('revise_price['.$prod['sku'].']',1),
                    'products_id'=>$prod['products_id'],
                    'specifics'=>$specs,
                    'PRICE_SHOP'=>$price_yes,
                    'products_name'=>  xtc_get_products_name($prod['products_id']),
                    'slave_name' => xtc_get_products_slave_title($prod['products_id'],$_SESSION['languages_id'])
                );
			}
			$smarty->assign('INPUT_PRICE_VARIATIONS',$input);
		}else{
            $smarty->assign(array(
                'INPUT_PRICE'=>xtc_draw_input_field('new_price',$smarty_auction_array['startprice'],'size="5" maxlength="8"'),
                'PRICE_YES'=>$xtPrice->xtcGetPrice($auction->getProductsId(), true,1,$tcID)
            ));
		}
		break;
	case 'buyitnowprice':
        die('Nicht implementiert - Auktionshandling bitte direkt bei eBay');
		$smarty->assign('FORM',xtc_draw_form('revise','ebayapi_cart.php',xtc_get_all_get_params(),'POST','id="revise_form" onsubmit="return false;"'));
		$smarty->assign('INPUT_REVISE_ACTION',xtc_draw_hidden_field('revise_action','change_converted_buyitnow_price'));
		$smarty->assign('INPUT_BUYITNOWPRICE',xtc_draw_input_field('new_buyitnowprice',number_format((float)$smarty_auction_array['binprice'],2,'.',''),'size="5" maxlength="8"'));
		break;
	case 'qty':
		$smarty->assign('INPUT_REVISE_ACTION',xtc_draw_hidden_field('revise_action','change_qty'));
		if(sizeOf($variations)){
			$input = array();
			foreach($variations as $prod){
			    $specs = '';
			    if(isset($VArray[ $prod['sku'] ]['VariationSpecifics'])){
				foreach($VArray[ $prod['sku'] ]['VariationSpecifics'] as $kspec=>$spec){
				    $specs .= sprintf('%s: %s<br />',$kspec,$spec);
				}
			    }
			    $SQ = new products_quantity($prod['products_id']);
                            $input[] = array(
                                'input'=>xtc_draw_input_field('new_qty['.$prod['sku'].']',$prod['quantity'],'size="5" maxlength="8"'),
                                'checkbox'=>xtc_draw_checkbox_field('revise_qty['.$prod['sku'].']',1),
                                'products_id'=>$prod['products_id'],
                                'qty_phys'=>$SQ->get_products_total_qty(),
                                'qty_av1'=>$SQ->get_available1_qty(),
                                'qty_av2'=>$SQ->get_available2_qty(),
                                'products_name'=> xtc_get_products_ebay_title($prod['products_id'],$_SESSION['languages_id']),
                                'specifics'=>$specs,
                                'slave_name' => xtc_get_products_slave_title($prod['products_id'],$_SESSION['languages_id'])
                            );
			}
			$smarty->assign('INPUT_QTY_VARIATIONS',$input);
		}else{
			$smarty->assign('INPUT_QTY',xtc_draw_input_field('new_qty',$auction->getQuantity(),'size="5" maxlength="8"'));
		}
		break;
	case 'description':
	    $query = xtc_db_query(sprintf(
		    "SELECT ea.ebay_products_id FROM ebay_auctions ea LEFT JOIN ebay_products ep ON ep.id=ea.ebay_products_id WHERE ea.id='%s' AND ep.id IS NOT NULL",
		    (int)xtc_db_input($_REQUEST['id'])
	    ));
	    $smarty->assign('INPUT_REVISE_ACTION',xtc_draw_hidden_field('revise_action','change_description'));
	    $smarty->assign(array(
		'ERROR_CART_ITEM_NOT_FOUND'=>ERROR_CART_ITEM_NOT_FOUND,
		'TEXT_EBAY_UPDATE_AUCTION_DESCRIPTION'=>TEXT_EBAY_UPDATE_AUCTION_DESCRIPTION
	    ));
	    if(xtc_db_num_rows($query)){
		$smarty->assign('CART_ITEM_EXISTS',true);
	    }
	    break;
}

header('Content-Type: text/html; charset='.CHARSET);
echo $smarty->fetch(DIR_FS_ADMIN.'templates/revise_item.html');
exit;
