<?php
include('includes/classes/class.ebay.php');
$EBAYAPI = new ebayApi();
$EBAY_FOLDER_NAMES_ALLOCATION = [
        '0' => 'Inbox',
        '1' => 'Sent',
        '2' => 'Trash',
        '6' => 'Resolution Center'
];
include('includes/classes/class.ebaymessage.php');
$EM = new EbayMessage;

function setEbayMessageReadRequest(string $seller, int $site_id,string $messageId){
        global $EBAYAPI;
        $ebaycalls = new \YES4Trade\Model\ebaycalls();
        $res = $ebaycalls->tradingQuery($seller,
                'ReviseMyMessages',
                $site_id,
                [
                        'MessageIDs'=>[$messageId],
                        'Read'=>true
                ]
        );
        if(!$EBAYAPI->isGood($res)){
                return implode('<br />',$EBAYAPI->getResponseErrors());
        }
}

function setEbayMessageRead(string $messageId, $s){
        global $EBAYAPI;
        $req = $EBAYAPI->get_sdk_type_class('ReviseMyMessagesRequestType');
        $mm = $EBAYAPI->get_sdk_type_class('MyMessagesMessageIDArrayType');
        $mm->MessageID[] = $messageId;
        $req->MessageIDs = $mm;
        $req->Read = true;
        $res = $s->ReviseMyMessages($req);
        if(!$EBAYAPI->isGood($res)){
                return implode('<br />',$EBAYAPI->getResponseErrors());
        }
        return '';
}
$smarty = new yesSmarty;

$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
if(empty(constant('EBAY_USER'))){
        $messageStack->add_session('No eBay User registered.','error');
        xtc_redirect(xtc_href_link('start.php'));
}
$ebay_user = $_GET['ebay_user'] ?? EBAY_USER;
$action = $_REQUEST['action'] ?? 'summary';
$request = array();
$sandbox = (defined('EBAY_TESTMODE') and constant('EBAY_TESTMODE') == '1')?true:false;
switch($action){
        case 'test':
                $data = [[
                        'Sender' => 'eBay',
                        'RecipientUserID' => 'fa-dev',
                        'Subject' => 'Bitte bewerten Sie Ihre eBay-Käufe',
                        'MessageID' => '197255333537',
                        'Flagged' => false,
                        'Read' => true,
                        'ReceiveDate' => '2025-05-08 10:10:18',
                        'ExpirationDate' => '2026-05-08 10:10:18',
                        'ResponseDetails' => [
                                'ResponseEnabled' => false,
                        ],
                        'Folder'=>[
                                'FolderID' => $EBAY_FOLDER_NAMES_ALLOCATION[1],
                        ],
                        'Replied' => false
                ],[
                        'Sender' => 'eBay',
                        'RecipientUserID' => 'fa-dev',
                        'Subject' => 'Das ist auch so eine Nachricht',
                        'MessageID' => '18888888888888',
                        'Flagged' => true,
                        'Read' => false,
                        'ReceiveDate' => '2025-05-08 10:10:18',
                        'ExpirationDate' => '2026-05-08 10:10:18',
                        'ResponseDetails' => [
                                'ResponseEnabled' => false,
                        ],
                        'Folder'=>[
                                'FolderID' => $EBAY_FOLDER_NAMES_ALLOCATION[0],
                        ],
                        'Replied' => false

                ]];
                $smarty->assign('FOLDER_MESSAGES',$data);
                $smarty->display('ebay_message.folder.html');
                exit;
                break;
        case 'set_read':
                $marked = 0;
                foreach($_REQUEST['ebay_mymessage_id'] as $emID){
                        $query = xtc_db_query(sprintf(
                                "SELECT messageid,folder,recipientuserid FROM ebay_mymessage WHERE ebay_mymessage_id='%s'",
                                (int)xtc_db_input($emID)
                        ));
                        $record = xtc_db_fetch_array($query);
                        $ebaycalls = new \YES4Trade\Model\ebaycalls();
                        $res = $ebaycalls->tradingQuery(
                                $record['recipientuserid'],
                                'ReviseMyMessages',
                                $EBAYAPI->get_site_id_from_name(constant('EBAY_SITE')),
                                [
                                        'FolderID' => (int)$record['folder'],
                                        'MessageIDs' => [
                                                ['MessageID'=>(int)$record['messageid']]
                                        ],
                                        'Read' => true
                                ]
                        );

                        if(!$EBAYAPI->isGood($res)){
                                $messageStack->add_session(implode('<br />',$EBAYAPI->getResponseErrors($res)),'error');
                        }
                        xtc_db_query(sprintf(
                                "UPDATE ebay_mymessage SET is_read=1 WHERE ebay_mymessage_id='%s'",
                                (int)xtc_db_input($emID)
                        ));
                        $marked++;
                }
                $messageStack->add_session(sprintf('Es wurden %s Nachrichten als gelesen markiert.',$marked),'success');
                xtc_redirect(xtc_href_link('ebayapi_membermessages.php',xtc_get_all_get_params(array('action','ebay_mymessage_id')).'action=list_msg'));
                break;
        case 'view_item':
                $ebaycalls = new \YES4Trade\Model\ebaycalls();
                $res = $ebaycalls->tradingQuery($_GET['ebay_user'], 
                        'GetMyMessages',
                        $EBAYAPI->get_site_id_from_name(constant('EBAY_SITE')),
                        [
                                'MessageIDs' => [
                                        ['MessageID'=>$_GET['ebay_mymessage_id']]
                                ],
                                'DetailLevel' => 'ReturnMessages'
                        ]
                );
                if(!$EBAYAPI->isGood($res)){
                        die(implode('<br />',$EBAYAPI->getResponseErrors($res)));
                }
                $msg = $res->Messages->Message;
                if($msg->Read === false){                       
                        $setread = setEbayMessageReadRequest(
                                $_GET['ebay_user'], 
                                $EBAYAPI->get_site_id_from_name(constant('EBAY_SITE')),
                                $msg->MessageID
                        );
                        if($setread != ''){
                                printf('<div class="errorMsg">%s</div>',
                                        $setread
                                );
                        }
                }
                $msgtext = str_replace(array("\\r","\\n"),'',$msg->Text);
                echo $msgtext;
                exit;
                break;
        case 'send':
                $error = false;
                if( !xtc_not_null($_GET['ebay_mymessage_id']) ){
                        $messageStack->add_session('Es wurde keine MessageID &uuml;bergeben.','error');
                        $error = true;
                }
                if( !xtc_not_null($_POST['responsebody']) ){
                        $messageStack->add_session('Es wurde kein Text &uuml;bergeben.','error');
                        $error = true;
                }
                if(!$error){
                        $query = xtc_db_query("SELECT externalmessageid,messageid,ebay_id,sender,subject,responseurl FROM ebay_mymessage WHERE ebay_mymessage_id='".xtc_db_input($_GET['ebay_mymessage_id'])."' and ebay_user='".$ebay_user."'");
                        $result = xtc_db_fetch_array($query);
                        $messageID = $result['messageid'];
                        $e_messageID=$result['externalmessageid'];

                        // DIRTTTYYY!
                        if(!xtc_not_null($result['ebay_id'])){
                                $ebay_id_array = split('\&',$result['responseurl']);
                                foreach($ebay_id_array as $k=>$v){
                                        $val = split('=',$v);
                                        if($val[0] == 'item')
                                                $ebay_id = $val[1];
                                }
                        }else{
                                $ebay_id = $result['ebay_id'];
                        }
                        $ebaycalls = new \YES4Trade\Model\ebaycalls();
                        $res = $ebaycalls->tradingQuery($ebay_user,
                                'AddMemberMessagesAAQToBidder',
                                $EBAYAPI->get_site_id_from_name(constant('EBAY_SITE')),
                                [
                                        'MemberMessage'=>[
                                                'MessageType' => 'ResponseToAAQQuestion',
                                                'RecipientID' => $result['sender'],
                                                'Body'=>$_POST['responsebody'],
                                                'ParentMessageID'=>$e_messageID
                                        ],
                                        'ItemID'=>$ebay_id
                                ]
                        );
                        if(!$EBAYAPI->isGood($res)){
                            $res_error = implode('<br />',$EBAYAPI->getResponseErrors($res));
                            $messageStack->add_session('Die Antwort wurde nicht gesendet. Fehlermeldung von eBay: '.$res_error, 'error');
                        }else{
                            $EM->save_reply($_GET['ebay_mymessage_id'],$_POST['responsebody'],$_SESSION['customer_id'],$ebay_user);
                            $messageStack->add_session('Die Antwort wurde gesendet und zur Original-Nachricht gespeichert.', 'success');
                        }
                        xtc_redirect(xtc_href_link('ebayapi_membermessages.php',xtc_get_all_get_params(array('action')).'action=list_msg'));
                }else{
                        xtc_redirect(xtc_href_link('ebayapi_membermessages.php',xtc_get_all_get_params(array('action')).'action=view_item'));
                }
                break;
        case 'view_item':
                $request['type'] = 'Nachricht ansehen';
                break;
        case 'list_msg':
                $request['type'] = 'Nachrichtenliste';
                break;
        case 'summary':
                $request['type'] = '&Uuml;bersicht';
                $ebaycalls = new \YES4Trade\Model\ebaycalls();
                $res = $ebaycalls->tradingQuery($ebay_user,
                        'GetMyMessages',
                        $EBAYAPI->get_site_id_from_name(constant('EBAY_SITE')),
                        [
                                'DetailLevel' => 'ReturnSummary',
                                'ErrorLanguage' => 'de_DE'
                        ]
                );
                if($res->Ack == 'Failure'){
                        $res_error = $res->Errors->ShortMessage.': '.$res->Errors->LongMessage;
                }
                break;
        case 'folder':
                $request['type'] = 'Details Verzeichnis '.$_GET['folderID'];
                $ebaycalls = new \YES4Trade\Model\ebaycalls();
                $res = $ebaycalls->tradingQuery($ebay_user,
                        'GetMyMessages',
                        $EBAYAPI->get_site_id_from_name(constant('EBAY_SITE')),
                        [
                                'DetailLevel' => 'ReturnHeaders',
                                'FolderID' => (int)$_GET['folderID'],
                                'ErrorLanguage' => 'de_DE'
                        ]
                );
                if(!$EBAYAPI->isGood($res)){
                    $res_error = implode('<br />',$EBAYAPI->getResponseErrors($res));
                }
                break;
        case 'save':
                switch($_POST['messageType']){
                        case '0':
                            $saved_alerts = 0;
                                for($i=0;$i<sizeOf($_POST['alert_id']);$i++){
                                        $ebaycalls = new \YES4Trade\Model\ebaycalls();
                                        $res = $ebaycalls->tradingQuery($ebay_user,
                                                'GetMyMessages',
                                                $EBAYAPI->get_site_id_from_name(constant('EBAY_SITE')),
                                                [
                                                        'DetailLevel' => 'ReturnMessages',
                                                        'FolderID' => (int)$_GET['folderID'],
                                                        'AlertIDs'=>[$_POST['alert_id'][$i]],
                                                        'ErrorLanguage' => 'de_DE'
                                                ]
                                        );
                                        if(!$EBAYAPI->isGood($res)){
                                            $res_error = implode('<br />',$EBAYAPI->getResponseErrors($res));
                                        }else{
                                            $alerts = $res->Alerts;
                                            foreach($alerts as $k=>$alert){
                                                    if(in_array($alert->AlertID,$_POST['alert_id'])){
                                                        $saved_alerts++;
                                                            $EM->save_message('0',$_GET['folderID'],$alert,$ebay_user);
                                                    }
                                            }
                                        }
                                }
                                $messageStack->add_session('Es wurden '.$saved_alerts.' neue Ebay Warnungen gespeichert.', 'success');
                                break;
                        case '1':
                            $saved_messages = 0;
                                for($i=0;$i<sizeOf($_POST['msg_id']);$i++){
                                        $ebaycalls = new \YES4Trade\Model\ebaycalls();
                                        $res = $ebaycalls->tradingQuery($ebay_user,
                                                'GetMyMessages',
                                                $EBAYAPI->get_site_id_from_name(constant('EBAY_SITE')),
                                                [
                                                        'DetailLevel' => 'ReturnMessages',
                                                        'FolderID' => (int)$_GET['folderID'],
                                                        'ErrorLanguage' => 'de_DE',
                                                        'MessageIDs' => [$_POST['msg_id'][$i]]
                                                ]
                                        );
                                        if(!$EBAYAPI->isGood($res)){
                                            $res_error = implode('<br />',$EBAYAPI->getResponseErrors($res));
                                        }else{
                                            $messages = $res->Messages->Message;
                                            foreach($messages as $k=>$message){
                                                    if(in_array($message->MessageID,$_POST['msg_id'])){
                                                            $saved_messages++;
                                                            $EM->save_message('1',$_GET['folderID'],$message,$ebay_user);
                                                    }
                                            }
                                        }
                                }
                                $messageStack->add_session('Es wurden '.$saved_messages.' neue Nachrichten gespeichert.', 'success');
                                break;
                }
                xtc_redirect(xtc_href_link('ebayapi_membermessages.php',xtc_get_all_get_params(array('action')).'action=folder'));
                break;
}
//$request['totalcount'] = $res->getTotalMessageCount();
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<script type="text/javascript">
function really_delete_email(eId) {
	yes = confirm('<?php echo JS_CONFIRM_REALLY_DELETE_ITEMS; ?>');
	if(yes) {
		window.location.href="ebay_email.php?action=del&eId[]="+eId;
	}
}
</script>
<?php
include('includes/ebayapi.js.php');
$buttons = array();
$smarty->assign(array(
    'HEADING_TITLE'=>sprintf(HEADING_TITLE,$request['type']),
    'SHOW_HEADER'=>1,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));
$smarty->display('mymessages.html');
$smarty->assign('SHOW_HEADER',0);
?>
<table border="0" cellpadding="0" cellspacing="0">
<?php echo xtc_draw_form('ebayuserselect','ebayapi_membermessages.php','','get'); ?>
<tr>
        <td class="main">Ebay User</td>
        <td class="main"><?php echo xtc_draw_pull_down_menu('ebay_user',xtc_get_ebay_users(),$ebay_user); ?></td>
        <td class="main"><input border="0" type="image" src="images/icon_save.gif" alt="Ebay User" title="Ebay User"></td>
</tr>
</form>
</table>
<br />
<?php
switch($action){
    case 'summary':
        if(!isset($res_error)){
            $sum = $res->Summary;
            $folders = $sum->FolderSummary;
?>

            <table border="0">
<?php
            foreach($folders as $k=>$folder){
?>
            <tr class="dataTableHeadingRow">
                    <td class="dataTableHeadingContent" colspan="2" style="font-size: 1.5em;"><a href="<?php echo xtc_href_link('ebayapi_membermessages.php',xtc_get_all_get_params(array('action','folderID')).'action=folder&folderID='.$folder->FolderID); ?>"><u>Nachrichten-Ordner Nr: <?php echo $folder->FolderID; ?></u></a></td>
            </tr>

            <tr>
                    <td class="main"><b>Benachrichtigungen Gesamt:</b></td><td class="main"><?php echo $folder->TotalMessageCount; ?></td>
            </tr>
            <tr>
                    <td class="main"><b>Neue Nachrichten:</b></td><td class="main"><?php echo $folder->NewMessageCount; ?></td>
            </tr>
            <?php if(isset($folder->TotalAlertCount)){ ?>
            <tr>
                    <td colspan="2" class="main"><?php echo xtc_draw_separator('pixel_black.gif'); ?></td>
            </tr>

            <tr>
                    <td class="main"><b>Warnungen Gesamt:</b></td><td class="main"><?php echo $folder->TotalAlertCount; ?></td>
            </tr>
            <tr>
                    <td class="main"><b>Neue Warnungen:</b></td><td class="main"><?php echo $folder->NewAlertCount; ?></td>
            </tr>
            <?php } ?>


<?php
            } // end foreach folders
            echo '</table>';
        }else{
                echo $res_error;
        }
        break;
    case 'folder':
?>
            <p><i>Das Beantworten von Nachrichten findet direkt auf eBay statt. Wenn Sie den "Beantworten" Button klicken, achten Sie darauf, dass Sie mit dem richtigen Sellerkonto bei eBay angemeldet sind.</i></p>
            
<table class="yesListTable_minimal">
    <thead>
        <tr>
            <th>Sender</th>
            <th>Empf&auml;nger</th>
            <th>Subject</th>
            <th>Markiert</th>
            <th>Erhalten am</th>
            <th>Verf&auml;llt am</th>
            <th>Auktion</th>
            <th>Beantworten</th>
            <th>Beantwortet</th>
        </tr>
    </thead>
    <tbody>
<?php                        
        foreach($res->Messages->Message as $m){
            if($m->ResponseDetails->ResponseEnabled === True){
                $response = sprintf('<a href="%s" target="_blank"><button type="button" class="ui-button ui-corner-all ui-state-default" style="padding:3px;">Beantworten</button></a>',
                    $m->ResponseDetails->ResponseURL,
                    YES
                );
            }else{
                $response = NO;
            }
            $subject = sprintf(
                    '<a %s id="?action=view_item&ebay_user=%s&ebay_mymessage_id=%s" href="javascript:;" class="lbOn_nostyle">%s</a>',
                    ($m->Read === false) ? 'style="font-weight: bold;"' : '',
                    $ebay_user,
                    $m->MessageID,
                    $m->Subject
            );
            echo '<tr>';
            printf('<td>%s</td>', $m->Sender);
            printf('<td>%s</td>', $m->RecipientUserID);
            printf('<td>%s</td>', $subject);
            printf('<td>%s</td>', ($m->Flagged===True)?YES:NO);
            printf('<td>%s</td>', yes_date_short($m->ReceiveDate,true));
            printf('<td>%s</td>', yes_date_short($m->ExpirationDate,true));
            printf('<td>%s</td>', $m->ItemID);
            printf('<td>%s</td>', $response);
            printf('<td>%s</td>', ($m->Replied===True) ? YES:NO);
            echo '</tr>';
        }
?>
    </tbody>
</table>
<?php    
        break;
}
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
