<?php
$rawData = file_get_contents("php://input");
    // this returns null if not valid json
$json = json_decode($rawData);
if(empty($json->MODUS) or empty($json->TOKEN)){
    die('Invalid Call');
}
include('includes/cron_application_top.php');
include(DIR_WS_CLASSES.'class.ebay.php');

/**
 * 
 * @param Object $response
 */
function yes_Taxonomy_response_error_handler($response){
    if (isset($response->errors)) {
        foreach ($response->errors as $error) {
            die(json_encode(array(
               'ERROR'=>sprintf( "%s: %s\n%s",
                    $error->errorId,
                    $error->message,
                    $error->longMessage)                      
            )));
        }
    }
}

/**
 * Output the result of calling the service operation.
 * 
 * @param Object $response
 */
function yes_Taxonomy_response_status($response){
//    printf("\nStatus Code: %s\n\n", $response->getStatusCode());
}

$ini_conf = ebayApi::get_ebay_config_ini();

$mode = $json->MODUS;
$config_env = (main::isDev(true)) ? 'sandbox' : 'production';
$config = [
    $config_env=>[
        'oauthToken'=>$json->TOKEN,
        /*
        'credentials' => [
            'devId' => $ini_conf['ebay-config']['dev-key-prod'],
            'appId' => $ini_conf['ebay-config']['app-key-prod'],
            'certId' => $ini_conf['ebay-config']['cert-id-prod'],
        ],
        'ruName'=>YES_UNIQUE_RUNAME*/
    ]
];
/*
$config = [
    'production'=>[
        'credentials' => [
            'devId' => 'J73R2RS56Y8ZX5117F8445AI1I9US7',
            'appId' => 'AGRICONSULG95XRZ5D2VG45J1S55LB',
            'certId' => 'K15V295F918$251A4EYQ1-O29ZP6O1',
        ],
        'ruName'=>'YES_UNIQUE_RUNAME'
    ]
];*/

/**
 * Create the service object.
 */
$service = new Services\TaxonomyService([
    'authorization'   => $config[$config_env]['oauthToken'],
    'sandbox'=>main::isDev(true)
]);

/**
 * Create the request object.
 */
switch($mode){
    /**
     * DE=77
     * Sitebasiert die Default Category ID von eBay holen
     */
    case 'GetADefaultCategoryTreeId':
        $request = new Types\GetADefaultCategoryTreeIdRestRequest();
        $request->marketplace_id = "".$json->PARAMS->SITE_ID;
        /**
         * Send the request.
         */
        $response = $service->getADefaultCategoryTreeId($request);
        yes_Taxonomy_response_status($response);
        yes_Taxonomy_response_error_handler($response);
        die(json_encode(array(
            'ERROR'=>'',
            'DATA'=>array(
                'CATEGORY_TREE_ID'=>$response->categoryTreeId
            )
        )));
        exit;
        break;
    case 'GetItemAspectsForCategory':
        $request = new Types\GetItemAspectsForCategoryRestRequest();
        /**
         * Note how URI parameters are just properties on the request object.
         */
        $request->category_tree_id = (string)$json->PARAMS->CATEGORY_TREE_ID; //$response->categoryTreeId;
        $request->category_id = (string)$json->PARAMS->CATEGORY_ID;
        /**
         * Send the request.
         */
        $res_raw = $service->getItemAspectsForCategory($request);
        $response = json_decode($res_raw);
        
        yes_Taxonomy_response_status($response);
        yes_Taxonomy_response_error_handler($response);
        die(json_encode(array(
            'ERROR'=>'',
            'DATA'=>array(
                'ASPECTS'=>$response->aspects
            )
        )));
        break;
}






