<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/
require('includes/application_top.php');
require('includes/classes/class.ebay.php');
$EBAYAPI = new ebayAPI();

define('PAGE_HEADING_TITLE','eBay Versandarten konfigurieren - (%s / %s)');
define('ERROR_NO_EBAY_SELLER_AVAILABLE','Es ist kein Standard eBay Seller konfiguriert.');
define('BUTTON_INPUT_SITE','eBay Site wechseln');
define('PAGE_INTRO','Es gibt bei Ebay f&uuml;r diverse L&auml;nder und Ebay-Seiten eine grosse Anzahl an Versandmethoden zum ausw&auml;hlen. Wir bieten Ihnen hier die M&ouml;glichkeit festzulegen, welche der Versandarten (national und international) Sie in der Konfiguration Ihrer Ebayprodukte zur Verf&uuml;gung haben wollen.');
define('MSG_SUCCESS_SAVED','Es wurden %d Versandarten %s gespeichert.');
$codes = array();
$esm_site = intval($_REQUEST['site'] ?? '77');
if(!defined('EBAY_USER') or empty(EBAY_USER) and $_GET['seller'] === null){
    die(ERROR_NO_EBAY_SELLER_AVAILABLE);
}
$seller = $_GET['seller'] ?? EBAY_USER;
$action = $_REQUEST['action'] ?? '';
$source = $_REQUEST['source'] ?? 'national';


switch($action){
    case 'save':
        xtc_db_query(sprintf(
            "DELETE FROM ebay_shippingmethods WHERE source='%s' AND site='%d'",
            $source, $esm_site
        ));
        for($i=0;$i<sizeOf($_POST['code']);$i++){
            $insert_sql_array = [
                'shippingmethod'=>$_POST['code'][$i],
                'source'=>$source,
                'site'=>$esm_site
            ];
            xtc_db_perform('ebay_shippingmethods', $insert_sql_array);
        }
        $messageStack->add_session(
            sprintf(MSG_SUCCESS_SAVED,
                sizeOf($_POST['code']),$source
            ),
            'success'
        );
        xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action'])));
        break;
}


$available_sites = array();
$esl = \YES4Trade\Model\ebay_sites::get_list();
foreach($esl as $es){
    $available_sites[] = [
        'id'=>(int)$es->id,
        'text'=>$es->site_name
    ];
}
$match = false;
foreach($available_sites as $as){
    if($as['id']==$esm_site){
        $match = true;
    }
}
if(!$match){
    $esm_site = 77;
}

$methods = [];
$method_query = xtc_db_query(sprintf(
    "SELECT shippingmethod FROM ebay_shippingmethods WHERE source='%s' AND site='%d'",
    $source, $esm_site
));
while($method = xtc_db_fetch_array($method_query)){
    $methods[] = $method['shippingmethod'];
}
if(ebayApi::oauth2_refreshtoken_exists($seller)){
        if(!ebayApi::oauth2_usertoken_exists($seller) or ebayApi::get_oauth2_usertoken_lifetime($seller) < 1){
            try{
                ebayApi::refresh_oauth2_usertoken($seller);
            }catch(Exception $e){
                $api_error = 'refresh_oauth2_usertoken() for seller '.$seller.'  '.$e->getMessage();
            }
        }
}

$ebaycalls = new \YES4Trade\Model\ebaycalls();
$res = $ebaycalls->tradingQuery($seller,'GeteBayDetails',$esm_site,[
    'DetailName'=>'ShippingServiceDetails'
]);
$error = '';
if(!$EBAYAPI->isGood($res)){
    $error = implode('<br />',$EBAYAPI->getResponseErrors($res));
}else{
    if($res->Ack == 'Failure'){
        $error_array = [];
        foreach($res->Errors as $ErrorType){
            $error_array[] = sprintf('<div style="color: red; padding: 15px;"><i>[%s #%s]</i> <b>%s</b><br />%s</div>',
                $ErrorType->ErrorClassification,
                $ErrorType->ErrorCode,
                $ErrorType->ShortMessage,
                $ErrorType->LongMessage,
            );
        }
        $error = implode('',$error_array);
    }else{
        $ShDetails = $res->ShippingServiceDetails;
        $codes = array();
        foreach($ShDetails as $detail){
            $show = true;
            switch($source){
                case 'national':
                    if(isset($detail->InternationalService)){
                        $show = false;
                    }
                    break;
                case 'international':
                    if(!isset($detail->InternationalService)){
                        $show = false;
                    }
                    break;
            }
            if(!$show){
                continue;
            }
            $codes[] = array(
                'id'=>$detail->ShippingServiceID,
                'text'=>$detail->Description,
                'code'=>$detail->ShippingService,
                'saved'=>in_array($detail->ShippingService,$methods)
            );
        }
    }
}
yes_draw_pre_header();
yes_draw_header(TITLE);

$smarty = new yesSmarty;
$smarty->assign([
    'HEADING_TITLE'=>sprintf(PAGE_HEADING_TITLE,$EBAYAPI->get_site_name_from_id($esm_site),$seller),
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'FORM'=>xtc_draw_form('esm_form',basename(__FILE__),'','GET'),
    'INPUT_SITE'=>xtc_draw_pull_down_menu('site',$available_sites,$esm_site),
    'BUTTON_INPUT_SITE'=>BUTTON_INPUT_SITE,
    'PAGE_INTRO'=>PAGE_INTRO,
    'ERROR'=>$error,
    'SOURCE'=>$source,
    'LINK_SWITCH_TO_INTERNATIONAL'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['source']).'source=international'),
    'LINK_SWITCH_TO_NATIONAL'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['source']).'source=national'),
    'SAVE_FORM'=>xtc_draw_form('save_methods','ebayapi_shippingmethods.php','action=save&site='.$esm_site.'&source='.$source),
    'SAVED_METHODS'=>$methods,
    'CODES'=>$codes,
    'BUTTON_SAVE_ITEMS'=>IMAGE_SAVE,
]);
$smarty->display('ebayapi_shippingmethods.html');
require(DIR_WS_INCLUDES . 'footer.php'); 
require(DIR_WS_INCLUDES . 'application_bottom.php'); 
