<?php
include('includes/cron_application_top.php');
// Basispfad außerhalb des Webroots
$baseDir = \main::get_exportdata_path();
if (!isset($_GET['file'])) {
    http_response_code(400);
    exit('Request invalid.');
}

// Originaler Pfad aus URL (z. B. "orders/2025/order-6753.pdf")
$relativePath = $_GET['file'];

// Wichtig: Pfad normalisieren und gegen Manipulation absichern
$realPath = realpath($baseDir . $relativePath);

// Sicherheitscheck: Pfad muss im erlaubten Verzeichnis liegen
if ($realPath === false || strpos($realPath, realpath($baseDir)) !== 0) {
    http_response_code(404);
    exit('Request parameter invalid.');
}

// Existiert die Datei?
if (!file_exists($realPath)) {
    http_response_code(404);
    exit('Request parameter invalid');
}

// MIME-Type automatisch bestimmen
$finfo = finfo_open(FILEINFO_MIME_TYPE);
$mimeType = finfo_file($finfo, $realPath);
finfo_close($finfo);

// Datei ausliefern
header('Content-Type: ' . $mimeType);
header('Content-Disposition: inline; filename="' . basename($realPath) . '"');
header('Content-Length: ' . filesize($realPath));
readfile($realPath);
exit;