<?php
use Phpfastcache\CacheManager;
use Phpfastcache\Config\ConfigurationOption;
@setlocale(LC_TIME, 'de_DE');
date_default_timezone_set('Europe/Berlin');
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
define('YES_SQL_EMPTY_DATE','0000-00-00 00:00:00');


  // Start the clock for the page parse time log
  define('PAGE_PARSE_START_TIME', microtime());

  define('VERSION_OF_JQUERY_UI','1.8.2');
  define('VERSION_OF_JQUERY','1.4.2');

// Set the level of error reporting
if (function_exists('ini_set')) {
  ini_set('session.use_trans_sid', 0);
}

// Set the local configuration parameters - mainly for developers or the main-configure
require('includes/configure.php');
require('includes/filenames.php');
require(DIR_FS_CATALOG.'includes/global_functions.php');
require_once(DIR_FS_CATALOG.'includes/classes/vendor/autoload.php');
define('YES_PHPFASTCACHE_METHOD','files');
define('YES_PHPFASTCACHE_TAG_NEW_ORDERS','new_orders');
define('YES_PHPFASTCACHE_STATS_EXPIRE',60*60*24);
require_once(DIR_WS_CLASSES. 'ACK.php');
define('CHARSET','UTF-8');
include(DIR_FS_CATALOG.'includes/php_deprecated_functions.php');

// NEUE PHPMAILER VERSION
require_once(DIR_FS_DOCUMENT_ROOT.'includes/classes/PHPMailer-master/src/PHPMailer.php');
require_once DIR_FS_DOCUMENT_ROOT.'includes/classes/PHPMailer-master/src/Exception.php';
require_once DIR_FS_DOCUMENT_ROOT.'includes/classes/PHPMailer-master/src/PHPMailer.php';
require_once DIR_FS_DOCUMENT_ROOT.'includes/classes/PHPMailer-master/src/SMTP.php';

  // new storage-quantity handler
require('includes/classes/class.storagequantity.php');

require_once(DIR_FS_INC . 'xtc_get_products_not_shipped.inc.php');
require_once(DIR_FS_INC . 'xtc_get_products_in_reclamations.inc.php');
require_once(DIR_FS_INC . 'xtc_get_products_at_amazon.inc.php');
require_once(DIR_FS_INC . 'xtc_get_storage_name.inc.php');
require_once(DIR_FS_INC.'yes_update_products_in_auction_quantity.inc.php');
require_once(DIR_FS_INC . 'yes_get_products_properties_id_array.inc.php');
require_once(DIR_FS_INC . 'yes_get_products_vpe_string.inc.php');
require_once(DIR_FS_INC . 'yes_amazon.inc.php');
require_once(DIR_FS_INC . 'yes_cdn.inc.php');
require_once(DIR_FS_INC . 'yes_product_margenrechner.inc.php');
require_once(DIR_FS_INC.'yes_encode_string.inc.php');
require_once(DIR_FS_INC.'yes_decode_string.inc.php');
require_once(DIR_WS_CLASSES . 'jsmin.php');
require_once(DIR_WS_CLASSES . 'module_attachments.php');
require_once(DIR_FS_INC . 'yes_push.inc.php');
require_once(DIR_FS_INC.'yes_get_products_properties_values_from_shopping_cart_id.inc.php');
require_once(DIR_FS_INC . 'yes_eu_oss.inc.php');

require('includes/config.ebayapi.inc.php');
define('SQL_CACHEDIR',DIR_FS_CATALOG.'cache/');

require(DIR_FS_CATALOG . 'includes/classes/class.db.php');
require(DIR_FS_CATALOG . 'includes/classes/shipping_default_class.php');
require_once(DIR_FS_INC.'yes_db_query.inc.php');
$yes_db_class_instance = new db(0);
if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
    require_once("includes/classes/yes_pdf.php");
}

  // Define the project version
  define('PROJECT_VERSION', 'XT-Commerce v3.0.1');

  // Set the length of the redeem code, the longer the more secure
  define('SECURITY_CODE_LENGTH', '6');

  // Used in the "Backup Manager" to compress backups
  define('LOCAL_EXE_GZIP', '/usr/bin/gzip');
  define('LOCAL_EXE_GUNZIP', '/usr/bin/gunzip');
  define('LOCAL_EXE_ZIP', '/usr/local/bin/zip');
  define('LOCAL_EXE_UNZIP', '/usr/local/bin/unzip');

require_once('includes/database_tables.php');

// include needed functions
require_once(DIR_FS_INC . 'xtc_oe_customer_infos.inc.php');

require_once(DIR_FS_INC.'xtc_is_preisbindung.inc.php');
require_once(DIR_FS_INC.'xtc_get_preisbindung_value.inc.php');

require_once(DIR_FS_INC . 'xtc_db_connect.inc.php');
require_once(DIR_FS_INC . 'xtc_db_close.inc.php');
require_once(DIR_FS_INC . 'xtc_db_error.inc.php');
require_once(DIR_FS_INC . 'xtc_db_query.inc.php');
require_once(DIR_FS_INC . 'xtc_db_queryCached.inc.php');
require_once(DIR_FS_INC . 'xtc_db_perform.inc.php');
require_once(DIR_FS_INC . 'xtc_db_fetch_array.inc.php');
require_once(DIR_FS_INC . 'xtc_db_num_rows.inc.php');
require_once(DIR_FS_INC . 'xtc_db_data_seek.inc.php');
require_once(DIR_FS_INC . 'xtc_db_insert_id.inc.php');
require_once(DIR_FS_INC . 'xtc_db_free_result.inc.php');
require_once(DIR_FS_INC . 'xtc_db_fetch_fields.inc.php');
require_once(DIR_FS_INC . 'xtc_note.inc.php');
require_once(DIR_FS_INC . 'xtc_db_output.inc.php');
require_once(DIR_FS_INC . 'xtc_db_input.inc.php');
require_once(DIR_FS_INC . 'xtc_db_prepare_input.inc.php');
require_once(DIR_FS_INC . 'xtc_get_ip_address.inc.php');
require_once(DIR_FS_INC . 'xtc_setcookie.inc.php');
require_once(DIR_FS_INC . 'xtc_validate_email.inc.php');
require_once(DIR_FS_INC . 'xtc_not_null.inc.php');
require_once(DIR_FS_INC . 'xtc_add_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_get_tax_rate.inc.php');

require_once(DIR_FS_INC.'yes_get_products_images.inc.php');
require_once(DIR_FS_INC.'cartesian_functions.inc.php');


// customization for the design layout
define('BOX_WIDTH', 0); // how wide the boxes should be in pixels (default: 125)

// Some definitions for Order Edit must move to db next time.
define('ORDERS_EDIT_TAX_STATUS', 'true');

// Define how do we update currency exchange rates
// Possible values are 'oanda' 'xe' or ''
define('CURRENCY_SERVER_PRIMARY', 'oanda');
define('CURRENCY_SERVER_BACKUP', 'xe');

// Use the DB-Logger
define('STORE_DB_TRANSACTIONS', 'false');

// make a connection to the database... now
xtc_db_connect() or die('Unable to connect to database server!');
require_once(DIR_WS_CLASSES.'YES4Trade/autoload.php');
require_once(DIR_WS_CLASSES.'main.php');

$secure_path = main::get_secure_path();
$fc_config = array(
    "path" => $secure_path.DIRECTORY_SEPARATOR.'fastcache'
);

if(!is_dir($fc_config['path'])){
    mkdir($fc_config['path']) or die('Cant create fastcache dir');
    chmod($fc_config['path'],0777) or die('Cant give write access to fastcache dir');
}
// Setup File Path on your config files
CacheManager::setDefaultConfig(new ConfigurationOption([
  'path' => $fc_config['path'],
  'defaultTtl' => 3600,
]));
$InstanceCache = CacheManager::getInstance(YES_PHPFASTCACHE_METHOD);

$key = 'configuration'; // vereinheitlicht
$CachedString = $InstanceCache->getItem($key);
if (!$CachedString->isHit()) {
    // set application wide parameters
    $defines_array = [];
    $configuration_query = xtc_db_query('select configuration_key as cfgKey, configuration_value as cfgValue from ' . TABLE_CONFIGURATION . '');
    while ($configuration = xtc_db_fetch_array($configuration_query)) {
      $defines_array[] = ['key'=>$configuration['cfgKey'],'value'=>$configuration['cfgValue']];
    }
    $CachedString->set($defines_array)->expiresAfter(0);//configuration
    $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
}else{
    $defines_array = $CachedString->get();
}
foreach($defines_array as $cnfg){
  if(!defined($cnfg['key']) and $cnfg['key'] != 'MAX_DISPLAY_SEARCH_RESULTS'){
    define($cnfg['key'], $cnfg['value']);
  }
}
define('FILENAME_IMAGEMANIPULATOR',IMAGE_MANIPULATOR);
  
require_once(DIR_WS_CLASSES.'class.basics.php');
  
// Muss nach main und basics includet werden
require_once(DIR_WS_CLASSES.'specials_ebay_revise.php');

define('MAX_DISPLAY_SEARCH_RESULTS',MAX_DISPLAY_SEARCH_RESULTS_ADMIN);
define('ORDERS_EDIT_TAX_VALUE',xtc_get_tax_rate(1));
// BOF - Tomcraft - 2009-10-03 - Paypal Express Modul

require_once('../'.DIR_WS_CLASSES.'product_properties.php');

// initialize the logger class
require(DIR_WS_CLASSES . 'logger.php');
// include shopping cart class
require(DIR_WS_CLASSES . 'shopping_cart.php');

// some code to solve compatibility issues
require(DIR_WS_FUNCTIONS . 'compatibility.php');

require(DIR_WS_FUNCTIONS . 'general.php');


// define how the session functions will be used
require(DIR_WS_FUNCTIONS . 'sessions.php');

// define our general functions used application-wide
require(DIR_WS_FUNCTIONS . 'html_output.php');

// set the session name and save path
session_name('XTCsid');
session_save_path(SESSION_WRITE_DIRECTORY);
  // set the session cookie parameters
  if (function_exists('session_set_cookie_params')) {
    session_set_cookie_params(0, '/', (isset($current_domain) and xtc_not_null($current_domain) ? '.' . $current_domain : ''));
  } elseif (function_exists('ini_set')) {
    ini_set('session.cookie_lifetime', '0');
    ini_set('session.cookie_path', '/');
    ini_set('session.cookie_domain', (xtc_not_null($current_domain) ? '.' . $current_domain : ''));
  }
  // set the session ID if it exists
  if (isset($_POST[session_name()])) {
    session_id($_POST[session_name()]);
  } elseif ( (isset($request_type) and $request_type == 'SSL') && isset($_GET[session_name()]) ) {
    session_id($_GET[session_name()]);
  }

  // start the session
  $session_started = false;
  if (SESSION_FORCE_COOKIE_USE == 'True') {
      if(!isset($current_domain)) $current_domain = '';
    xtc_setcookie('cookie_test', 'please_accept_for_session', time()+60*60*24*30, '/', $current_domain);

    if (strstr(HTTP_SERVER,'localhost') or isset($_COOKIE['cookie_test'])) {
      session_start();
      $session_started = true;
    }
  } elseif (CHECK_CLIENT_AGENT == 'True') {
    $user_agent = strtolower(getenv('HTTP_USER_AGENT'));
    $spider_flag = false;

    if ($spider_flag == false) {
      @session_start();
      $session_started = true;
    }
  } else {
    @session_start();
    $session_started = true;
  }
// DIE IF ABFRAGE KANN RAUS, SOBALD YES Admin AUF HTML5 gestellt ist
if(is_file('templates/page_heading.html5.tpl')){
    session_notice_hidenote_handler();
}
  // ----------------------------------------------------------------------------
// --- NUR EIN ADMINUSER START ----
function DeleteSessionID($sessionid) {
  $orgpath = getcwd();
  chdir(PHP_BINDIR);
  chdir(session_save_path());
  $path = realpath(getcwd()).'/';
  if(file_exists($path.'sess_'.$sessionid)) {
    // Delete it here
    unlink($path.'sess_'.$sessionid);
  } else {
    // File not found
  }
  chdir($orgpath);
  xtc_db_query("delete from " . TABLE_WHOS_ONLINE . " where session_id = '" . $sessionid . "'");
}

if(defined('ALLOW_MULTIPLE_ADMINUSER') and ALLOW_MULTIPLE_ADMINUSER == 'True'){
	// keine pruefung
}else{
	$admin_limit_query = xtc_db_query(sprintf("SELECT DISTINCT(session_id) FROM whos_online WHERE customer_id='%s' and session_id!='%s'",$_SESSION['customer_id'],session_id()));
	if(xtc_db_num_rows($admin_limit_query)){
		while($admin_limit = xtc_db_fetch_array($admin_limit_query)){
			if(session_id() != $admin_limit['session_id']){
				DeleteSessionID($admin_limit['session_id']);
			}
		}
	}
}
// --- NUR EIN ADMINUSER ENDE ----
// ----------------------------------------------------------------------------

  // verify the ssl_session_id if the feature is enabled
  if ( (isset($request_type) and $request_type == 'SSL') && (SESSION_CHECK_SSL_SESSION_ID == 'True') && (ENABLE_SSL == true) && ($session_started == true) ) {
    $ssl_session_id = getenv('SSL_SESSION_ID');
    if (!isset($_SESSION['SSL_SESSION_ID'])) {
      $_SESSION['SESSION_SSL_ID'] = $ssl_session_id;
    }

    if ($_SESSION['SESSION_SSL_ID'] != $ssl_session_id) {
      session_destroy();
      xtc_redirect(xtc_href_link(FILENAME_SSL_CHECK));
    }
  }

  // verify the browser user agent if the feature is enabled
  if (SESSION_CHECK_USER_AGENT == 'True') {
    $http_user_agent = getenv('HTTP_USER_AGENT');
    if (!isset($_SESSION['SESSION_USER_AGENT'])) {
      $_SESSION['SESSION_USER_AGENT'] = $http_user_agent;
    }

    if ($_SESSION['SESSION_USER_AGENT'] != $http_user_agent) {
      session_destroy();
      xtc_redirect(xtc_href_link(FILENAME_LOGIN));
    }
  }

  // verify the IP address if the feature is enabled
  if (defined('SESSION_CHECK_IP_ADDRESS') and SESSION_CHECK_IP_ADDRESS == 'True') {
    $ip_address = xtc_get_ip_address();
    if (!xtc_session_is_registered('SESSION_IP_ADDRESS')) {
      $_SESSION['SESSION_IP_ADDRESS'] = $ip_address;
    }

    if ($_SESSION['SESSION_IP_ADDRESS'] != $ip_address) {
      session_destroy();
      xtc_redirect(xtc_href_link(FILENAME_LOGIN));
    }
  }

  // set the language
if (!isset($_SESSION['languages_id']) or !isset($_SESSION['language']) || !in_array($_SESSION['language'],['english','german']) || isset($_GET['language'])) {
    include(DIR_WS_CLASSES . 'language.php');
    $get_lang = (isset($_GET['language']) and in_array($_GET['language'],['german','english']))?$_GET['language']:null;
    if($get_lang !== null){
      $get_lang_code = ($get_lang=='german')?'de':'en';
      $lng = new language($get_lang_code);
    }else{
      $lng = new language('de');
    }
    $_SESSION['language'] = $lng->language['directory'];
    $_SESSION['languages_id'] = $lng->language['id'];

}



  // include the language translations
require(DIR_FS_LANGUAGES . $_SESSION['language'] . '/admin/'.$_SESSION['language'] . '.php');
$current_page = explode('?', basename($_SERVER['PHP_SELF']));
$current_page = $current_page[0]; // for BadBlue(Win32) webserver compatibility
if (file_exists(DIR_FS_LANGUAGES . $_SESSION['language'] . '/admin/'.$current_page)) {
  include(DIR_FS_LANGUAGES . $_SESSION['language'] . '/admin/'.  $current_page);
}

$locale_lang_default = $_SESSION['language']??(constant('DEFAULT_LANGUAGE')=='de')?'german':'english';

// KEINE AHNUNG, KANN VERMUTLICH RAUS 2025/06
if(is_file('../lang/'.$locale_lang_default.'/modules/payment/rmamazon.php')){
  require_once('../lang/'.$locale_lang_default.'/modules/payment/rmamazon.php');
}

// AUS DER dhl_print_label Sprachdatei
if (!defined('TABLE_CARRIERS')) define('TABLE_CARRIERS','carriers');
if (!defined('TABLE_ORDERS_TRACKING')) define('TABLE_ORDERS_TRACKING','orders_tracking');
define('MODULE_SHIPPING_DHLGKAPI_EU_COUNTRIES','DE,AT,BE,BG,CZ,CY,DK,EE,FI,FR,GR,HR,HU,IE,IT,LT,LU,LV,MC,MT,NL,PL,PT,RO,SK,SI,ES,SE');


switch($locale_lang_default){
  case 'german':
    setlocale(LC_TIME, 'de_DE.ISO_8859-1');
    define('DATE_FORMAT_SHORT', '%d.%m.%Y');  // this is used for strftime()
    define('DATE_FORMAT_LONG', '%A, %d. %m. %Y'); // this is used for strftime()
    define('DATE_FORMAT', 'd.m.Y');  // this is used for strftime()
    define('PHP_DATE_TIME_FORMAT', 'd.m.Y H:i:s'); // this is used for date()
    define('DATE_TIME_FORMAT', DATE_FORMAT_SHORT . ' %H:%M:%S');
    define('HTML_PARAMS',' lang="de"');
    define('DOB_FORMAT_STRING', 'tt.mm.jjjj');
    break;
  case 'english':
    setlocale(LC_TIME, 'en_EN.ISO_8859-1');
    define('DATE_FORMAT_SHORT', '%d/%m/%Y');  // this is used for strftime()
    define('DATE_FORMAT_LONG', '%A, %d. %m. %Y'); // this is used for strftime()
    define('DATE_FORMAT', 'd/m/Y');  // this is used for strftime()
    define('PHP_DATE_TIME_FORMAT', 'd/m/Y H:i:s'); // this is used for date()
    define('DATE_TIME_FORMAT', DATE_FORMAT_SHORT . ' %H:%M:%S');
    define('HTML_PARAMS',' lang="en"');
    define('DOB_FORMAT_STRING', 'tt.mm.jjjj');
    break;
}






// write customers status in session
require('../' . DIR_WS_INCLUDES . 'write_customers_status.php');


// for tracking of customers
$_SESSION['user_info'] = array();
if (!isset($_SESSION['user_info']['user_ip'])) {
    $_SESSION['user_info']['user_ip'] = $_SERVER['REMOTE_ADDR'];
    $_SESSION['user_info']['user_host'] = gethostbyaddr( $_SERVER['REMOTE_ADDR'] );;
    $_SESSION['user_info']['advertiser'] = ((isset($_GET['ad']))?$_GET['ad']:'');
    $_SESSION['user_info']['referer_url'] = ((isset($_SERVER['HTTP_REFERER']))?$_SERVER['HTTP_REFERER']:'');
}


// define our localization functions
require(DIR_WS_FUNCTIONS . 'localization.php');

// setup our boxes
require(DIR_WS_CLASSES . 'table_block.php');
require(DIR_WS_CLASSES . 'box.php');

// initialize the message stack for output messages
require(DIR_WS_CLASSES . 'message_stack.php');
$messageStack = new messageStack;

// split-page-results
require(DIR_WS_CLASSES . 'split_page_results.php');

// entry/item info classes
require(DIR_WS_CLASSES . 'object_info.php');

// email classes
require(DIR_WS_CLASSES . 'mime.php');
require(DIR_WS_CLASSES . 'email.php');

// file uploading class
require(DIR_WS_CLASSES . 'upload.php');
  

// calculate category path
if (isset($_GET['cPath'])) {
  $cPath = $_GET['cPath'];
} else {
  $cPath = '';
}
if (strlen($cPath) > 0) {
  $cPath_array = explode('_', $cPath);
  $current_category_id = $cPath_array[(sizeof($cPath_array)-1)];
} else {
  $current_category_id = 0;
}

// default open navigation box
if (!isset($_SESSION['selected_box'])) {
  $_SESSION['selected_box'] = 'configuration';
}
if (isset($_GET['selected_box'])) {
  $_SESSION['selected_box'] = $_GET['selected_box'];
}

// the following cache blocks are used in the Tools->Cache section
// ('language' in the filename is automatically replaced by available languages)
$cache_blocks = array(
  array('title' => TEXT_CACHE_CATEGORIES, 'code' => 'categories', 'file' => 'categories_box-language.cache', 'multiple' => true),
  array('title' => TEXT_CACHE_MANUFACTURERS, 'code' => 'manufacturers', 'file' => 'manufacturers_box-language.cache', 'multiple' => true),
  array('title' => TEXT_CACHE_ALSO_PURCHASED, 'code' => 'also_purchased', 'file' => 'also_purchased-language.cache', 'multiple' => true)
);

// check if a default currency is set
if (!defined('DEFAULT_CURRENCY')) {
  $messageStack->add(ERROR_NO_DEFAULT_CURRENCY_DEFINED, 'error');
}

// check if a default language is set
if (!defined('DEFAULT_LANGUAGE')) {
  $messageStack->add(ERROR_NO_DEFAULT_LANGUAGE_DEFINED, 'error');
}

// for Customers Status
xtc_get_customers_statuses();

$pagename = strtok($current_page, '.');
if (!isset($_SESSION['customer_id'])) {
  xtc_redirect(xtc_href_link(FILENAME_LOGIN));
}

if (xtc_check_permission($pagename) == '0') {
  xtc_redirect(xtc_href_link(FILENAME_LOGIN));
}

require(DIR_FS_CATALOG.DIR_WS_CLASSES . 'class.yesSmarty.php');
  
// ebay token check
if(defined('EBAY_USER') and !empty(constant('EBAY_USER'))){
  $ebay_env = (EBAY_TESTMODE == '1') ? 'sandbox' : 'production';
  $key = 'ebay_auth_duration_check';
  $CachedString = $InstanceCache->getItem($key);
  if (!$CachedString->isHit()) {
      $auth_query = xtc_db_query(sprintf(
          "SELECT tknexp FROM ebay_auth WHERE environment='%s'",
          $ebay_env
      ));
      $auth_data = xtc_db_fetch_array($auth_query);
      $CachedString->set($auth_data)->expiresAfter(YES_CACHE_LIFETIME_LONG); // ebay_auth_duration_check
      $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
  }else{
      $auth_data = $CachedString->get();// Will print 'First product'
  }    

  if(strtotime($auth_data['tknexp'])<time()){
      $messageStack->add_session("Der Token (verschl&uuml;sselte Zugangsdaten zu Ebay) ist abgelaufen oder noch nicht aktiv, klicken Sie <a href='".HTTP_SERVER."admin/token.php'><u>hier um den Token zu generieren</u></a>.",'error');
  }
}