<?php

namespace YES4Trade\Model;

class cm_file_flags extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'cm_file_flags';
    const TABLE_INDEX = 'file_flag';

    private static $propertyTypes = [
        'file_flag' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'file_flag'
        ],
        'file_flag_name' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'file_flag_name'
        ],
    ];


public function __construct(array $values = []) {
    list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
    parent::__construct($parentValues);
    if (!array_key_exists(__CLASS__, self::$properties)) {
        self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
    }
    if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
        self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
    }
    $this->setValues(__CLASS__, $childValues);
    }


    public function create() {
        $data = $this->toArray();
        yes_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }


    public function update() {
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        $index = self::TABLE_INDEX;
        yes_db_perform(self::TABLE_NAME, $data,'update',[
            $index=>$this->$index
        ]);
    }


    public static function delete(int $index) {
        yes_query(sprintf(
            "DELETE FROM %s WHERE %s=:id",
                self::TABLE_NAME,self::TABLE_INDEX, 
            ),['id'=>$index]
        );
    }

    public static function get_all() {
        $items = [];
        $query = xtc_db_query(sprintf(
                "SELECT * FROM %s",
                self::TABLE_NAME
        ));
        while($record = xtc_db_fetch_array($query)){
            $items[] = new self($record);
        }
        return $items;
    }

    public static function get_by_file_flag(int $file_flag) {
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE %s=:flag",
                self::TABLE_NAME, self::TABLE_INDEX
            ),['flag'=>$file_flag]
        );
        if(!sizeOf($query)){
            return null;
        }
        $record = current($query);
        return new self($record);
    }

}
