<?php

namespace YES4Trade\Model;

class customers_memo extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'customers_memo';
    const TABLE_INDEX = 'memo_id';
    public static $integerProperties = [
        'memo_id',
        'customers_id',
        'poster_id'
    ];
    private static $propertyTypes = [
        'memo_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'memo_id'
        ],
        'customers_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_id'
        ],
        'memo_date' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'memo_date'
        ],
        'memo_title' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'memo_title'
        ],
        'memo_text' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'memo_text'
        ],
        'poster_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'poster_id'
        ],
    ];


    public function __construct(array $values = []) {
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);
        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }
        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }
        $this->setValues(__CLASS__, $childValues);
    }


    public function create() {
        $data = $this->toArray();
        foreach($data as $k=>$v){
            if(in_array($k, self::$integerProperties)){
                $data[$k] = (int)$v;
            }
        }
        yes_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }


    public function update() {
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        foreach($data as $k=>$v){
            if(in_array($k, self::$integerProperties)){
                $data[$k] = (int)$v;
            }
        }
        $index = self::TABLE_INDEX;
        yes_db_perform(self::TABLE_NAME, $data,'update',[
            $index=>$this->$index
        ]);
    }


    public static function delete(int $index) {
        yes_query(sprintf(
            "DELETE FROM %s WHERE %s=:id",
                self::TABLE_NAME,self::TABLE_INDEX
            ),['id'=>$index]
        );
    }

    public static function get_by_customers_id( int $customers_id ){
        $items = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE customers_id=:customers_id ORDER BY memo_date DESC",
                self::TABLE_NAME
            ),['customers_id'=>$customers_id]
        );
        foreach($query as $record){
            foreach($record as $k=>$v){
                if(in_array($k, self::$integerProperties)){
                    $record[$k] = (int)$v;
                }
            }
            $items[] = new self($record);
        }
        return $items;
    }

    public static function get_by_memo_id(int $memo_id) {
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE %s=:memo_id",
                self::TABLE_NAME, self::TABLE_INDEX
            ),['memo_id'=>$memo_id]
        );
        if(!sizeOf($query)){
            return null;
        }
        $record = current($query);
        foreach($record as $k=>$v){
            if(in_array($k, self::$integerProperties)){
                $record[$k] = (int)$v;
            }
        }
        return new self($record);
    }
    
    public static function count_by_customers_id( int $customers_id ){
        $record = yes_query(sprintf(
            "SELECT COUNT(%s) AS anz FROM %s WHERE customers_id=:customers_id",
                self::TABLE_INDEX,self::TABLE_NAME
        ),['customers_id'=>$customers_id],true);
        return (int)$record['anz'];
    }
}

