<?php
namespace YES4Trade\Model;
class groups_products_characteristics extends \YES4Trade\Model\BaseType{
    
    const TABLE_NAME = 'products_to_characteristics';
    const TABLE_INDEX = 'products_to_characteristics_id';
    
    private static $propertyTypes = [
        'products_to_characteristics_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_to_characteristics_id'
        ],
        'products_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_id'
        ],
        'products_characteristic_set_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_characteristic_set_id'
        ]
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }

    public function create(){
        $data = $this->toArray();
        unset($data['products_to_characteristics_id']);
        xtc_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }
    
   
    public static function delete( int $index ){
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
    }
    
    public static function get_by_products_characteristic_set_id( int $products_characteristic_set_id ){
        $items = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE products_characteristic_set_id=:id",
                self::TABLE_NAME
            ),['id'=>$products_characteristic_set_id]
        );
        foreach($query as $record){
            foreach($record as $k=>$v){
                $record[ $k ] = (int) $v;
            }
            $items[] = new \YES4Trade\Model\groups_products_characteristics($record);
        }
        return $items;
    }
  
    public static function get_by_products_id( int $products_id ){
        $items = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE products_id=:id",
                self::TABLE_NAME
            ),['id'=>$products_id]
        );
        foreach($query as $record){
            foreach($record as $k=>$v){
                $record[ $k ] = (int) $v;
            }
            $items[] = new \YES4Trade\Model\groups_products_characteristics($record);
        }
        return $items;
    }
 
}
