<?php
namespace YES4Trade\Model;
use main;
use DateTime;
use order;
class umsatzstatistik
{
	var $from, $to, $einteilung, $sources, $orders_array, $default_values, $sources_names,$customers_status_array;
	public function __construct(){
                $sources_array = main::get_order_sources();
                $customers_status_array = [];
                foreach(xtc_get_customers_statuses() as $cs){
                    $customers_status_array[] = ['id'=>$cs['id'],'text'=>$cs['text']];
                }
                $this->setCustomers_status_array( $customers_status_array );
                $sources_names = [];
                foreach($sources_array as $s){
                    if($s['id'] == ''){
                        continue;
                    }
                    $sources_names[ $s['id'] ] = $s['text'];
                }
                $this->setSources_names($sources_names);
                $this->set_default_values();
		$this->setFrom( date('Y-m-d 00:00:00',$this->getDefault_values('startDateAsTime') ));
		$this->setTo( date('Y-m-d 23:59:59',$this->getDefault_values('endDateAsTime') ));
		$this->collect_data();
	}
	
	private function get_sql(){
            $filter_orders_status = '';
            $filter_customers_status = '';
            $filter_fibu = '';
            $from_fibu = '';
            if($this->getDefault_values('srStatus') > 0){
                $filter_orders_status = sprintf(" and o.orders_status='%d'",
                        $this->getDefault_values('srStatus')
                );
            }else{
                $filter_orders_status = " and o.orders_status!=7";
            }
            if($this->getDefault_values('csID') != ''){
                $filter_customers_status = sprintf(" and o.customers_status='%d' ",
                        $this->getDefault_values('csID')
                );
            }
            if($this->getDefault_values('fibu') == 1){
                $filter_fibu = ' and orf.orders_id IS NOT NULL ';
                $from_fibu = ' LEFT JOIN orders_fibunumbers orf USING(orders_id) ';
            }
            return sprintf(
                    "SELECT o.orders_id,o.date_purchased FROM orders o %s WHERE o.date_purchased > '%s' and o.date_purchased < '%s' %s %s %s ORDER BY o.date_purchased",
                    $from_fibu,
                    $this->getFrom(),
                    $this->getTo(),
                    $filter_orders_status,
                    $filter_customers_status,
                    $filter_fibu
            );
	}
	
	private function get_einteilung_value( $date ){
		$dateObj = new DateTime($date);
		switch( $this->getEinteilung() ){
			case 'day':
				$format = 'd.m.Y';
				break;
			case 'week':
				$format = 'W/Y';
				break;
			case 'month':
				$format = 'm/Y';
				break;
			case 'year':
				$format = 'Y';
				break;
		}
		return $dateObj->format( $format );
	}
	
	public function collect_data(){
		$q = xtc_db_query( $this->get_sql() );
		while( $r = xtc_db_fetch_array($q)){
			$this->updateOrders_array($r['orders_id']);
		}
	}
	
	public function getSources(){
		return $this->sources;
	}
	
	public function setSources( $sources ){
		$this->sources = $sources;
	}
        
        public function setCustomers_status_array( array $customers_status_array ){
            $this->customers_status_array = $customers_status_array;
        }
        
        public function getCustomers_status_array( ){
            return $this->customers_status_array;
        }
        
        public function getSources_names( $key='' ){
            if($key != ''){
                return $this->sources_names[$key];
            }
            return $this->sources_names;
        }
        
        public function setSources_names($sources_names){
            $this->sources_names = $sources_names;
        }
	
	public function updateSource( $source, $value ){
		if(!isset($this->sources[ $source ])){
			$this->sources[ $source ] = 0;
		}
		$this->sources[ $source ] += $value;
	}
	
        /**
         * Gibt das Array zurueck das angezeigt werden soll.
         * @return Array
         */
	public function get_stats(){
            switch($this->getDefault_values('srView')){
                case 1:
        		$this->setEinteilung('year');
                        break;
                case 2:
        		$this->setEinteilung('month');
                        break;
                case 3:
        		$this->setEinteilung('week');
                        break;
                case 4:
        		$this->setEinteilung('day');
                        break;
            }
            return $this->generate_group_items($this->group_data());
	}
	
	private function generate_group_items($group_data){
		$items = [];
		foreach($group_data as $title => $orders){
			$rueckerstattungen_amount = $this->calc_rueckerstattungen_amount($orders);
			$products = $this->get_all_products_from_orders( $orders );
			$umsatz = $this->calc_umsatz($orders);
			$versand_amount = $this->calc_versand_amount($orders);
			$items[$title] = new umsatzstatistik_group_item(
				$title, $orders, $rueckerstattungen_amount, 
				$products, $umsatz, $versand_amount
			);
		}
		return $items;
	}
	
	private function get_all_products_from_orders( $orders ){
		$items = [];
		foreach($orders as $oID => $o){
			foreach($o->products as $op){
				$items[] = $op;
			}
		}
		return $items;
	}
	
	private function calc_rueckerstattungen_amount($orders){
		$amount = 0;
		foreach($orders as $oID => $o){
			if(sizeOf($o->rueckerstattungen)){
				foreach($o->rueckerstattungen as $r){
					$amount += $r['betrag'];
				}
			}
		}
		return $amount;
	}
	
	private function calc_versand_amount($orders){
		$amount = 0;
		foreach($orders as $oID => $o){
			if(!sizeOf($o->totals)){
				continue;
			}
			foreach($o->totals as $ot){
				switch($ot['class']){
					case 'ot_shipping':
						$amount += $ot['value'];
						break;
				}
			}
		}
		return $amount;
	}
	
	private function calc_umsatz($orders){
            $brutto = 0;
            $taxes = 0;
            $sources = [];
            foreach($orders as $oID => $o){
                if(!sizeOf($o->totals)){
                    continue;
                }
                if(!isset($sources[ $o->info['source'] ])){
                    $sources[ $o->info['source'] ] = [
                        'brutto'=>0,
                        'taxes'=>0,
                        'netto'=>0,
                    ];
                }
                if(!isset($customers_statuses[ $o->info['status'] ])){
                    $customers_statuses[ $o->info['status'] ] = [
                        'brutto'=>0,
                        'taxes'=>0,
                        'netto'=>0,
                    ];
                }
                foreach($o->totals as $ot){
                    switch($ot['class']){
                        case 'ot_total':
                            $brutto += $ot['value'];
                            $sources[ $o->info['source'] ]['brutto'] += $ot['value'];
                            $customers_statuses[ $o->info['status'] ]['brutto'] += $ot['value'];
                            break;
                        case 'ot_tax':
                            $taxes += $ot['value'];
                            $sources[ $o->info['source'] ]['taxes'] += $ot['value'];
                            $customers_statuses[ $o->info['status'] ]['taxes'] += $ot['value'];
                            break;
                    }
                }
            }
            $sources_total = 0;
            foreach($sources as $source=>$type){
                $sources[ $source ]['netto'] = $sources[ $source ]['brutto']-$sources[ $source ]['netto'];
                $sources_total += $sources[ $source ]['netto'];
            }
            foreach($customers_statuses as $cs=>$type){
                $customers_statuses[ $cs ]['netto'] = $customers_statuses[ $cs ]['brutto']-$customers_statuses[ $cs ]['netto'];
            }
            return [
                'netto'=>$brutto- $taxes,
                'brutto'=>$brutto,
                'taxes'=>$taxes,
                'sources'=>$sources,
                'customers_statuses'=>$customers_statuses,
            ];
	}
	
	private function group_data(){
		$grouped = [];
		foreach($this->getOrders_array() as $o){
			$einteilung = $this->get_einteilung_value($o->info['date_purchased']);
			if(!isset($grouped[$einteilung])){
				$grouped[ $einteilung ] = [];
			}
			$grouped[$einteilung][ $o->info['id'] ] = $o;
		}
		return $grouped;
	}
        public function get_stats_total( $stats ){
            $return = ['netto'=>0,'brutto'=>0,'taxes'=>0];
            foreach($stats as $gi){
                $return['netto'] += $gi->umsatz['netto'];
                $return['brutto'] += $gi->umsatz['brutto'];
                $return['taxes'] += $gi->umsatz['taxes'];
            }
            return $return;
        }
        
        public function get_customers_groups_total_from_stats( $totals ){
            $cs_total = [];
            foreach($totals as $group_item){
                $umsatz = $group_item->getUmsatz();
                foreach($umsatz['customers_statuses'] as $src_name=>$src_val){
                    $num_orders = 0;
                    foreach($group_item->getOrders() as $go){
                            if($go->info['status'] == $src_name){
                                    $num_orders++;
                            }
                    }
                    if(!isset($cs_total[ $src_name ])){
                            $cs_total[ $src_name ] = ['netto'=>0,'quantity'=>0,'average'=>0];
                    }
                    $cs_total[ $src_name ]['netto'] += $src_val['netto'];
                    $cs_total[ $src_name ]['quantity'] += $num_orders;
                }
                foreach($umsatz['customers_statuses'] as $src_name=>$src_val){
                    $cs_total[ $src_name ]['average'] = $cs_total[ $src_name ]['netto'] / $cs_total[ $src_name ]['quantity'];
                }
            }
            return $cs_total;
        }
	public function get_sources_total_from_stats( $totals ){
		$sources_total = [];
		foreach($totals as $group_item){
                    $umsatz = $group_item->getUmsatz();
                    foreach($umsatz['sources'] as $src_name=>$src_val){
			$num_orders = 0;
                    	foreach($group_item->getOrders() as $go){
                    		if($go->info['source'] == $src_name){
	                    		$num_orders++;
	                    	}
                    	}
                            if(!isset($sources_total[ $src_name ])){
                                    $sources_total[ $src_name ] = ['netto'=>0,'quantity'=>0,'average'=>0];
                            }
                            $sources_total[ $src_name ]['netto'] += $src_val['netto'];
                            $sources_total[ $src_name ]['quantity'] += $num_orders;
                    }
                    foreach($umsatz['sources'] as $src_name=>$src_val){
                        $sources_total[ $src_name ]['average'] = $sources_total[ $src_name ]['netto'] / $sources_total[ $src_name ]['quantity'];
                    }
		}
		return $sources_total;
	}
	
	public function get_payments_from_stats( $totals ){
		$payments = [];
		foreach($totals as $einteilung=>$group_item){
                    $umsatz = $group_item->getUmsatz();
                    foreach($group_item->getOrders() as $o){
                    	$pm_title = $o->info['payment_method'];
                    	switch($o->info['payment_method']){
                    		case 'moneyorder':
                    			$pm_title = 'Vorkasse';
                    			break;
                    	}
                            if(!isset($payments[ $pm_title ])){
                                    $payments[ $pm_title ] = ['quantity'=>0,'amount'=>0];
                            }
                            $payments[ $pm_title ]['quantity']++;
                            $amount = 0;
                            foreach($o->totals as $ot){
                            	switch($ot['class']){
                            		case 'ot_total':
                            			$amount += $ot['value'];
	                            		break;
                            	}
                            }
                            $payments[ $pm_title ]['amount'] += $amount;
                    }
		}
		return $payments;
	}
	
	public function setFrom( $from ){
		$this->from = $from;
	}	
	
	public function getFrom(){
		return $this->from;
	}	
        
	public function setDefault_values( $default_values ){
		$this->default_values = $default_values;
	}	
	
	public function getDefault_values( $key='' ){
                if($key != ''){
                    return $this->default_values[$key];
                }
		return $this->default_values;
	}	
	
	public function setTo( $to ){
		$this->to = $to;
	}	
	
	public function getTo( ){
		return $this->to;
	}	
	
	public function setEinteilung( $einteilung ){
		$this->einteilung = $einteilung;
	}	
	
	public function getEinteilung( ){
		return $this->einteilung;
	}	
	
	public function getOrders_array(){
		return $this->orders_array;
	}
	
	public function setOrders_array( $orders_array ){
		$this->orders_array = $orders_array;
	}
	
	public function updateOrders_array( $oID ){
		$this->orders_array[] = new order($oID);
	}
        
        public function set_default_values(){
            // default view (daily)
            $srDefaultView = 2;
            // default export
            $srDefaultExp = 0;
            $endDate =  filter_var($_GET['endDate'] ?? date('Y-m-d'), FILTER_SANITIZE_STRING);
            $startDate =  filter_var($_GET['startDate'] ?? (new DateTime('first day of this month'))->format('Y-m-d'), FILTER_SANITIZE_STRING);
            $this->setDefault_values([
                'endDateValue'=>$endDate,
                'endDateAsTime'=> (new DateTime($endDate.' 23:59:59'))->getTimestamp(),
                'startDateValue'=>$startDate,
                'startDateAsTime'=>(new DateTime($startDate))->getTimestamp(),
                'csID' => filter_var($_GET['customers_status_id'] ?? '', FILTER_SANITIZE_STRING),
                'srView' => filter_var($_GET['report'] ?? $srDefaultView, FILTER_SANITIZE_STRING),
                'srExp' => filter_var($_GET['export'] ?? $srDefaultExp, FILTER_SANITIZE_STRING),
                'srStatus' => filter_var($_GET['status'] ?? 0, FILTER_SANITIZE_STRING),
                'fibu' => filter_var($_GET['fibu'] ?? 0, FILTER_SANITIZE_STRING),
            ]);
        }
        
        public function getSrViewName(){
            switch($this->getDefault_values('srView')){
                case 1:
                    return REPORT_TYPE_YEARLY;
                case 2:
                    return REPORT_TYPE_MONTHLY;
                case 3:
                    return REPORT_TYPE_WEEKLY;
                case 4:
                    return REPORT_TYPE_DAILY;
            }
        }
}
