<?php
/**
 * Description of amz_Feedhandler
 *
 * @author mario
 */
require_once('includes/classes/amz_Feedshandler_Feed.php');
require_once('includes/classes/amz_FeedhandlerItem.php');
class amz_Feedshandler {
	var $feedIdArray;   // array der feed_ids
	var $ErrorMsg = array();
	var $service;
	var $helper;
	var $feeds;	    // array der feeds objekte

	function __construct($id_array){
	    $this->debug('__construct()');
		if(!is_array($id_array) or !sizeOf($id_array)){
			$this->setErrorMsg("Keine FeedIDs angegeben");
			return '-1';
		}
		$this->setFeedIdArray($id_array);
                $amazon_feeds = \YES4Trade\Model\amazon_feeds::get_by_feed_submission_id_array($this->getFeedIdArray(),['amazon_feeds_id']);
		if(!is_countable($amazon_feeds) or !sizeOf($amazon_feeds)){
			$this->setErrorMsg(sprintf('All feeds processed'));
			return '-1';
		}
		foreach($amazon_feeds as $af){
		    $amz_Feedshandler_Feed = new amz_Feedshandler_Feed($af->amazon_feeds_id);
		    if(!$amz_Feedshandler_Feed){
			$this->setErrorMsg(sprintf('Amazon Feed #%s processed/not exists', $af->amazon_feeds_id));
			continue;
		    }
		    $this->feeds[ $amz_Feedshandler_Feed->getFeed_submission_id() ] = $amz_Feedshandler_Feed;
		}
	}
	
	/**
	 * this->feeds DURCHLAUFEN
	 * 1. FeedInfo holen
	 * 2. FeedInfo verarbeiten
	 * @return bool
	 */
	public function process(){
	    $response = $this->getFeedsInfo();
	    $errors = array();
	    foreach($response as $FeedSubmissionInfo){
		if($FeedSubmissionInfo->getFeedProcessingStatus() == '_CANCELLED_'){
			$this->feeds[ $FeedSubmissionInfo->getFeedSubmissionId() ]->delete_feed_info_db($FeedSubmissionInfo->getFeedProcessingStatus());
			continue;
		}
		if($FeedSubmissionInfo->getFeedProcessingStatus() != '_DONE_'){
		    continue;
		}
		switch($FeedSubmissionInfo->getFeedType()){
			case '_POST_INVENTORY_AVAILABILITY_DATA_': // veraltet
				if(!$this->feeds[ $FeedSubmissionInfo->getFeedSubmissionId() ]->update_yes_qty()){
					$errors[] = $FeedSubmissionInfo->getFeedSubmissionId().': update_yes_qty()';
				}
				break;
			case '_POST_PRODUCT_PRICING_DATA_': // VERALTET
				if(!$this->feeds[ $FeedSubmissionInfo->getFeedSubmissionId() ]->update_yes_price()){
					$errors[] = $FeedSubmissionInfo->getFeedSubmissionId().': update_yes_price()';
				}
				break;
			case '_POST_ORDER_FULFILLMENT_DATA_':
				if(!$this->feeds[ $FeedSubmissionInfo->getFeedSubmissionId() ]->update_order_fulfillment()){
					$errors[] = $FeedSubmissionInfo->getFeedSubmissionId().': update_order_fulfillment()';
				}
				break;

		}
	    }
	    return $errors;
	}
        
	/**
	 * - LIEFERT INFORMATIONEN ZU EINEM AMAZON FEED ANHAND DER FEEDSUBMISSIONID
	 *
	 * @param object $service
	 * @return object
	 */
	private function getFeedsInfo(){
		$service = $this->getService();
		$A = $this->getHelper();
		$auth_params = $A->get_auth_data_array();
		$parameters = array (
			'Marketplace' => $auth_params['marketplace_id'],
			'Merchant' => $auth_params['merchant_id'],
			'MaxCount' => 100,
			'FeedSubmissionIdList' => array('Id'=>$this->feedIdArray)
		);
		if(!empty($auth_params['mwsauthtoken'])){
			$parameters['MWSAuthToken'] = $auth_params['mwsauthtoken'];
		}
		$request = new MarketplaceWebService_Model_GetFeedSubmissionListRequest($parameters);
		try{
				$response = $service->getFeedSubmissionList($request);
		} catch (MarketplaceWebService_Exception $ex) {
                    $this->setErrorMsg( "Response Status Code: " . $ex->getStatusCode());
                    $this->setErrorMsg( "Error Code: " . $ex->getErrorCode());
                    $this->setErrorMsg( "Error Type: " . $ex->getErrorType());
                    $this->setErrorMsg( "Request ID: " . $ex->getRequestId());
                    $this->setErrorMsg( "XML: " . print_r($ex->getXML(),true));
                    mail('m.aspeleiter@yes-websolutions.de','amz_err '.$ex->getMessage(),HTTP_SERVER."\r\n".STORE_NAME."\r\n".basename(__FILE__)."\r\n".implode("\r\n",$this->getErrorMsg()));
                    throw new Exception(implode("\r\n",$this->getErrorMsg()).$ex->getMessage());
		}
		$getFeedSubmissionListResult = $response->getGetFeedSubmissionListResult();

		$feedSubmissionInfoList = $getFeedSubmissionListResult->getFeedSubmissionInfoList();
		$this->debug('getFeedsInfo() success');
		
		return $feedSubmissionInfoList;
	}

	public function getFeedSubmissionResult($feed_id){
		$service = $this->getService();
		$A = $this->getHelper();
		$auth_params = $A->get_auth_data_array();
		// SUBMIT FEED STATUS PRUEFEN
		$parameters = array (
			'Marketplace' => $auth_params['marketplace_id'],
			'Merchant' => $auth_params['merchant_id'],
			'FeedSubmissionId' => $feed_id,
			'FeedSubmissionResult' => @fopen('php://memory', 'rw+'),
		);
		if(!empty($auth_params['mwsauthtoken'])){
		    $parameters['MWSAuthToken'] = $auth_params['mwsauthtoken'];
		}

		$request = new MarketplaceWebService_Model_GetFeedSubmissionResultRequest($parameters);
		try {
			$response = $service->getFeedSubmissionResult($request);
			if ($response->isSetGetFeedSubmissionResultResult()) {
				$getFeedSubmissionResultResult = $response->getGetFeedSubmissionResultResult(); 
				if ($getFeedSubmissionResultResult->isSetContentMd5()) {
					$handle = $request->getFeedSubmissionResult();
					$xml = stream_get_contents($handle);
					print_r($xml);
				}
			}
		} catch (MarketplaceWebService_Exception $ex) {
			 echo("Caught Exception: " . $ex->getMessage() . "\n");
			 echo("Response Status Code: " . $ex->getStatusCode() . "\n");
			 echo("Error Code: " . $ex->getErrorCode() . "\n");
			 echo("Error Type: " . $ex->getErrorType() . "\n");
			 echo("Request ID: " . $ex->getRequestId() . "\n");
			 echo("XML: " . $ex->getXML() . "\n");
			exit;
		}
	}
	
	public function getFeedIdArray() {
		return $this->feedIdArray;
	}

	public function setFeedIdArray($feedIdArray) {
		$this->feedIdArray = $feedIdArray;
	}


	public function getItems() {
		return $this->items;
	}

	public function setItems($items,$id = -1) {
		if($id > 0)
			$this->items[$id] = $items;
		else
			$this->items = $items;
	}

	public function getErrorMsg() {
		return $this->ErrorMsg;
	}

	public function setErrorMsg($ErrorMsg,$id = -1) {
		if($id > 0)
			$this->ErrorMsg[$id] = $ErrorMsg;
		else
			$this->ErrorMsg[] = $ErrorMsg;
	}

	public function getService() {
		return $this->service;
	}

	public function setService($service) {
		$this->service = $service;
	}

	public function setFeedType($feedType) {
		$this->feedType = $feedType;
	}
	
	public function getHelper() {
	    return $this->helper;
	}

	public function setHelper($helper) {
	    $this->helper = $helper;
	}

	private function debug($str){
	    if(CRON_AMAZON_FEEDS_DEBUG == 1){
		printf("\r\n\tDEBUG %s: %s",get_class($this),$str);
	    }
	}
}

