<?php
include('amz_Report.php');
class ReportList
{
	var $NextToken;
	var $reports;
	function getReportList($response){
		switch(get_class($response)){
			case 'MarketplaceWebService_Model_GetReportListByNextTokenResponse':
				$getReportListResult = $response->getGetReportListByNextTokenResult();
				break;
			default:
				$getReportListResult = $response->getGetReportListResult();
				break;
		}
		if($getReportListResult->isSetHasNext() and $getReportListResult->isSetNextToken()) {
			$this->setNextToken($getReportListResult->getNextToken());
		}
		$reports = $getReportListResult->getReportInfoList();
		foreach($reports as $report){
			$this->setReports($report);	
		}
	}

	function setNextToken($NextToken){
		$this->NextToken = $NextToken;
	}
	function getNextToken(){
		return $this->NextToken;
	}
	function setReports($report,$id = -1){
		if($id >= 0)
			$this->reports[$id] = $report;
		else
			$this->reports[] = $report;
	}
	function getReports(){
		return $this->reports;
	}

	function getNextLink(){
		if($this->getNextToken() != ''){
			return sprintf('<p><a class="amazon_feeds_next_link" href="javascript:;" id="%s"><code>%s</code></a></p>',
				xtc_href_link('amazon.php',xtc_get_all_get_params(array('NextToken')).'NextToken='.urlencode($this->getNextToken())),
				AMAZON_TEXT_NEXT_TOKEN
			);
		}
	}

	function getReportTypeAlias($ReportType){
		switch($ReportType){
			case '_GET_FLAT_FILE_OPEN_LISTINGS_DATA_':
				return AMAZON_REPORT_TYPE_GET_FLAT_FILE_OPEN_LISTINGS_DATA;
				break;
			case '_GET_ORDERS_DATA_':
				return AMAZON_REPORT_TYPE_GET_ORDERS_DATA;
				break;
			case '_GET_FLAT_FILE_ORDERS_DATA_':
				return AMAZON_REPORT_TYPE_GET_FLAT_FILE_ORDERS_DATA;
				break;
			case '_GET_MERCHANT_LISTINGS_DATA_':
				return AMAZON_REPORT_TYPE_GET_MERCHANT_LISTINGS_DATA;
				break;
			case '_GET_AMAZON_FULFILLED_SHIPMENTS_DATA_':
				return AMAZON_REPORT_TYPE_GET_AMAZON_FULFILLED_SHIPMENTS_DATA;
				break;
		}
		return $ReportType;
	}

	function invokeGetReportList(MarketplaceWebService_Interface $service, $request) {
		try {
			$response = $service->getReportList($request);
			$this->getReportList($response);
			$reports = $this->getReports();
			$items = array();
			if(sizeOf($reports)){
				foreach($reports as $report){
					$d = $report->getAvailableDate();
					$d->setTimeZone(new DateTimeZone('Europe/Berlin'));
					$items[] = array(
						'ID'=>$report->getReportId(),
						'NAME'=>$this->getReportTypeAlias($report->getReportType()),
						'REPORT_TYPE'=>$report->getReportType(),
						'DATE_AVAILABLE'=>$d->format('d.m.Y H:i:s'),
						'DATE_AVAILABLE_URLENCODED'=>urlencode($report->getAvailableDate()->format('d.m.Y H:i:s')),
						'ACKNOWLEDGED'=>$report->getAcknowledged()
					);
				}
			}
			return $items;

		} catch (MarketplaceWebService_Exception $ex) {
			echo amazon_get_request_error_msg($ex);
		}
	}

	function invokeGetReportListByNextToken(MarketplaceWebService_Interface $service, $request){
		try {
			$response = $service->getReportListByNextToken($request);
			$this->getReportList($response);
			$reports = $this->getReports();
			$items = array();
			if(sizeOf($reports)){
				foreach($reports as $report){
					$d = $report->getAvailableDate();
					$d->setTimeZone(new DateTimeZone('Europe/Berlin'));
					$items[] = array(
						'ID'=>$report->getReportId(),
						'NAME'=>$this->getReportTypeAlias($report->getReportType()),
						'REPORT_TYPE'=>$report->getReportType(),
						'DATE_AVAILABLE'=>$d->format('d.m.Y H:i:s'),
						'ACKNOWLEDGED'=>$report->getAcknowledged()
					);
				}
			}
			return $items;
		} catch (MarketplaceWebService_Exception $ex) {
			echo amazon_get_request_error_msg($ex);
		}
	}
}
