<?php
/**
 * Stellt das Service Object zur Kommunikation mit Amazon Bereit
 */
class amazon_service
{
	var $config;
	var $service;

	/**
	 * definiert die Verbindungsparameter und erzeugt ein Client Object
	 * Speichert das Ganze als amazon_service::service
	 */
	public function __construct(){
		$this->config = array (
		  'ServiceURL' => AMAZON_MWS_SERVICE_URL,
		  'ProxyHost' => null,
		  'ProxyPort' => -1,
		  'MaxErrorRetry' => 3,
		);

		$this->service = new MarketplaceWebService_Client(
			 AWS_ACCESS_KEY_ID,
			 AWS_SECRET_ACCESS_KEY,
			 $this->config,
			 APPLICATION_NAME,
			 APPLICATION_VERSION
		);
	}

	/**
	 * Liefert das Client Object
	 * 
	 * @return MarketplaceWebService_Client
	 */
	public function get_service(){
		return $this->service;
	}
}