<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                              Author M. ASPELEITER <dazze@gmx.de
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

class rueckerstattung {
    var $info, $bank;

    function __construct($rueckerstattungen_id) {
      $this->info = array();
      $this->bank = array();

      $this->query($rueckerstattungen_id);	
    }

    function query($rueckerstattungen_id) {
      $rueckerstattungen_query = xtc_db_query("select *
                                  from rueckerstattungen r where
                                  rueckerstattungs_id = '" . xtc_db_input($rueckerstattungen_id) . "'");

      $rueckerstattungen = xtc_db_fetch_array($rueckerstattungen_query);

      $this->info = array('comments' => $rueckerstattungen['comments'],
                          'date_created' => $rueckerstattungen['date_created'],
                          'status' => $rueckerstattungen['status'],
                          'type' => $rueckerstattungen['type'],
                          'id' => $rueckerstattungen['rueckerstattungs_id'],
                          'orders_id'=>$rueckerstattungen['orders_id'],
                          'customers_id'=>$rueckerstattungen['customers_id'],
                          'date_payment' => $rueckerstattungen['date_payment'],
                          'betrag' => $rueckerstattungen['betrag'],
			  'reclamations_id' => $rueckerstattungen['reclamations_id'],
			  'paymode' => $rueckerstattungen['paymode'],
              );

      $this->bank = array('kto_nummer' => $rueckerstattungen['kto_nummer'],
                              'kto_inhaber' => $rueckerstattungen['kto_inhaber'],
                              'kto_blz' => $rueckerstattungen['kto_blz'],
                              'kto_bank' => $rueckerstattungen['kto_bank'],
			      'kto_swift' => $rueckerstattungen['kto_swift'],
			      'kto_iban' => $rueckerstattungen['kto_iban'],
			      'kto_grund' => $rueckerstattungen['kto_grund']);

    }
    /**
     * fuegt einen Eintrag in Tabelle rueckerstattungen_status_history ein
     * @param int $status Der Status der Rueckerstattung
     * @param bool $notified Kunde wurde benachrichtigt
     * @param string $comments Kommentar zum Vorgang
     * @param int $editor_id Die customers_id des Admins
     */
    function add_history($status,$notified,$comments,$editor_id=-1){
        $insert_sql_array = array(
            'rueckerstattungen_id'=>$this->info['id'],
            'rueckerstattungen_status_id'=>$status,
            'date_added'=>'now()',
            'customer_notified'=>($notified)?1:0,
            'comments'=>$comments,
            'editor_id'=>($editor_id == -1) ? $_SESSION['customer_id'] : $editor_id
        );
        xtc_db_perform('rueckerstattungen_status_history',$insert_sql_array);
    }
    
    public static function add_history_static(int $rueckerstattungen_id, int $status, bool $notified, string $comments, int $editor_id = -1){
        $insert_sql_array = array(
            'rueckerstattungen_id'=>$rueckerstattungen_id,
            'rueckerstattungen_status_id'=>$status,
            'date_added'=>'now()',
            'customer_notified'=>($notified)?1:0,
            'comments'=>$comments,
            'editor_id'=>($editor_id == -1) ? intval($_SESSION['customer_id']??0) : $editor_id
        );
        xtc_db_perform('rueckerstattungen_status_history',$insert_sql_array);
    }
}