<?php
/*------------------------------------------------------------------------------

   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *

                                              Author M. ASPELEITER <dazze@gmx.de
                                             Copyright (c) 2004 mario aspeleiter
                                                              Project: Yes4Trade
   ---------------------------------------------------------------------------*/

require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_FS_INC.'xtc_productgroups.inc.php');
require_once(DIR_FS_INC.'xtc_href_link_from_admin.inc.php');
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
require_once(DIR_FS_INC.'yes_get_products_condition.inc.php');
define('MODULE_YATEGO_TEXT_DESCRIPTION', 'Export - Yatego (Semikolon getrennt)');
define('MODULE_YATEGO_TEXT_TITLE', 'Yatego - CSV');
define('MODULE_YATEGO_FILE_TITLE' , '<hr noshade>Dateiname');
define('MODULE_YATEGO_FILE_DESC' , 'Geben Sie einen Dateinamen ein, falls die Exportdatei am Server gespeichert werden soll.<br>(Verzeichnis ebaymich/)');
define('MODULE_YATEGO_STATUS_DESC','Modulstatus');
define('MODULE_YATEGO_STATUS_TITLE','Status');
define('MODULE_YATEGO_CURRENCY_TITLE','W&auml;hrung');
define('MODULE_YATEGO_CURRENCY_DESC','Welche W&auml;hrung soll exportiert werden?');
@define('EXPORT_YES','Nur Herunterladen');
@define('EXPORT_NO','Am Server Speichern');
@define('CURRENCY','<hr noshade><b>W&auml;hrung:</b>');
@define('CURRENCY_DESC','W&auml;hrung in der Exportdatei');
@define('EXPORT_STATUS_TYPE','<hr noshade><b>Kundengruppe:</b>');
@define('EXPORT_STATUS','Bitte w&auml;hlen Sie die Kundengruppe, die Basis f&uuml;r den Exportierten Preis bildet. (Falls Sie keine Kundengruppenpreise haben, w&auml;hlen Sie <i>Gast</i>):</b>');
@define('DATE_FORMAT_EXPORT', '%d.%m.%Y');  // this is used for strftime()
@define('EXPORT_LINKED_PRODUCTS','Verlinkte Produkte mit exportieren');
define('EXPORT_TITLE','Verwende folgenden Produkttitel f&uuml;r den Export:');
define('EXPORT_EBAY_TITLE','Ebay Titel');
define('EXPORT_PRODUCT_TITLE','Produkt Titel');
define('EXPORT_DEFAULT_CATEGORY','Exportiere nur Artikel die eine Default Kategorie zugewiesen haben. (Kategorieauswahl wird ignoriert)');
define('MSG_SUCCESS_FILE_EXPORTED','Die Datei %s wurde im ebaymich/ Verzeichnis gespeichert.');
define('MODULE_YATEGO_PROMO_TEXT_TITLE','Promo Text');
define('MODULE_YATEGO_PROMO_TEXT_DESC','Geben Sie einen Text ein der bei jedem Datensatz mit erzeugt wird.');
define('MODULE_YATEGO_EXPORT_ONLY_V1_TITLE','Nur Artikel mit Bestand V1 &gt; 0');
define('MODULE_YATEGO_EXPORT_ONLY_V1_DESC','Legen Sie fest, ob beim Yatego Export nur Artikel ber&uuml;cksichtigt werden sollen, die einen V1 Bestand gr&ouml;sser 0 haben.');
define('EXPORT_ONLY_V1','Nur Artikel mit Bestand V1 &gt; 0');
// include needed functions


  class yatego extends products_export{
    var $code, $title, $description, $enabled,$categories_string,$selected_categories,$delimiter;
    var $from_cron;


    function __construct() {
      global $order;
      $this->delimiter = ";";
      $this->code = 'yatego';
      $this->title = MODULE_YATEGO_TEXT_TITLE;
      $this->description = MODULE_YATEGO_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_YATEGO_SORT_ORDER')) ? MODULE_YATEGO_SORT_ORDER : 0;
      $this->enabled = ((defined('MODULE_YATEGO_STATUS') and MODULE_YATEGO_STATUS == 'True') ? true : false);
      $this->CAT=array();
      $this->PARENT=array();
      $this->CATTree = array();
      $this->temporary_trees = array();
      $this->only_active_products = true;
      $this->ebay_title = true;
      $this->only_active_categories = true;
      $this->language_id = $_SESSION['languages_id'];
      $this->replace_html_entities = true;
      $this->from_cron = (isset($_SERVER['REMOTE_ADDR'])) ? false : true;
    }


    function getChilds($catID){
	$visible_child_categories_query = xtc_db_query( sprintf( "SELECT categories_id FROM categories WHERE parent_id='%s' AND categories_status=1",$catID));
	while($visible_child_categories = xtc_db_fetch_array($visible_child_categories_query)){
		$childcatID = $visible_child_categories['categories_id'];
		$this->selected_categories[$childcatID] = true;
		$this->getChilds($childcatID);
	}
    }

    function process($file) {
        $gh = new \YES4Trade\Model\group_handler($this->language_id);
	$basics = new basics;
        @xtc_set_time_limit(0);
	$max_items = 5000;
	$export_params = array(
	    'customers_status'=>((isset($_REQUEST['status']))?$_REQUEST['status']:CRON_YATEGO_CONFIG_CUSTOMERS_STATUS),
	    'export_linked_products'=>((isset($_REQUEST['export_linked_products']) and $_REQUEST['export_linked_products'] == 1)?1:0),
	    'particle_path'=>\main::get_exportdata_path().'YATEGO_EXPORT/',
	    'start'=>0,
	    'cat'=>((isset($_REQUEST['cat']))?$_REQUEST['cat']:''),
            'only_v1'=>((isset($_REQUEST['configuration']['MODULE_YATEGO_EXPORT_ONLY_V1']) and $_REQUEST['configuration']['MODULE_YATEGO_EXPORT_ONLY_V1'] == 'True')?true:false),
	);
	if($this->from_cron){
            $export_params['only_v1'] = (defined('MODULE_YATEGO_EXPORT_ONLY_V1') and MODULE_YATEGO_EXPORT_ONLY_V1 == 'True') ? true : false;
	    if(is_file(DIR_FS_CATALOG.'ebaymich/'.$file.'.zip')){
		die("Die Datei ebaymich/$file.zip ist bereits vorhanden. Diese muss entweder manuell oder durch den cronjob cron_yatego_delete_file.php geloescht werden.\r\n");
	    }
	    if(is_dir($export_params['particle_path'])){
		$files = $basics->get_directory_content($export_params['particle_path']);
		foreach($files as $f){
		    if(!strstr($f,'PART_')){
			continue;
		    }
		    $strpos1 = strpos($f,'_')+1;
		    $str1 = substr($f,$strpos1);
		    $strpos2 = strpos($str1,'.');
		    $_start = (int)substr($str1,0,$strpos2);
		    if($_start >= $export_params['start']){
			$export_params['start'] = $_start+$max_items;
		    }
		}
	    }
	    $export_params['all_cat'] = CRON_YATEGO_CONFIG_ALL_CAT;
	    $export_params['default_category'] = CRON_YATEGO_CONFIG_DEFAULT_CATEGORY;
	    $export_params['title'] = CRON_YATEGO_CONFIG_TITLE;
	    $export_params['export'] = 'no';
	}else{
	    if(isset($_REQUEST['start'])){
		$export_params['start'] = (int)$_REQUEST['start'];
	    }
	    $export_params['all_cat'] = (isset($_REQUEST['allCat']))?$_REQUEST['allCat']:'';
	    $export_params['default_category'] = (isset($_REQUEST['default_category']) and $_REQUEST['default_category'] == 1) ? 1 : 0;
	    $export_params['title'] = $_REQUEST['title'];
	    $export_params['export'] = $_REQUEST['export'];
	    global $messageStack;
	}
        $xtPrice = new xtcPrice(DEFAULT_CURRENCY,$export_params['customers_status']);
	
	$header = array(
            'foreign_id','article_nr','title','tax','price',
            'price_uvp','price_purchase','tax_differential','units','delivery_surcharge',
            'delivery_calc_once','short_desc','long_desc','url','auto_linefeet',
            'picture','picture2','picture3','picture4','picture5',
            'categories','variants','discount_set_id',
            'stock','delivery_date','quantity_unit','package_size','cross_selling','ean','isbn','manufacturer','mpn','delitem','status','top_offer','packagesize_full',
            'Promo_Text','item_condition'
	);
	$schema = '';
	if($export_params['export_linked_products'] == 1){
            $linked_sql = "";
	}else{
            $linked_sql = " GROUP BY products_id ";
	}
	$start = $export_params['start'];
	if($start == 0){
	    if(is_dir($export_params['particle_path'])){
                $files = $basics->get_directory_content($export_params['particle_path']);
                foreach($files as $f){
                        unlink($export_params['particle_path'].$f);
                }
                rmdir($export_params['particle_path']);
	    }
	    mkdir($export_params['particle_path']);
	}
	$allCat = $export_params['all_cat'];
	$cat = $export_params['cat'];
	$default_category_sql = '';
	if($export_params['default_category'] == 1){
	    $default_category_sql = ' AND p2c.categories_id=p.default_category ';
	    $allCat = 1;
	}
	$count_query = xtc_db_query(sprintf(
            "SELECT p.products_id FROM products_to_categories p2c LEFT JOIN %s p USING (products_id) WHERE p.products_id>0 %s %s %s",
            TABLE_PRODUCTS,$this->getP2CWhereSQLString($allCat,$cat),$default_category_sql,$linked_sql
	));
	$num_total = xtc_db_num_rows($count_query);
	$export_query_raw = "SELECT
            p.products_id,
            p.products_ean,
            p2c.categories_id,
            p.products_model,
            pd.products_name,
            pd.ebay_title,
            pd.slave_title,
            pd.products_description,pd.products_short_description,
            p.products_model,p.products_ean,
            p.products_image,
            p.products_price,
            p.products_status,
            p.products_date_available,
            p.products_shippingtime,
            p.products_discount_allowed,
            pd.products_meta_keywords,
            p.products_date_added,
            m.manufacturers_name,
            p.products_vpe,
            p.products_vpe_status,
            p.products_vpe_value,
            p.mpn,
            p.products_conditions_id
            FROM
            products_to_categories p2c LEFT JOIN
            " . TABLE_PRODUCTS . " p USING (products_id) LEFT JOIN
            " . TABLE_MANUFACTURERS . " m
            ON p.manufacturers_id = m.manufacturers_id LEFT JOIN
            " . TABLE_PRODUCTS_DESCRIPTION . " pd
            ON p.products_id = pd.products_id AND
            pd.language_id = '".$this->language_id."' LEFT JOIN
            " . TABLE_SPECIALS . " s
            ON p.products_id = s.products_id
            WHERE
            p.products_id>0 ".$this->getP2CWhereSQLString($allCat,$cat)."
            AND (p.no_yatego_export=0 or p.no_yatego_export IS NULL) 
            ".$default_category_sql."
            ".$linked_sql."
            ORDER BY
            p.products_date_added DESC,
            pd.products_name LIMIT $start, $max_items";
	$export_query = xtc_db_query($export_query_raw);

	$counter = 1;
	$loaded_groups = array();
	$records = array();
	while ($products = xtc_db_fetch_array($export_query)) {
            $records[] = $products;
	}
	foreach($records as $products){
	    $pID = $products['products_id'];
            $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                $products['products_id'], STORE_COUNTRY
            );
	    $SQ = new products_quantity($pID);
	    $stock = $SQ->get_available1_qty();
            if($export_params['only_v1'] === true and $stock < 1){
                continue;
            }
	    $delivery_date = '';
	    if($products['products_shippingtime'] > 0){
		$delivery_date = xtc_get_shipping_status_name($products['products_shippingtime']);
	    }
	    $isbn13 = '';
	    
	    // BOF - GRUPPEN
	    $products_characteristics_data = array();
            $allocs = $gh->get_allocated_product_group_characteristic_values($products['products_id']);
            if(is_countable($allocs) and sizeOf($allocs)){
                $products_characteristics_data = $allocs;
            }
	    $pc_string = '';
	    if(sizeOf($products_characteristics_data)){
		$pc_string = '<table border="0" id="pctable">';
		foreach($products_characteristics_data as $gdata){
			$pc_string .= sprintf('<tr><td>%s</td><td>%s</td></tr>',
				$gdata['title'],$gdata['value']
			);
		}
		$pc_string .= '</table>';
	    }
	    // EOF GRUPPEN
			
	    $products_price = $xtPrice->xtcGetPrice($products['products_id'],
		$format=false,
		1,
		$products_tax_class_id,
		''
	    );
				
	    // get product categorie
	    $categorie_query=xtc_db_query("SELECT
						categories_id
						FROM ".TABLE_PRODUCTS_TO_CATEGORIES."
						WHERE products_id='".$products['products_id']."' and categories_id='".$products['categories_id']."'");
	    while ($categorie_data=xtc_db_fetch_array($categorie_query)) {
		$categories=$categorie_data['categories_id'];
	    }
	    // remove trash
	    $products_description = strip_tags($products['products_description'],'<br><p>');
	    $products_description = str_replace("'",", ",$products_description);
	    $products_description = str_replace("\n"," ",$products_description);
	    $products_description = str_replace("\r"," ",$products_description);
	    $products_description = str_replace("\t"," ",$products_description);
	    $products_description = str_replace("\v"," ",$products_description);
	    $products_description = str_replace("&quot,"," \"",$products_description);
	    $products_description = str_replace("&qout,"," \"",$products_description);
	    $products_description = str_replace(chr(13)," ",$products_description);

	    $products_short_description = strip_tags($products['products_short_description'],'<br><p>');
	    $products_short_description = str_replace("'",", ",$products_short_description);
	    $products_short_description = str_replace("\n"," ",$products_short_description);
	    $products_short_description = str_replace("\r"," ",$products_short_description);
	    $products_short_description = str_replace("\t"," ",$products_short_description);
	    $products_short_description = str_replace("\v"," ",$products_short_description);
	    $products_short_description = str_replace("&quot,"," \"",$products_short_description);
	    $products_short_description = str_replace("&qout,"," \"",$products_short_description);
	    $products_short_description = str_replace(chr(13)," ",$products_short_description);
	    $products_short_description = substr($products_short_description, 0, 130);

	    //$cat = $this->buildCAT($categories);
	    $cat = $this->getCategoryName($categories);
	    $cat = str_replace("\n"," ",$cat);
	    $cat = str_replace("\r"," ",$cat);
	    $cat = str_replace('"',"'",$cat);
	    $cat = str_replace("\t"," ",$cat);
	    $cat = str_replace("\v"," ",$cat);
	    $cat = str_replace("&quot,"," \"",$cat);
	    $cat = str_replace("&qout,"," \"",$cat);
	    $cat = str_replace(chr(13)," ",$cat);
	    $cat = $this->replace_html_entities($cat);
				
	    if ($products['products_image'] != ''){
		    $image_small = HTTP_CATALOG_SERVER . 'images/product_images/thumbnail_images/'.$products['products_image'];
		    $image_big = HTTP_CATALOG_SERVER . 'images/product_images/popup_images/' .$products['products_image'];
	    }else{
		    $image_small = '';
		    $image_big = '';
	    }

	    $mo_images_query = xtc_db_query("SELECT * FROM products_images WHERE products_id='".$pID."' AND noshop='0' ORDER BY image_nr LIMIT 4");
	    $images_array = array(
		    0=>'',1=>'',2=>'',3=>''
	    );
	    $moct = 0;
	    while($mo_images = xtc_db_fetch_array($mo_images_query)){
		    $images_array[$moct] = HTTP_CATALOG_SERVER . 'images/product_images/popup_images/' . $mo_images['image_name'];
		    $moct++;
	    }
	
	    //create content
//	    $link = HTTP_CATALOG_SERVER.'product_info.php?products_id=' . $products['products_id'];
            $link = xtc_href_link_from_admin('product_info.php','products_id=' . $products['products_id']);
	    $pID = $products['products_id'];
	    // versandkosten DE
	    $group_id_germany = main::get_shipping_graduation_groups_id_by_countries_id(STORE_COUNTRY);
	    $pweight = xtc_get_ext_products_weight($pID);
	    if(MODULE_YATEGO_STATUS == 'True'){
		if(main::get_ext_shipping_costs_status($pID)){
			$ext_additionalcosts = main::get_product_shipping_extra_charges($pID, $group_id_germany);

			$costs = main::get_ext_shipping_costs($pID);
			foreach($costs as $group_id => $qty_array){
				if($group_id_germany == $group_id){
					$brutto = true;
					$shipping_price = main::calc_yes_modul($ext_additionalcosts+$qty_array[1],$group_id,$pweight,$pID,$brutto);
				}
			}
		}else{
		    $qty = 1;
		    $grad_query = xtc_db_query("select * from shipping_graduation WHERE value=1");
		    $grad = xtc_db_fetch_array($grad_query);
		    $gID = $grad['shipping_graduation_id'];
		    $groups_query = xtc_db_query("select * from shipping_graduation_groups ORDER BY shipping_graduation_groups_id");
		    $extra_charge = main::get_product_shipping_extra_charges($pID, $group_id_germany);
		    while($groups = xtc_db_fetch_array($groups_query)){
			$group_id = $groups['shipping_graduation_groups_id'];
			if($group_id_germany == $group_id){
				// pweight nehmen wir fuer die kalkulation des Preises
				$weight_query = xtc_db_query("select * from shipping_graduation_weights order by weight DESC");
				while ($weight = xtc_db_fetch_array($weight_query)) {
					if((float)$pweight <= (float)$weight['weight']){
						$wID = $weight['shipping_graduation_weights_id'];
					}
				}
				$grad_query_raw = sprintf("SELECT grad_value FROM shipping_graduation_values WHERE shipping_graduation_weights_id='%s' and shipping_graduation_groups_id='%s' and shipping_graduation_id='%s'",$wID,$group_id,$gID);
				$grad_query = xtc_db_query($grad_query_raw);
				$grad = xtc_db_fetch_array($grad_query);

				$product_shipping = $grad['grad_value']+$extra_charge;

				$brutto = true;
				$price = main::calc_yes_modul($product_shipping,$group_id,$pweight,$pID,$brutto);
				$tax_value = 0; // GUTE FRAGE, ICH HAB HIERFUER NOCH KEIN HANDLING
				$tax_price = $price*(($tax_value+100)/100);
				$c_array = main::get_group_countries($group_id);
				if(sizeOf($c_array)>0){
					$shipping_price = number_format($tax_price,2,',','.');
				}
			}
		    }
		} // end if !get_ext_shipping_costs_status(pID)
	    } // end if module yatego status true
	    //
	    // BOF - Free Shipping TICKET 1890
	    if(defined('MODULE_SHIPPING_FREECOUNT_STATUS') and MODULE_SHIPPING_FREECOUNT_STATUS == 'True'){
		if(round($products_price,2) >= MODULE_SHIPPING_FREECOUNT_AMOUNT){
		    $shipping_price = number_format(0,2,',','');
		}
	    }
	    // EOF - Free Shipping TICKET 1890
	    switch($export_params['title']){
		    case 'ebay':
                        if(xtc_not_null($products['ebay_title'])){
                                $title = $products['ebay_title'];
                        }else{
                                $title = $products['products_name'];
                        }
                        break;
		    default:
                        if(strtolower(CHARSET) == 'utf-8'){
                            $title = $products['products_name'];
                        }else{
                            //$title = mb_convert_encoding($products['products_name'],'UTF-8','ISO-8859-15');
                            $title = $products['products_name'];
                        }
                        break;
	    }
	    $title = str_replace("\n"," ",$title);
	    $title = str_replace("\r"," ",$title);
	    $title = str_replace('"',"'",$title);
	    $title = $this->prepare_string($title,false);
	    $category_string_array = array();
	    $category_path_array = xtc_generate_category_path($products['products_id'],'product');
	    $category_path = current($category_path_array);
	    for($ci=0;$ci<sizeOf($category_path);$ci++){
//		    $category_string_array[] = yes_encode_string($category_path[$ci]['text']);
		    $category_string_array[] = $this->cross_encoding($category_path[$ci]['text']);
	    }
	    $category_string = implode('/',$category_string_array);
            
	    $quantity_unit = '';
	    $package_size = '';
	    $package_size_full = '';
	    if($products['products_vpe_status'] == 1){
		$package_size = number_format($products['products_vpe_value'],4,'.','');
		$quantity_unit = xtc_get_products_vpe_name($products['products_vpe']);
		$package_size_full = ($products_price <> 0 && $package_size <> 0)
                    ? number_format($products_price/$package_size,2,',','.').' '.DEFAULT_CURRENCY.' / '.$quantity_unit
                    : 0;
                        
	    }
            $variants_child_title = (isset($products['slave_title'])) ? $products['slave_title'] : '';
            if($variants_child_title != ''){
                $variants_child_title = str_replace("\n"," ",$variants_child_title);
                $variants_child_title = str_replace("\r"," ",$variants_child_title);
                $variants_child_title = str_replace('"',"'",$variants_child_title);
                $variants_child_title = $this->prepare_string($variants_child_title,false);
            }
	    $promo_text = $_REQUEST['configuration']['MODULE_YATEGO_PROMO_TEXT']??'';
            
            $condition = '';
            if($products['products_conditions_id']>0){
                $condition = \YES4Trade\Model\products_conditions::get_condition_title(
                        $products['products_conditions_id'], 
                        $this->language_id
                );
            }
	    $data = array(
				$pID,
				$this->prepare_string($products['products_model']),
				$title,
				xtc_get_tax_rate($products_tax_class_id,STORE_COUNTRY),
				number_format($products_price,2,',',''),
				'',
				'',
				'0',
				'0',
				$shipping_price,
				'1',
				$this->prepare_string($products_short_description),
				$this->prepare_string($products_description.$pc_string),
				$link,
				'0',
				$image_big,
				$images_array[0],
				$images_array[1],
				$images_array[2],
				$images_array[3],
				$category_string,
				$variants_child_title,
				'-1',
				$stock,
				$delivery_date, //delivery_date',
				$quantity_unit, //quantity_unit',
				$package_size, //package_size',
				'', //cross_selling',
				$this->prepare_string($products['products_ean']),
				$this->prepare_string($isbn13),
				$this->prepare_string($products['manufacturers_name']),
				$this->prepare_string($products['mpn']),
				'', //delitem',
				'', //status',
				'', //top_offer'
				$package_size_full,
				$promo_text,
				$condition
			);
			$final_data = array();
                        // QUOTEN UND KONVERTIEREN
			foreach($data as $kv){
				$final_data[] = '"'.iconv('UTF-8','WINDOWS-1252//TRANSLIT',$kv).'"';
			}
			$schema .= implode($this->delimiter,$final_data)."\r\n";
			$counter++;
		}
		    $filename = sprintf('PART_%s.csv',$start);
		    $basics->create_file($export_params['particle_path'].$filename, $schema);
		    if( ($start+$max_items >= $num_total) or $counter < $max_items ){
			    // KOMPLETT ERZEUGEN
			    $schema = implode($this->delimiter,$header)."\r\n";
			    $files = $basics->get_directory_content($export_params['particle_path']);
			    foreach($files as $f){
				    $fp = fopen($export_params['particle_path'].$f,"rb");
				    $schema .= fread($fp, filesize($export_params['particle_path']. $f));
				    fclose($fp);
				    unlink($export_params['particle_path'].$f);
			    }
			    // create File
			    if(!isset($file) or $file==''){
				    $file = $_REQUEST['configuration'][0];
			    }
			    $directory_without_slash = substr($export_params['particle_path'],0,strlen($export_params['particle_path'])-1);
			    $basics->create_file($export_params['particle_path'] . $file, $schema);
			    $basics->zip_file($directory_without_slash, $file, $file.'.zip', true);

			    switch ($export_params['export']) {
				    case 'yes':
    //						unlink(DIR_FS_CATALOG.'../ebaymich/' . $file);

					    header($_SERVER['SERVER_PROTOCOL'].' 200 OK');
					    header("Content-Type: application/zip");
					    header("Content-Transfer-Encoding: Binary");
					    header("Content-Length: ".filesize($export_params['particle_path']. $file.'.zip'));
					    header("Content-Disposition: attachment; filename=\"".$file.".zip\"");
					    readfile($export_params['particle_path']. $file.'.zip');
					    unlink($export_params['particle_path']. $file.'.zip');
					    exit;
					    break;
				    case 'no':
						if(!is_file($export_params['particle_path']. $file.'.zip')){
							die('Export Datei '.$export_params['particle_path']. $file.'.zip wurde nicht erstellt.');
						}
						if(!is_dir(DIR_FS_CATALOG.'ebaymich/') or !is_writable(DIR_FS_CATALOG.'ebaymich/')){
							die('Export Datei konnte nicht in '.DIR_FS_CATALOG.'ebaymich/ exportiert werden. Verzeichnis existiert nicht oder ist nicht schreibbar.');
						}
						copy($export_params['particle_path']. $file.'.zip',DIR_FS_CATALOG.'ebaymich/'.$file.'.zip');
						unlink($export_params['particle_path']. $file.'.zip');
						if($this->from_cron){
							die('ebaymich/'.$file.".zip wurde erzeugt\r\n");
						}else{
							$messageStack->add_session(sprintf(MSG_SUCCESS_FILE_EXPORTED,$file.'.zip'),'success');
						}
						//echo 'Kann '.$file.'.zip nicht von '.$export_params['particle_path'].' in '.DIR_FS_CATALOG.'ebaymich/ speichern. Fehler: '.$e->getMessage();
						break;
			    }
		    }else{
			if($this->from_cron){
			    die("\r\nGENERATED FILE: $filename\r\n".'Start: '.$start.' / Generated: '.($counter-1).' / Total: '.$num_total." / MAX: $max_items\r\n");
			}else{
			    // redirect
			    if(isset($_POST['title'])){
				    $_GET["configuration[\"MODULE_YATEGO_FILE\"]"] = $file;
				    $_GET["configuration[\"MODULE_YATEGO_PROMO_TEXT\"]"] = urldecode($_REQUEST['configuration']['MODULE_YATEGO_PROMO_TEXT']);
				    $_GET['status'] = $_REQUEST['status'];
				    $_GET['export'] = $_REQUEST['export'];
				    $_GET['title'] = $_REQUEST['title'];
				    $_GET['allCat'] = $_REQUEST['allCat'];
				    $_GET['export_linked_products'] = ((isset($_REQUEST['export_linked_products']))?$_REQUEST['export_linked_products']:'');
			    }
			    $next_link = xtc_href_link('module_export.php',xtc_get_all_get_params(array('start')).'start='.($start+$max_items));
			    xtc_redirect($next_link);
			}
		    }
    }

    function display() {

        /* WIR WOLLEN AUSGEWAEHLTE KATEGORIEN EXPORTEN */
        $visible_categories_query = xtc_db_query("SELECT categories_id FROM categories WHERE parent_id=0 AND categories_status=1");
        while($visible_categories = xtc_db_fetch_array($visible_categories_query)){
            $catID = $visible_categories['categories_id'];
            $this->categories_string .= xtc_draw_separator().$this->drawCatBox($catID,$catID).$this->getCategoryName($catID).'<br>';
            $this->tree[$catID] = $this->buildCATTree($catID,$level = 0,$path=$catID);
        }
        $this->categories_string = '<table border="0" cellspacing="0"><tr><td class="smallText">'.$this->categories_string.'</td></tr></table>';

        $customers_statuses_array = xtc_get_customers_statuses();

        return array('text' =>  
            $this->getCategoryJSString().EXPORT_STATUS_TYPE.'<br />'.
            EXPORT_STATUS_TYPE.'<br />'.
            EXPORT_STATUS.'<br />'.
            xtc_draw_pull_down_menu('status',$customers_statuses_array, '1').'<br />'.
            EXPORT_TYPE.'<br />'.
            EXPORT.'<br />'.
            xtc_draw_radio_field('export', 'yes',true).EXPORT_YES.'<br />'.
            xtc_draw_radio_field('export', 'no',false).EXPORT_NO.'<br />'.
            '<br />'.
            EXPORT_TITLE.'<br />'.
            xtc_draw_radio_field('title','ebay',(($this->ebay_title)?true:false)).EXPORT_EBAY_TITLE.'<br />'.
            xtc_draw_radio_field('title','product',(($this->ebay_title)?false:true)).EXPORT_PRODUCT_TITLE.'<br /><br />'.
            '<b>Exportiere Produkte aus Kategorie:</b><br />'.
            '<input type="checkbox" name="allCat" value="1" CHECKED onClick="allCatFunc();"> Alle Kategorien<br />'.
            $this->categories_string.
            '<p><input type="checkbox" name="default_category" value="1" />'.EXPORT_DEFAULT_CATEGORY.'</p>'.
            '<input type="checkbox" name="export_linked_products" value="1" />'.EXPORT_LINKED_PRODUCTS.'<br />'.
            '<br />'.
            yes_draw_href_button(IMAGE_EXPORT, '', 'width: 140px;', 'submit').
            yes_draw_href_button(IMAGE_CANCEL, xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=yatego'), 'width: 140px;', 'button')
        );
    }
    function prepare_string($string,$replace_gaense=true){
		if($replace_gaense)
			$string = str_replace('"','""',$string);
                if(stristr(CHARSET, 'utf-8')){
                    //$string = html_entity_decode($string, ENT_HTML401,'utf-8');
                }else{
                    $string = html_entity_decode($string, ENT_HTML401,'iso-8859-15');
                }
                return $this->cross_encoding($string);
	}

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_YATEGO_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_YATEGO_FILE', 'yatego.csv',  '6', '1', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_YATEGO_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_YATEGO_PROMO_TEXT', '',  '6', '2', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_YATEGO_EXPORT_ONLY_V1', 'False',  '6', '3', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
}

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_YATEGO_STATUS','MODULE_YATEGO_FILE','MODULE_YATEGO_PROMO_TEXT','MODULE_YATEGO_EXPORT_ONLY_V1');
    }

    private function cross_encoding($str){
        if(strtolower(CHARSET) == 'utf-8'){
            return $str;
        }
	if(mb_detect_encoding($str) != 'ASCII' && mb_detect_encoding($str) != 'UTF-8'){
		return mb_convert_encoding($str,'UTF-8','ISO-8859-15');
	}else{
		if(mb_detect_encoding($str) == 'UTF-8'){
			return mb_convert_encoding($str,'UTF-8','ISO-8859-15');
		}
	}
	if(mb_detect_encoding($str) != 'ASCII' && mb_detect_encoding($str) != 'UTF-8'){
		return utf8_encode($str);
	}
	return $str;
    }
}
