<?php
class yes_export_module_product_group_characteristic extends yes_export_module {
    function __construct($module_name){
	$this->id = $module_name;
	$this->text = 'Produktgruppenmerkmal';
	$this->type = 'short_text';
	$this->params = 'class="yep_pgc"';
	$this->change_default_input_function = 'yep_select_product_group_characteristic';
	$this->language_id = $_SESSION['languages_id'];
	/*
	$this->database_table = 'products';
	$this->database_table_field = 'products_weight';
	$this->function_name = 'xtc_get_ext_products_weight';
	$this->function_file = DIR_FS_INC.'xtc_collis.inc.php';
	$this->function_class = '';
	 */
    }
    
    function get_value_from_product_instance($product,$value) {
	$values = explode('_',$value);
	$pc_set_array = array();
	$query = xtc_db_query(sprintf(
		"SELECT no_sets FROM products_characteristic WHERE products_characteristic_id='%s'",
		$values[1]
	));
	$record = xtc_db_fetch_array($query);
	switch($record['no_sets']){
	    case '1':
		// TEXT VALUE
		$query = xtc_db_query(sprintf(
			"SELECT content FROM products_characteristic_text_values WHERE products_id='%s' AND products_characteristic_id='%s' AND language_id='%s'",
			$product->info['products_id'],$values[1],$this->language_id
		));
		$record = xtc_db_fetch_array($query);
		return $record['content'];
		break;
	    default:
		// SELECT VALUE
		$query = xtc_db_query(sprintf(
			"SELECT pcsd.title FROM products_to_characteristics p2c LEFT JOIN products_characteristic_set pcs USING(products_characteristic_set_id) LEFT JOIN products_characteristic_set_description pcsd USING(products_characteristic_set_id) WHERE p2c.products_id='%s' AND pcsd.language_id='%s' AND pcs.products_characteristic_id='%s'",
			$product->info['products_id'],$this->language_id,$values[1]
		));
		$record = xtc_db_fetch_array($query);
		return $record['title'];
		break;
	}
	
	return basename(__FILE__).': get_value_from_product_instance() ausbauen';
    }
    
    public function get_input_special_edit(){
	return '<img src="images/icons/icon_edit.gif" border="0" class="yep_pgc_selector" id="'.$this->id.'" />';
    }
    public function get_input_subtitle($default_value){
	return $this->get_pgc_string($default_value);
    }
    
    private function get_pgc_string($value){
	$str = '';
	$values = explode('_',$value);
	$pgID = (int)xtc_db_input($values[0]);
	$pgcID = (int)xtc_db_input($values[1]);
	$query = xtc_db_query(sprintf(
		"SELECT groups_title FROM `groups` WHERE groups_id='%s'",$pgID
	));
	$record = xtc_db_fetch_array($query);
	$str .= $record['groups_title'].' / ';
	
	$query = xtc_db_query(sprintf(
		"SELECT title FROM products_characteristic_description WHERE products_characteristic_id='%s'",$pgcID
	));
	$record = xtc_db_fetch_array($query);
	$str .= $record['title'];
	return $str;
    }
    
}

?>
