<?php
/* --------------------------------------------------------------
   $Id: manufacturers.php,v 1.20 2018/01/08 09:01:41 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(manufacturers.php,v 1.52 2003/03/22); www.oscommerce.com 
   (c) 2003	 nextcommerce (manufacturers.php,v 1.9 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------*/

require('includes/application_top.php');
require_once(DIR_WS_CLASSES.'class.ebay.php');
require_once(DIR_WS_CLASSES.'product.php');
$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';
switch ($action) {
	case 'insert':
	case 'save':
                if(isset($_GET['mID'])){
                    $manufacturers_id = xtc_db_prepare_input($_GET['mID']);
                }else{
                    $manufacturers_id = null;
                }
                if(isset($_POST['manufacturers_name'])){
                    $manufacturers_name = xtc_db_prepare_input($_POST['manufacturers_name']);
                }else{
                    $manufacturers_name = '';
                }
                if(isset($_POST['short_name'])){
                    $short_name = xtc_db_prepare_input($_POST['short_name']);
                }else{
                    $short_name = '';
                }

		$sql_data_array = array(
		    'manufacturers_name' => $manufacturers_name,
		    'short_name'=>$short_name,
                    'manufacturer_cityname'=>(isset($_POST['manufacturer_cityname']))?$_POST['manufacturer_cityname']:'',
                    'manufacturer_companyname'=>(isset($_POST['manufacturer_companyname']))?$_POST['manufacturer_companyname']:'',
                    'manufacturer_country'=>(isset($_POST['manufacturer_country']))?$_POST['manufacturer_country']:'',
                    'manufacturer_email'=>(isset($_POST['manufacturer_email']))?$_POST['manufacturer_email']:'',
                    'manufacturer_phone'=>(isset($_POST['manufacturer_phone']))?$_POST['manufacturer_phone']:'',
                    'manufacturer_postalcode'=>(isset($_POST['manufacturer_postalcode']))?$_POST['manufacturer_postalcode']:'',
                    'manufacturer_stateorprovince'=>(isset($_POST['manufacturer_stateorprovince']))?$_POST['manufacturer_stateorprovince']:'',
                    'manufacturer_street1'=>(isset($_POST['manufacturer_street1']))?$_POST['manufacturer_street1']:'',
                    'manufacturer_street2'=>(isset($_POST['manufacturer_street2']))?$_POST['manufacturer_street2']:'',
                    
		);

		if ($_GET['action'] == 'insert') {
			$insert_sql_data = array('date_added' => date('Y-m-d H:i:s'));
			$sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
                        $new = new \YES4Trade\Model\manufacturer($sql_data_array);
			$manufacturers_id = (int)$new->create();
		} elseif ($_GET['action'] == 'save') {
			$update_sql_data = [
                            'last_modified' => date('Y-m-d H:i:s'),
                            'manufacturers_id'=>(int)$manufacturers_id,
                        ];
			$sql_data_array = xtc_array_merge($sql_data_array, $update_sql_data);
                        $upd = new \YES4Trade\Model\manufacturer($sql_data_array);
                        $upd->update();
		}

		$dir_manufacturers=DIR_FS_CATALOG_IMAGES."/manufacturers";
                $manufacturerObj = \YES4Trade\Model\manufacturer::get_by_manufacturers_id($manufacturers_id);
		if($_GET['action'] == 'save' and isset($_REQUEST['delete_manufacturers_image']) and $_REQUEST['delete_manufacturers_image'] == 1){
		    if($manufacturerObj->manufacturers_image != ''){
			if(is_file(DIR_FS_CATALOG.'images/'.$manufacturerObj->manufacturers_image)){
			    unlink(DIR_FS_CATALOG.'images/'.$manufacturerObj->manufacturers_image);
			}
                        $manufacturerObj->manufacturers_image = '';
                        $manufacturerObj->last_modified = date('Y-m-d H:i:s');
                        $manufacturerObj->update();
		    }
		}else{
		    if ($manufacturers_image = &xtc_try_upload('manufacturers_image', $dir_manufacturers)) {
                        $manufacturerObj->manufacturers_image = 'manufacturers/'.$manufacturers_image->filename;
                        $manufacturerObj->update();
		    }
		}

		$languages = xtc_get_languages();
		for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
			$manufacturers_url_array = $_POST['manufacturers_url'];
			$language_id = $languages[$i]['id'];

			$sql_data_array = array(
				'manufacturers_url' => xtc_db_prepare_input($manufacturers_url_array[$language_id]),
				'manufacturers_meta_title' => xtc_db_prepare_input($_REQUEST['manufacturers_meta_title'][$language_id]),
				'manufacturers_meta_description' => xtc_db_prepare_input($_REQUEST['manufacturers_meta_description'][$language_id]),
				'manufacturers_meta_keywords' => xtc_db_prepare_input($_REQUEST['manufacturers_meta_keywords'][$language_id]),
			);

			if ($_GET['action'] == 'insert') {
				$insert_sql_data = array(
					'manufacturers_id' => (int)$manufacturers_id,
					'languages_id' => $language_id
				);
				$sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
				xtc_db_perform(TABLE_MANUFACTURERS_INFO, $sql_data_array);
			} elseif ($_GET['action'] == 'save') {
				xtc_db_perform(TABLE_MANUFACTURERS_INFO, $sql_data_array, 'update', "manufacturers_id = '" . xtc_db_input($manufacturers_id) . "' and languages_id = '" . $language_id . "'");
			}
		}

		if (USE_CACHE == 'true') {
			xtc_reset_cache_block('manufacturers');
		}
                foreach($InstanceCache->getItemsByTags(['admin','shop']) as $cn=>$cd){
                    if(strpos($cd->getKey(),'manufacturers')>-1){
                        $InstanceCache->deleteItem($cd->getKey()); // manufacturers
                    }
                }
		xtc_redirect(xtc_href_link(FILENAME_MANUFACTURERS, 'page=' . $_GET['page'] . '&mID=' . $manufacturers_id));
		break;
	case 'deleteconfirm':
            $EBAYAPI = new ebayAPI();
            $manufacturers_id = xtc_db_prepare_input($_GET['mID']);
            $manufacturerObj = \YES4Trade\Model\manufacturer::get_by_manufacturers_id($manufacturers_id);
            if ($_POST['delete_image'] == 'on' and !empty($manufacturerObj->manufacturers_image)) {
		$image_location = DIR_FS_DOCUMENT_ROOT . DIR_WS_IMAGES . $manufacturerObj->manufacturers_image;
		if (file_exists($image_location)) {
                    @unlink($image_location);
                }
            }
            xtc_db_query("delete from " . TABLE_MANUFACTURERS_INFO . " where manufacturers_id = '" . xtc_db_input($manufacturers_id) . "'");
            
            \YES4Trade\Model\manufacturer::delete($manufacturers_id);

            if (isset($_POST['delete_products']) and $_POST['delete_products'] == '1') {
                $products_query = xtc_db_query("select products_id from " . TABLE_PRODUCTS . " where manufacturers_id = '" . xtc_db_input($manufacturers_id) . "'");
                while ($products = xtc_db_fetch_array($products_query)) {
                    xtc_remove_product($products['products_id']);
                }
            } else {
		xtc_db_query("update " . TABLE_PRODUCTS . " set manufacturers_id = '' where manufacturers_id = '" . xtc_db_input($manufacturers_id) . "'");
            }
            if (USE_CACHE == 'true') {
		xtc_reset_cache_block('manufacturers');
            }
            foreach($InstanceCache->getItemsByTags(['admin','shop']) as $cn=>$cd){
                    if(strpos($cd->getKey(),'manufacturers')>-1){
                        $InstanceCache->deleteItem($cd->getKey()); // manufacturers
                    }
            }
            xtc_redirect(xtc_href_link(FILENAME_MANUFACTURERS, 'page=' . $_GET['page']));
            break;
}
$manufacturers_query_raw = "select * from " . TABLE_MANUFACTURERS . " order by manufacturers_name";
$manufacturers_split = new splitPageResults($_GET['page'], MAX_DISPLAY_SEARCH_RESULTS, $manufacturers_query_raw, $manufacturers_query_numrows);
yes_draw_pre_header();
yes_draw_header(TITLE);
$tmp_manufacturers = [];
$manufacturers_query = xtc_db_query($manufacturers_query_raw);
while ($manufacturers = xtc_db_fetch_array($manufacturers_query)) {
    $tmp_manufacturers[] = $manufacturers;
}
foreach($tmp_manufacturers as $manufacturers){
	if (((!isset($_GET['mID'])) || (@$_GET['mID'] == $manufacturers['manufacturers_id'])) && (!isset($mInfo)) && (!isset($_GET['action']) or substr($_GET['action'], 0, 3) != 'new')) {
		$manufacturer_products_query = xtc_db_query("select count(*) as products_count from " . TABLE_PRODUCTS . " where manufacturers_id = '" . $manufacturers['manufacturers_id'] . "'");
		$manufacturer_products = xtc_db_fetch_array($manufacturer_products_query);

		$mInfo_array = xtc_array_merge($manufacturers, $manufacturer_products);
		$mInfo = new objectInfo($mInfo_array);
	}
}
$smarty = new yesSmarty;
$buttons = array();
if ($action != 'new') {
    $buttons[] = array('text'=>IMAGE_INSERT,
	'link'=>xtc_href_link(FILENAME_MANUFACTURERS, 'page=' . @$_GET['page'] . '&mID=' . $mInfo->manufacturers_id . '&action=new'),
	'lbOn'=>false,
	'auth'=>true
    );
}
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));
$smarty->display('manufacturers.html');
?>

<table border="0" cellspacing="2" cellpadding="0" width="100%">
<tr>
	<td width="80%" valign="top" class="ui-widget-content">
		<table class="yes-ui-table">
			<thead>
				<tr class="ui-widget-header">
					<th align="right" width="30">ID</th>
					<th><?php echo TABLE_HEADING_MANUFACTURERS; ?></th>
					<th><?php echo TABLE_HEADING_MANUFACTURERS_SHORT; ?></th>
					<th align="right"><?php echo TABLE_HEADING_ACTION; ?></th>
				</tr>
			</thead>
			<tfoot>
				<tr>
					<td colspan="4" align="center"><?php echo $manufacturers_split->display_count($manufacturers_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, $_GET['page'], TEXT_DISPLAY_NUMBER_OF_MANUFACTURERS); ?><br /><?php echo $manufacturers_split->display_links($manufacturers_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, MAX_DISPLAY_PAGE_LINKS, $_GET['page']); ?></td>
				</tr>
			</tfoot>
			<tbody>
<?php
$manufacturers_query = xtc_db_query($manufacturers_query_raw);
while ($manufacturers = xtc_db_fetch_array($manufacturers_query)) {
	if ( (isset($mInfo) and is_object($mInfo)) && ($manufacturers['manufacturers_id'] == $mInfo->manufacturers_id) ) {
		echo '              <tr class="ui-state-highlight" onmouseover="this.style.cursor=\'hand\'" onclick="document.location.href=\'' . xtc_href_link(FILENAME_MANUFACTURERS, 'page=' . $_GET['page'] . '&mID=' . $manufacturers['manufacturers_id'] . '&action=edit') . '\'">' . "\n";
	} else {
		echo '              <tr onmouseover="this.style.cursor=\'hand\'" onclick="document.location.href=\'' . xtc_href_link(FILENAME_MANUFACTURERS, 'page=' . $_GET['page'] . '&mID=' . $manufacturers['manufacturers_id']) . '\'">' . "\n";
	}
?>
					<td align="right"><?php echo $manufacturers['manufacturers_id']; ?></td>
					<td><?php echo $manufacturers['manufacturers_name']; ?></td>
					<td><?php echo $manufacturers['short_name']; ?></td>
					<td align="right"><?php if ( (isset($mInfo) and is_object($mInfo)) && ($manufacturers['manufacturers_id'] == $mInfo->manufacturers_id) ) { echo xtc_image(DIR_WS_IMAGES . 'icon_arrow_right.gif'); } else { echo '<a href="' . xtc_href_link(FILENAME_MANUFACTURERS, 'page=' . $_GET['page'] . '&mID=' . $manufacturers['manufacturers_id']) . '">' . xtc_image(DIR_WS_IMAGES . 'icon_info.gif', IMAGE_ICON_INFO) . '</a>'; } ?>&nbsp;</td>
				</tr>
<?php
}
?>
			</tbody>
		</table>
	</td><td valign="top" width="20%" class="ui-widget-content">
            
<?php
$heading = array();
$contents = array();
$adressf = [
    'manufacturer_companyname',
    'manufacturer_street1',
    'manufacturer_street2',
    'manufacturer_stateorprovince',
    'manufacturer_postalcode',
    'manufacturer_cityname',
    'manufacturer_country',
    'manufacturer_email',
    'manufacturer_phone',
];

switch ($action) {
	case 'new':
		$heading[] = array('text' => '<b>' . TEXT_HEADING_NEW_MANUFACTURER . '</b>');

		$contents = array('form' => xtc_draw_form('manufacturers', FILENAME_MANUFACTURERS, 'action=insert', 'post', 'enctype="multipart/form-data"'));
		$contents[] = array('text' => TEXT_NEW_INTRO);
		$contents[] = array('text' => '<br>' . TEXT_MANUFACTURERS_NAME . '<br>' . xtc_draw_input_field('manufacturers_name'));
		$contents[] = array('text' => '<br>' . TEXT_MANUFACTURERS_SHORT_NAME . '<br>' . xtc_draw_input_field('short_name','','maxlength="32"'));
		$contents[] = array('text' => '<br>' . TEXT_MANUFACTURERS_IMAGE . '<br>' . xtc_draw_file_field('manufacturers_image'));
                
                foreach($adressf as $a){
                    $contents[] = [
                        'text'=>sprintf('<br />%s<br />%s',
                            constant(strtoupper($a)),
                            xtc_draw_input_field($a)
                        )
                    ];
                 }
                
                

		$manufacturer_inputs_string = '';
		$manufacturer_meta_title_inputs_string = '';
		$manufacturer_meta_desc_inputs_string = '';
		$manufacturer_meta_keywords_inputs_string = '';
		$languages = xtc_get_languages();
		for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
			$manufacturer_inputs_string .= '<br>' . xtc_image(DIR_WS_LANGUAGES . $languages[$i]['directory'] . '/admin/images/' . $languages[$i]['image'], $languages[$i]['name']) . '&nbsp;' . xtc_draw_input_field('manufacturers_url[' . $languages[$i]['id'] . ']');
			$manufacturer_meta_title_inputs_string .= '<br />' . 
					xtc_image(DIR_WS_LANGUAGES . $languages[$i]['directory'] . '/admin/images/' . $languages[$i]['image'], $languages[$i]['name']) . '&nbsp;' . 
					xtc_draw_textarea_field('manufacturers_meta_title[' . $languages[$i]['id'] . ']', 'virtual',30,3,'');
			
			$manufacturer_meta_desc_inputs_string .= '<br />' . 
					xtc_image(DIR_WS_LANGUAGES . $languages[$i]['directory'] . '/admin/images/' . $languages[$i]['image'], $languages[$i]['name']) . '&nbsp;' . 
					xtc_draw_textarea_field('manufacturers_meta_description[' . $languages[$i]['id'] . ']','virtual',30,3,'');
			
			$manufacturer_meta_keywords_inputs_string .= '<br />' . 
					xtc_image(DIR_WS_LANGUAGES . $languages[$i]['directory'] . '/admin/images/' . $languages[$i]['image'], $languages[$i]['name']) . '&nbsp;' . 
					xtc_draw_textarea_field('manufacturers_meta_keywords[' . $languages[$i]['id'] . ']', 'virtual',30,3,'');
		}
		$contents[] = array('text' => '<br>' . TEXT_MANUFACTURERS_URL . $manufacturer_inputs_string);
		$contents[] = array('text' => '<br>' . TEXT_META_TITLE . $manufacturer_meta_title_inputs_string);
		$contents[] = array('text' => '<br>' . TEXT_META_DESCRIPTION . $manufacturer_meta_desc_inputs_string);
		$contents[] = array('text' => '<br>' . TEXT_META_KEYWORDS . $manufacturer_meta_keywords_inputs_string);
		$contents[] = array('align' => 'center', 'text' => yes_draw_href_button(IMAGE_SAVE,'','width: 160px','submit'));
                $contents[] = array('align' => 'center', 'text' => yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(FILENAME_MANUFACTURERS, 'page=' . $_GET['page']),'width: 160px'));
		break;
	case 'edit':
		$heading[] = array('text' => '<b>' . TEXT_HEADING_EDIT_MANUFACTURER . '</b>');

		$contents = array('form' => xtc_draw_form('manufacturers', FILENAME_MANUFACTURERS, 'page=' . $_GET['page'] . '&mID=' . $mInfo->manufacturers_id . '&action=save', 'post', 'enctype="multipart/form-data"'));
		$contents[] = array('text' => TEXT_EDIT_INTRO);
		$contents[] = array('text' => '<br>' . TEXT_MANUFACTURERS_NAME . '<br>' . 
                    xtc_draw_input_field('manufacturers_name', $mInfo->manufacturers_name)
                );
		$contents[] = array('text' => '<br>' . TEXT_MANUFACTURERS_SHORT_NAME . '<br>' . xtc_draw_input_field('short_name',$mInfo->short_name,'maxlength="32"'));
                foreach($adressf as $a){
                    $contents[] = [
                        'text' => sprintf('<br />%s<br />%s',
                            constant(strtoupper($a)),
                            xtc_draw_input_field($a, $mInfo->$a)
                         )
                    ];
                }
		$contents[] = array('text' => '<br>' . TEXT_MANUFACTURERS_IMAGE . '<br />' . 
		    xtc_draw_file_field('manufacturers_image') . '<br />' . 
		    (($mInfo->manufacturers_image != '')?'<img src="../images/'.$mInfo->manufacturers_image.'" border="0" style="max-width:100px; max-height: 100px" title="'.basename($mInfo->manufacturers_image).'" /><br />'.
			    '<input type="checkbox" name="delete_manufacturers_image" value="1" align="left" />'.IMAGE_DELETE
		    : '')
		);
                
		$manufacturer_url_inputs_string = '';
		$manufacturer_meta_title_inputs_string = '';
		$manufacturer_meta_desc_inputs_string = '';
		$manufacturer_meta_keywords_inputs_string = '';
		$languages = xtc_get_languages();
		for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
			$manufacturer_url_inputs_string .= '<br />' . 
					xtc_image(DIR_WS_LANGUAGES . $languages[$i]['directory'] . '/admin/images/' . $languages[$i]['image'], $languages[$i]['name']) . '&nbsp;' . 
					xtc_draw_input_field('manufacturers_url[' . $languages[$i]['id'] . ']', xtc_get_manufacturer_url($mInfo->manufacturers_id, $languages[$i]['id']));

			$meta_query = xtc_db_query(sprintf(
				"SELECT manufacturers_meta_title,manufacturers_meta_description,manufacturers_meta_keywords FROM manufacturers_info WHERE manufacturers_id=%s AND languages_id=%s",
				$mInfo->manufacturers_id, $languages[$i]['id']					
			));
			$meta = xtc_db_fetch_array($meta_query);
			$manufacturer_meta_title_inputs_string .= '<br />' . 
					xtc_image(DIR_WS_LANGUAGES . $languages[$i]['directory'] . '/admin/images/' . $languages[$i]['image'], $languages[$i]['name']) . '&nbsp;' . 
					xtc_draw_textarea_field('manufacturers_meta_title[' . $languages[$i]['id'] . ']', 'virtual',30,3,$meta['manufacturers_meta_title']);
			
			$manufacturer_meta_desc_inputs_string .= '<br />' . 
					xtc_image(DIR_WS_LANGUAGES . $languages[$i]['directory'] . '/admin/images/' . $languages[$i]['image'], $languages[$i]['name']) . '&nbsp;' . 
					xtc_draw_textarea_field('manufacturers_meta_description[' . $languages[$i]['id'] . ']','virtual',30,3, $meta['manufacturers_meta_description']);
			
			$manufacturer_meta_keywords_inputs_string .= '<br />' . 
					xtc_image(DIR_WS_LANGUAGES . $languages[$i]['directory'] . '/admin/images/' . $languages[$i]['image'], $languages[$i]['name']) . '&nbsp;' . 
					xtc_draw_textarea_field('manufacturers_meta_keywords[' . $languages[$i]['id'] . ']', 'virtual',30,3,$meta['manufacturers_meta_keywords']);
			
		}

		$contents[] = array('text' => '<br>' . TEXT_MANUFACTURERS_URL . $manufacturer_url_inputs_string);
		$contents[] = array('text' => '<br>' . TEXT_META_TITLE . $manufacturer_meta_title_inputs_string);
		$contents[] = array('text' => '<br>' . TEXT_META_DESCRIPTION . $manufacturer_meta_desc_inputs_string);
		$contents[] = array('text' => '<br>' . TEXT_META_KEYWORDS . $manufacturer_meta_keywords_inputs_string);
		$contents[] = array('align' => 'center', 'text' => yes_draw_href_button(IMAGE_SAVE,'','width: 160px','submit'));
                $contents[] = array('align' => 'center', 'text' => yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(FILENAME_MANUFACTURERS, 'page=' . $_GET['page'] . '&mID=' . $mInfo->manufacturers_id),'width: 160px'));
		break;
	case 'delete':
		$heading[] = array('text' => '<b>' . TEXT_HEADING_DELETE_MANUFACTURER . '</b>');

		$contents = array('form' => xtc_draw_form('manufacturers', FILENAME_MANUFACTURERS, 'page=' . $_GET['page'] . '&mID=' . $mInfo->manufacturers_id . '&action=deleteconfirm'));
		$contents[] = array('text' => TEXT_DELETE_INTRO);
		$contents[] = array('text' => '<br><b>' . $mInfo->manufacturers_name . '</b>');
		$contents[] = array('text' => '<br>' . xtc_draw_checkbox_field('delete_image', '', true) . ' ' . TEXT_DELETE_IMAGE);

		if ($mInfo->products_count > 0) {
                    if(defined('MAX_DELETE_PRODUCTS_LIMIT')){
                        $delete_limit = (int)MAX_DELETE_PRODUCTS_LIMIT;
                    }else{
                        $delete_limit = 1000;
                    }
                    $no_delete = true;
                    if($mInfo->products_count > $delete_limit){
                        $contents[] = array('text' => '<br /><font color="red"><b>' . sprintf(MSG_ERROR_DELETE_PRODUCTS_MAXIMUM, $delete_limit,$mInfo->products_count).'</b></font>');
                    }else{
                        $contents[] = array('text' => '<br>' . sprintf(TEXT_DELETE_WARNING_PRODUCTS, $mInfo->products_count));
                        if(isset($_GET['delete_products']) and $_GET['delete_products'] == 1){
                            $contents[] = array('text' => '<br />' . xtc_draw_checkbox_field('delete_products','1',true,false) . ' ' . TEXT_DELETE_PRODUCTS);
                            $products_array = array();
                            $products_query = xtc_db_query("select products_id from " . TABLE_PRODUCTS . " where manufacturers_id = '" . xtc_db_input($mInfo->manufacturers_id) . "'");
                            while ($products = xtc_db_fetch_array($products_query)) {
                                if($products['products_id'] > 0){
                                    $products_array[$products['products_id']] = true;
                                }
                            }
                            $contents[] = array('text'=>yes_draw_multiple_products_delete_check($products_array, 'input.delete_manufacturer_button'));
                        }else{
                            $contents[] = array('text' => '<br>' . xtc_draw_checkbox_field('delete_products','1') . ' ' . TEXT_DELETE_PRODUCTS);
                        }
                    }
		}

		$contents[] = array('align' => 'center', 'text' => yes_draw_href_button(IMAGE_DELETE,'','width: 160px','submit','ui-button ui-corner-all ui-state-error delete_manufacturer_button'));
                $contents[] = array('align' => 'center', 'text' => yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(FILENAME_MANUFACTURERS, 'page=' . $_GET['page'] . '&mID=' . $mInfo->manufacturers_id),'width: 160px;'));
		break;
	default:
		if (is_object($mInfo)) {
			$heading[] = array('text' => '<b>[ID '.$mInfo->manufacturers_id.'] ' . $mInfo->manufacturers_name . '</b>');

			$contents[] = array('align' => 'center', 'text' => yes_draw_href_button(IMAGE_EDIT,xtc_href_link(FILENAME_MANUFACTURERS, 'page=' . $_GET['page'] . '&mID=' . $mInfo->manufacturers_id . '&action=edit'),'width: 160px;'));
                        $contents[] = array('align' => 'center', 'text' => yes_draw_href_button(IMAGE_DELETE,xtc_href_link(FILENAME_MANUFACTURERS, 'page=' . $_GET['page'] . '&mID=' . $mInfo->manufacturers_id . '&action=delete'),'width: 160px;'));
			$contents[] = array('text' => '<br>' . TEXT_DATE_ADDED . ' ' . xtc_date_short($mInfo->date_added));
			if (xtc_not_null($mInfo->last_modified)) $contents[] = array('text' => TEXT_LAST_MODIFIED . ' ' . xtc_date_short($mInfo->last_modified));
                        
                        foreach($adressf as $a){
                            if(empty($mInfo->$a)){
                                continue;
                            }
                            $contents[] = [
                                'text'=>constant(strtoupper($a)).': '.$mInfo->$a,
                            ];
                        }
			$contents[] = array('text' => '<br>' . xtc_info_image($mInfo->manufacturers_image, basename($mInfo->manufacturers_image),100));
			$contents[] = array('text' => '<br>' . TEXT_PRODUCTS . ' <a href="' . xtc_href_link(FILENAME_CATEGORIES,'menugroup=products&manufacturers_id='.$mInfo->manufacturers_id).'">'.$mInfo->products_count.'</a>');
		}
		break;
}

if ( (xtc_not_null($heading)) && (xtc_not_null($contents)) ) {

    $box = new box;
    echo $box->infoBox($heading, $contents);

}
?>
	</td>
</tr>
</table>
<script>
$(function(){
    $('input[name="delete_products"]').on('change',function(){
        if($(this).prop('checked')){
            if(!confirm('<?php echo JS_REALLY_DELETE_MANUFACTURER_PRODUCTS; ?>')){
                return false;
            }
            window.location.href = '<?php echo xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('delete_products')).'delete_products=1'); ?>';
        }
    });
});
</script>
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
