<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/
   
require('includes/application_top.php');
require_once(DIR_WS_CLASSES.'class.ebay.php');
require_once(DIR_WS_CLASSES.'class.help.php');
require_once(DIR_WS_CLASSES.'order.php');
require_once(DIR_WS_CLASSES.'customer.php');
require_once(DIR_WS_CLASSES.'reclamation.php');
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'xtcPrice.php');
require_once(DIR_FS_INC . 'xtc_collis.inc.php');
require_once(DIR_FS_INC . 'xtc_serials.inc.php');
require(DIR_FS_INC.'xtc_is_shipping_before_payment.inc.php');
require_once(DIR_FS_INC . 'yes_end_auction_add.inc.php');
$EBAYAPI = new ebayAPI();
$allow_buchen = true; // rekla typ 4 darf nix buchen

$oID = intval(xtc_db_input($_GET['oID']??0));
$rID = intval(xtc_db_input($_GET['rID']??0));
$action = $_GET['action'] ?? '';
        
if( $oID > 0 ){
    $O = new order($oID);
    if($O->info['orders_status'] != ORDERS_STATUS_BEZAHLT){
        if( !xtc_is_shipping_before_payment($O->info['payment_method']) and ($O->info['orders_status'] == 1 or $O->info['orders_status'] == 2 or $O->info['orders_status'] == ORDERS_STATUS_UPSELLING or $O->info['orders_status'] == ORDERS_STATUS_STORNIERT ) ){
            $messageStack->add_session(MSG_ERROR_ONLY_ORDERS_STATUS_BEZAHLT,'error');
            xtc_redirect('orders.php',xtc_get_all_get_params(array('action')).'action=edit');
        }
    }
    $check_query = xtc_db_query(sprintf(
        "SELECT orders_id FROM otc WHERE orders_id='%d'",
        $oID
    ));
    $check_num = xtc_db_num_rows($check_query);
    if($check_num > 0){
        // WARENAUSGABE FAND SCHONMAL STATT
        // JETZT NOCH PRUEFEN OB OFFENE POSTEN

        $query = xtc_db_query(sprintf(
            "SELECT orders_products_id FROM %s WHERE orders_id='%d' AND products_quantity-quantity_shipped-not_ship > 0",
            TABLE_ORDERS_PRODUCTS,$oID
        ));
        if(!xtc_db_num_rows($query)){
            $messageStack->add_session(MSG_ERROR_ORDER_HAS_OTC,'error');
            xtc_redirect('orders.php',xtc_get_all_get_params(array('action')).'action=edit');
        }
    }

    $has_not_ship = false;
    $query = xtc_db_query(sprintf(
        "SELECT products_quantity-quantity_shipped as differenz FROM %s WHERE orders_id='%d'",
        TABLE_ORDERS_PRODUCTS,$oID
    ));
    while($record = xtc_db_fetch_array($query)){
        if($record['differenz'] > 0){
            $has_not_ship = true;
        }
    }
    if(!$has_not_ship){
        $messageStack->add_session(MSG_ERROR_ORDER_ALWAYS_SHIPPED,'error');
        xtc_redirect('orders.php',xtc_get_all_get_params(array('action')).'action=edit');
    }
}
if( $rID > 0 ){
    $R = new reclamation($rID);
    if($R->info['reclamations_status'] != 2){
            $messageStack->add_session(MSG_ERROR_ONLY_RECLAMATIONS_STATUS_IN_BEARBEITUNG,'error');
            xtc_redirect('reclamations.php',xtc_get_all_get_params(array('action')).'action=edit');
    }
    if(!in_array($R->info['reclamations_type'],array(3,4))){
            $messageStack->add_session(MSG_ERROR_ONLY_RECLAMATIONS_TYPE_3_AND_4,'error');
            xtc_redirect('reclamations.php',xtc_get_all_get_params(array('action')).'action=edit');
    }
    if($R->info['reclamations_type'] == 4){
        $allow_buchen = false;
    }
    $check_query = xtc_db_query("SELECT reclamations_id FROM otc WHERE reclamations_id='".$rID."'");
    $check_num = xtc_db_num_rows($check_query);
    if($check_num > 0){
            $messageStack->add_session(MSG_ERROR_RECLAMATION_HAS_OTC,'error');
            xtc_redirect('reclamations.php',xtc_get_all_get_params(array('action')).'action=edit');
    }
    $check2_query = xtc_db_query("SELECT reclamations_id FROM shippings WHERE reclamations_id='".$rID."' AND status=1");
    $check2_num = xtc_db_num_rows($check2_query);
    if($check2_num > 0){
            $messageStack->add_session(MSG_ERROR_RECLAMATION_ALWAYS_SHIPPED,'error');
            xtc_redirect('reclamations.php',xtc_get_all_get_params(array('action')).'action=edit');
    }
}
switch ($action) {
    case 'save':
        $bID = intval(xtc_db_input($_POST['branch']));
        $error = false;
        // CHECK START
        if($bID != ''){
            if($oID > 0){
                $order = new order($oID);
                $item_key = 'opID';
            }else{
                $order = new reclamation($rID);
                $item_key = 'rpID';
            }
            if($bID > 0){ // filialen
                for($i=0;$i<sizeOf($order->products);$i++){
                    // BOF - TEILLIEFERUNG WARENAUSGABE
                    if(!isset($_REQUEST['qty'][ $order->products[$i][$item_key] ]) or $_REQUEST['qty'][ $order->products[$i][$item_key] ] == 0){
                        continue;
                    }
                    $request_qty = (int)xtc_db_input($_REQUEST['qty'][ $order->products[$i][$item_key] ]);
                    // EOF - TEILLIEFERUNG WARENAUSGABE
                    $collies = xtc_get_product_collies($order->products[$i]['id']);

                    if(sizeOf($collies)>0){
                        if(!isset($_POST['move_sn']) and $_POST['move_sn'] != '1'){
                            foreach($collies as $k=>$collie){
                                $branch_query = xtc_db_query("SELECT bp.products_quantity as qty,branches_products_id FROM branches_products bp WHERE bp.products_id='".$collie['collie_products_id']."' and bp.branches_id='".$bID."'");
                                $branch_num = xtc_db_num_rows($branch_query);
                                while( $branch = xtc_db_fetch_array($branch_query) ){
                                    if($branch['qty'] < ( $request_qty*$collie['quantity'])){
                                        $messageStack->add_session(sprintf(MSG_ERROR_COLLIE_QTY_ERROR,
                                            xtc_get_branch_title($bID),
                                            $branch['qty'],
                                            ( $request_qty*$collie['quantity']),
                                            xtc_get_products_name($collie['collie_products_id']),
                                            $collie['collie_products_id']
                                        ),'error');
                                        $error = true;
                                    }
                                }
                                if($branch_num < 1){
                                    $messageStack->add_session(sprintf(MSG_ERROR_COLLIE_BRANCH_QTY,
                                        xtc_get_branch_title($bID),
                                        xtc_get_products_name($collie['collie_products_id']),
                                        $collie['collie_products_id']
                                    ),'error');
                                    $error = true;
                                }
                            }
                        }else{ // ENDE CHECK OB VORHANDEN
                            foreach($collies as $k=>$collie){
                                $branch_query = xtc_db_query(sprintf(
                                    "SELECT bp.products_quantity as qty,branches_products_id FROM branches_products bp WHERE bp.products_id='%d' and bp.branches_id='%d'",
                                    $collie['collie_products_id'],$bID
                                ));
                                $branch_num = xtc_db_num_rows($branch_query);
                                while( $branch = xtc_db_fetch_array($branch_query) ){
                                    if($branch['qty'] < ( $request_qty *$collie['quantity'] ) ){
                                        $messageStack->add_session(sprintf(MSG_ERROR_COLLIE_QTY_ERROR,
                                            xtc_get_branch_title($bID),
                                            $branch['qty'],
                                            ( $request_qty *$collie['quantity']),
                                            xtc_get_products_name($collie['collie_products_id']),
                                            $collie['collie_products_id']
                                        ),'error');
                                        $error = true;
                                    }
                                }
                                if($branch_num < 1){
                                    $messageStack->add_session(sprintf(MSG_ERROR_COLLIE_BRANCH_QTY,
                                        xtc_get_branch_title($bID),
                                        xtc_get_products_name($collie['collie_products_id']),
                                        $collie['collie_products_id']
                                    ),'error');
                                    $error = true;
                                }
                            }
                        }
                    }else{ // PRUEFE OB BESTAND VORHANDEN IN FILIALE - SINGLE PRODUCT
                        // PRUEFE OB ALLE SN IN FILIALE VORHANDEN SIND
                        if(!$_POST['move_sn'] and $_POST['move_sn'] != '1'){
                        }else{ // ENDE CHECK OB VORHANDEN
                            $branch_query = xtc_db_query(sprintf(
                                "SELECT bp.products_quantity as qty,branches_products_id FROM branches_products bp WHERE bp.products_id='%d' and bp.branches_id='%d'",
                                $order->products[$i]['id'],$bID
                            ));
                            $branch_num = xtc_db_num_rows($branch_query);
                            while( $branch = xtc_db_fetch_array($branch_query) ){
                                if($branch['qty'] < $request_qty) {
                                    $messageStack->add_session(sprintf(MSG_ERROR_QTY_ERROR,
                                        xtc_get_branch_title($bID),
                                        $branch['qty'],
                                        $request_qty,
                                        xtc_get_products_name($order->products[$i]['id']),
                                        $order->products[$i]['id']
                                    ) ,'error');
                                    $error = true;
                                }
                            }
                            if($branch_num < 1){
                                $messageStack->add_session(sprintf(MSG_ERROR_BRANCH_QTY,
                                        xtc_get_branch_title($bID),
                                        xtc_get_products_name($order->products[$i]['id']),
                                        $order->products[$i]['id']
                                    ) ,'error');
                                $error = true;
                            }
                        }
                    }
                }
            } // end if bid>0
        }else{
            $error = true;
            $messageStack->add_session(MSG_ERROR_NO_BRANCH_SELECTED,'error');
        }
        // CHECK END
        //
        // BUCHEN
        if(!$error){
                if($bID > 0){ // nur filialen
                        for($i=0;$i<sizeOf($order->products);$i++){
                                // BOF - TEILLIEFERUNG WARENAUSGABE
                                if(!isset($_REQUEST['qty'][ $order->products[$i][$item_key] ]) or $_REQUEST['qty'][ $order->products[$i][$item_key] ] == 0){
                                    continue;
                                }
                                $request_qty = (int)xtc_db_input($_REQUEST['qty'][ $order->products[$i][$item_key] ]);
                                // EOF - TEILLIEFERUNG WARENAUSGABE
                                $collies = xtc_get_product_collies($order->products[$i]['id']);

                                if(sizeOf($collies)>0){

                                    // TICKET 1679 - bei rekla typ 4
                                    if($allow_buchen){
                                        if(!isset($_POST['move_sn']) and $_POST['move_sn'] != '1'){
                                                foreach($collies as $k=>$collie){
                                                        $branch_query = xtc_db_query("SELECT branches_products_id FROM branches_products bp WHERE bp.products_id='".$collie['collie_products_id']."' and bp.branches_id='".$bID."'");
                                                        $branch = xtc_db_fetch_array($branch_query);

                                                        $SQ = new products_quantity($collie['collie_products_id']);
                                                        $qty_total = $SQ->get_products_total_qty();
                                                        $new_qty = $collie['quantity']* $request_qty;
                                                        // HAUPTLAGER ZUBUCHEN
                                                        if($oID){
                                                                $comments = sprintf(HISTORY_QTY_OTC,$order->info['id'],xtc_get_branch_title($bID));
                                                        }else{
                                                                $comments = sprintf(HISTORY_QTY_OTC_RECLAMATION,$order->info['id'],xtc_get_branch_title($bID));
                                                        }
                                                        //$SQ->update_qty( $new_qty,$SQ->get_default_storage_id(),$qty_total,$comments);

                                                        // FILIALE ABBUCHEN
                                                        xtc_db_query("UPDATE branches_products SET products_quantity=products_quantity-'".$new_qty."' WHERE branches_products_id='".$branch['branches_products_id']."'");

                                                        // KOMMENTAR FILIALE
                                                        if($oID){
                                                                $comments = sprintf(HISTORY_BRANCH_OTC,
                                                                        $order->info['id'],
                                                                        $new_qty,
                                                                        xtc_db_input(xtc_get_products_name($collie['collie_products_id'])),
                                                                        $collie['collie_products_id']
                                                                );
                                                        }else{
                                                                $comments = sprintf(HISTORY_BRANCH_OTC_RECLAMATION,
                                                                        $order->info['id'],
                                                                        $new_qty,
                                                                        xtc_db_input(xtc_get_products_name($collie['collie_products_id'])),
                                                                        $collie['collie_products_id']
                                                                );
                                                        }
                                                        $sql_insert_array = array('branches_id'=>$bID,
                                                                'date_created'=>"now()",
                                                                'comments'=>$comments,
                                                                'editor_id'=>$_SESSION['customer_id']
                                                        );
                                                        xtc_db_perform('branches_history',$sql_insert_array);
                                                } // end foreach collis

                                        }else{
                                                foreach($collies as $k=>$collie){
                                                        $branch_query = xtc_db_query("SELECT branches_products_id FROM branches_products bp WHERE bp.products_id='".$collie['collie_products_id']."' and bp.branches_id='".$bID."'");
                                                        $branch = xtc_db_fetch_array($branch_query);


                                                        $SQ = new products_quantity($collie['collie_products_id']);
                                                        $qty_total = $SQ->get_products_total_qty();
                                                        $new_qty = $collie['quantity']*$request_qty;

                                                        // HAUPTLAGER ZUBUCHEN
                                                        if($oID){
                                                                $comments = sprintf(HISTORY_QTY_OTC,
                                                                        $order->info['id'],
                                                                        xtc_get_branch_title($bID)
                                                                );
                                                        }else{
                                                                $comments = sprintf(HISTORY_QTY_OTC_RECLAMATION,
                                                                        $order->info['id'],
                                                                        xtc_get_branch_title($bID)
                                                                );
                                                        }
                                                        //$SQ->update_qty( $new_qty,$SQ->get_default_storage_id(),$qty_total,$comments);

                                                        // FILIALE ABBUCHEN
                                                        xtc_db_query("UPDATE branches_products SET products_quantity=products_quantity-'".$new_qty."' WHERE branches_products_id='".$branch['branches_products_id']."'");

                                                        // KOMMENTAR FILIALE
                                                        if($oID){
                                                                $comments = sprintf(HISTORY_BRANCH_OTC,
                                                                        $order->info['id'],
                                                                        $new_qty,
                                                                        xtc_get_products_name($collie['collie_products_id']),
                                                                        $collie['collie_products_id']
                                                                );
                                                        }else{
                                                                $comments = sprintf(HISTORY_BRANCH_OTC_RECLAMATION,
                                                                        $order->info['id'],
                                                                        $new_qty,
                                                                        xtc_get_products_name($collie['collie_products_id']),
                                                                        $collie['collie_products_id']
                                                                );
                                                        }
                                                        $sql_insert_array = array('branches_id'=>$bID,
                                                                'date_created'=>"now()",
                                                                'comments'=>$comments,
                                                                'editor_id'=>$_SESSION['customer_id']
                                                        );
                                                        xtc_db_perform('branches_history',$sql_insert_array);
                                                } // end foreach collis

                                        } // end if move sn
                                    } // end if allow_buchen
                                    // BOF TEILLIEFERUNG
                                    if($oID){
                                            $order->add_quantity_shipped($order->products[$i]['opID'], $request_qty );
                                    }
                                    // EOF TEILLIEFERUNG

                                }else{ // SINGLE
                                    // TICKET 1679 - bei rekla typ 4
                                    if($allow_buchen){
                                        if(!isset($_POST['move_sn']) and $_POST['move_sn'] != '1'){

                                                        $branch_query = xtc_db_query("SELECT branches_products_id FROM branches_products bp WHERE bp.products_id='".$order->products[$i]['id']."' and bp.branches_id='".$bID."'");
                                                        $branch = xtc_db_fetch_array($branch_query);

                                                        $SQ = new products_quantity($order->products[$i]['id']);
                                                        $qty_total = $SQ->get_products_total_qty();
                                                        $new_qty = $request_qty;

                                                        // HAUPTLAGER ZUBUCHEN
                                                        if($oID){
                                                                $comments = sprintf(HISTORY_QTY_OTC,
                                                                        $order->info['id'],
                                                                        xtc_get_branch_title($bID)
                                                                );
                                                        }else{
                                                                $comments = sprintf(HISTORY_QTY_OTC_RECLAMATION,
                                                                        $order->info['id'],
                                                                        xtc_get_branch_title($bID)
                                                                );
                                                        }
                                                        //$SQ->update_qty( $new_qty,$SQ->get_default_storage_id(),$qty_total,$comments);

                                                        // FILIALE ABBUCHEN
                                                        xtc_db_query("UPDATE branches_products SET products_quantity=products_quantity-'".$new_qty."' WHERE branches_products_id='".$branch['branches_products_id']."'");

                                                        // KOMMENTAR FILIALE
                                                        if($oID){
                                                                $comments = sprintf(HISTORY_BRANCH_OTC,
                                                                        $order->info['id'],
                                                                        $new_qty,
                                                                        xtc_get_products_name($order->products[$i]['id']),
                                                                        $order->products[$i]['id']
                                                                );
                                                        }else{
                                                                $comments = sprintf(HISTORY_BRANCH_OTC_RECLAMATION,
                                                                        $order->info['id'],
                                                                        $new_qty,
                                                                        xtc_get_products_name($order->products[$i]['id']),
                                                                        $order->products[$i]['id']
                                                                );
                                                        }
                                                        $sql_insert_array = array('branches_id'=>$bID,
                                                                'date_created'=>"now()",
                                                                'comments'=>$comments,
                                                                'editor_id'=>$_SESSION['customer_id']
                                                        );
                                                        xtc_db_perform('branches_history',$sql_insert_array);

                                                        // BOF TEILLIEFERUNG
                                                        if($oID){
                                                                $order->add_quantity_shipped($order->products[$i]['opID'], ($order->products[$i]['qty']-$order->products[$i]['quantity_shipped']));
                                                        }
                                                        // EOF TEILLIEFERUNG

                                        }else{
                                                        $branch_query = xtc_db_query("SELECT branches_products_id FROM branches_products bp WHERE bp.products_id='".$order->products[$i]['id']."' and bp.branches_id='".$bID."'");
                                                        $branch = xtc_db_fetch_array($branch_query);

                                                        $SQ = new products_quantity($order->products[$i]['id']);
                                                        $qty_total = $SQ->get_products_total_qty();
                                                        $new_qty = $request_qty;

                                                        // HAUPTLAGER ZUBUCHEN
                                                        if($oID){
                                                                $comments = sprintf(HISTORY_BRANCH_OTC,
                                                                        $order->info['id'],
                                                                        xtc_get_branch_title($bID)
                                                                );
                                                        }else{
                                                                $comments = sprintf(HISTORY_BRANCH_OTC_RECLAMATION,
                                                                        $order->info['id'],
                                                                        xtc_get_branch_title($bID)
                                                                );
                                                        }
                                                        //$SQ->update_qty( $new_qty,$SQ->get_default_storage_id(),$qty_total,$comments);

                                                        // FILIALE ABBUCHEN
                                                        xtc_db_query("UPDATE branches_products SET products_quantity=products_quantity-'".$new_qty."' WHERE branches_products_id='".$branch['branches_products_id']."'");

                                                        // KOMMENTAR FILIALE
                                                        if($oID){
                                                                $comments = sprintf(HISTORY_BRANCH_OTC,
                                                                        $order->info['id'],
                                                                        $new_qty,
                                                                        xtc_get_products_name($order->products[$i]['id']),
                                                                        $order->products[$i]['id']
                                                                );
                                                        }else{
                                                                $comments = sprintf(HISTORY_BRANCH_OTC_RECLAMATION,
                                                                        $order->info['id'],
                                                                        $new_qty,
                                                                        xtc_get_products_name($order->products[$i]['id']),
                                                                        $order->products[$i]['id']
                                                                );
                                                        }
                                                        $sql_insert_array = array('branches_id'=>$bID,
                                                                'date_created'=>"now()",
                                                                'comments'=>$comments,
                                                                'editor_id'=>$_SESSION['customer_id']
                                                        );
                                                        xtc_db_perform('branches_history',$sql_insert_array);
                                        } // eof move sn
                                    } // eof allow_buchen
                                    // BOF TEILLIEFERUNG
                                    if($oID){
                                            $order->add_quantity_shipped($order->products[$i]['opID'], $request_qty );
                                    }
                                    // EOF TEILLIEFERUNG
                                } // end if single
                        } // end for products
                }else{ // ende if bid > 0
                    if($allow_buchen){
                        for($i=0;$i<sizeOf($order->products);$i++){
                                // BOF - TEILLIEFERUNG WARENAUSGABE
                                if(!isset($_REQUEST['qty'][ $order->products[$i][$item_key] ]) or $_REQUEST['qty'][ $order->products[$i][$item_key] ] == 0){
                                    continue;
                                }
                                $request_qty = (int)xtc_db_input($_REQUEST['qty'][ $order->products[$i][$item_key] ]);
                                // EOF - TEILLIEFERUNG WARENAUSGABE

                                $collies = xtc_get_product_collies($order->products[$i]['id']);

                                if(sizeOf($collies)>0){
                                        if($oID){
                                                $comments = sprintf(HISTORY_QTY_MAINSTORAGE,$order->info['id']);
                                        }else{
                                                $comments = sprintf(HISTORY_QTY_MAINSTORAGE_RECLAMATION,$order->info['id']);
                                        }
                                        foreach($collies as $collie){
                                                $SQ = new products_quantity($collie['collie_products_id']);
                                                $qty_total = $SQ->get_products_total_qty();
                                                $new_qty = $collie['quantity']* $request_qty;
                                                $SQ->update_qty( -$new_qty,$SQ->get_default_storage_id(),$qty_total,$comments,
                                                        (($oID)?'order':'reklamation'),$order->info['id'],'Warenausgabe'
                                                );
                                        }
                                        yes_add_products_history($order->products[$i]['id'], $comments);
                                }else{
                                        $SQ = new products_quantity($order->products[$i]['id']);
                                        $qty_total = $SQ->get_products_total_qty();

                                        // HAUPTLAGER ZUBUCHEN
                                        $comments = sprintf(HISTORY_QTY_MAINSTORAGE,$order->info['id']);
                                        $SQ->update_qty( -$request_qty,$SQ->get_default_storage_id(),$qty_total,$comments,
                                                (($oID)?'order':'reklamation'),$order->info['id'],'Warenausgabe'
                                        );
                                }
                                // BOF TEILLIEFERUNG
                                if($oID){
                                        $order->add_quantity_shipped($order->products[$i]['opID'],$request_qty );
                                }
                                // EOF TEILLIEFERUNG
                        } // end for products
                    } // eof allow_buchen
                }

                // RE AUF VERSENDET
                if($bID > 0){
                        $comments = sprintf(HISTORY_OTC_FROM_BRANCH,xtc_get_branch_title($bID));
                }else{
                        $comments = HISTORY_OTC_FROM_MAINSTORAGE;
                }
                if($oID > 0){
                    $part_delivery_products = array();
                        for($i=0;$i<sizeOf($order->products);$i++){
                                // BOF - TEILLIEFERUNG WARENAUSGABE
                                if(!isset($_REQUEST['qty'][ $order->products[$i][$item_key] ]) or $_REQUEST['qty'][ $order->products[$i][$item_key] ] == 0){
                                    continue;
                                }
                                $request_qty = (int)xtc_db_input($_REQUEST['qty'][ $order->products[$i][$item_key] ]);
                                $part_delivery_products[] = array('qty'=>$request_qty,'products_id'=>$order->products[$i]['id'],'title'=>$order->products[$i]['name']);

                                $update_sql_array = array(
                                    'quantity_shipped'=> $order->products[$i]['quantity_shipped']+$request_qty
                                );
                                xtc_db_perform(TABLE_ORDERS_PRODUCTS,$update_sql_array,'update',"orders_products_id='".$order->products[$i]['opID']."'");

                                if(defined('EBAY_END_AUCTION_AT_SHOPORDER') and EBAY_END_AUCTION_AT_SHOPORDER == 'True'){
                                        yes_end_auction_add($order->products[$i]['id'], $request_qty );
                                }
                        }
                        $all_processed = true;
                        $check_all_products_shipped_query = xtc_db_query(sprintf(
                                "SELECT products_quantity-quantity_shipped as anz FROM orders_products WHERE orders_id='%s'",
                                $order->info['id']
                        ));
                        while($check_all_products_shipped = xtc_db_fetch_array($check_all_products_shipped_query)){
                            if($check_all_products_shipped['anz'] > 0){
                                $all_processed = false;
                            }
                        }
                        if($all_processed){
                            if( xtc_is_shipping_before_payment($order->info['payment_method']) ){
                                    if($order->info['orders_status'] == ORDERS_STATUS_BEZAHLT){
                                            $fibu_history_status = ORDERS_STATUS_ABGESCHLOSSEN;
                                            xtc_db_query("UPDATE orders SET orders_status='".ORDERS_STATUS_ABGESCHLOSSEN."',date_shipping=now(),last_modified=now() WHERE orders_id='".$order->info['id']."'");
                                            // KOMMENTAR RE
                                            $order->add_history(ORDERS_STATUS_ABGESCHLOSSEN, false, $comments);
                                    }else{
                                            $fibu_history_status = ORDERS_STATUS_VERSENDET;
                                            xtc_db_query("UPDATE orders SET orders_status='".ORDERS_STATUS_VERSENDET."',date_shipping=now(),last_modified=now() WHERE orders_id='".$order->info['id']."'");
                                            // KOMMENTAR RE
                                            $order->add_history(ORDERS_STATUS_VERSENDET, false, $comments);
                                    }
                            }else{
                                    $fibu_history_status = ORDERS_STATUS_ABGESCHLOSSEN;
                                    xtc_db_query("UPDATE orders SET orders_status='".ORDERS_STATUS_ABGESCHLOSSEN."',date_shipping=now(),last_modified=now() WHERE orders_id='".$order->info['id']."'");
                                    // KOMMENTAR RE
                                    $order->add_history(ORDERS_STATUS_ABGESCHLOSSEN, false, $comments);
                            }
                        }else{
                            $part_delivery_str_array = array('Teillieferung Warenausgabe');
                            foreach($part_delivery_products as $pdp){
                                $part_delivery_str_array[] = $pdp['qty'].'x '.$pdp['title'].' (pID '.$pdp['products_id'].')';
                            }
                            $order->add_history($order->info['orders_status'],false,implode('<br />',$part_delivery_str_array));
                        }
                }else{
                        $all_processed = true;
                        // BOF - REKLA STATUS
                        $recla_abgeschlossen = true;
                        switch($order->info['reclamations_type']){
                            case 3:
                            case 4:
                                foreach($order->rueckerstattungen as $rueck){
                                    if( in_array($rueck['status'],array(1,4))){
                                        $recla_abgeschlossen = false;
                                    }
                                }
                                if($recla_abgeschlossen){
                                    $ret_query = xtc_db_query(sprintf(
                                            "SELECT retoure_id FROM retouren WHERE reclamations_id='%s' AND retoure_status IN(%s)",
                                            $rID,implode(',',array(1,2))
                                    ));
                                    if(xtc_db_num_rows($ret_query))
                                        $recla_abgeschlossen = false;
                                }
                                break;
                        }

                        // EOF - REKLA STATUS


                        if($all_processed){
                            if($recla_abgeschlossen){
                                xtc_db_query("UPDATE reclamations SET reclamations_status=3,last_modified=now() WHERE reclamations_id='".$rID."'");
                                $R->add_history(3, false, $comments);
                            }else{
                                $R->add_history($order->info['reclamations_status'], false, $comments);
                            }
                            // KOMMENTAR RE
                            $recla_order_query = xtc_db_query(sprintf(
                                    "SELECT orders_status FROM orders WHERE orders_id=%s",
                                            $order->info['id']
                            ));
                            $recla_order = xtc_db_fetch_array($recla_order_query);
                            $insert_sql_array = array(
                                    'orders_id'=>$order->info['id'],
                                    'orders_status_id'=>$recla_order['orders_status'],
                                    'date_added'=>'now()',
                                    'customer_notified'=>0,
                                    'comments'=>'Rekla-Nr: '.$rID.' / '.$comments,
                                    'editor_id'=>$_SESSION['customer_id']
                            );
                            xtc_db_perform('orders_status_history', $insert_sql_array);
                        }
                }

                // FIBUNUMBER ADDON
                if($all_processed && $oID and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
                        if( strlen($order->get_fibunumber(true)) < 2 
                                &&	MODULE_OTHER_FIBUNUMBERS_AUTOMATIC == 'True'){
                                $fibu_number = $order->add_fibunumber();
                                $order->add_history($fibu_history_status,false,sprintf(HISTORY_FIBUNUMBER_AUTOMATIC_ADD,$fibu_number));
                        }
                }
                if(!$all_processed){
                    $status = ($oID) ? $order->info['orders_status'] : $order->info['reclamations_status'];
                        $order->add_history($status,false,MSG_SUCCESS_OTC_PART_DELIVERY);
                }
                // RE IN OTC TABELLE
                if($oID){
                    $customer = new customer($order->customer['ID']);
                    $customer->update_current_account_value();
                        xtc_db_query("INSERT INTO otc SET orders_id=".$order->info['id'].",branches_id='".$bID."', date_saved=now(), editor_id='".$_SESSION['customer_id']."'");
                        $messageStack->add_session(MSG_SUCCESS_OTC ,'success');
                        xtc_redirect(xtc_href_link('orders.php', 'action=edit&oID='.$order->info['id']));
                }else{
                        xtc_db_query("INSERT INTO otc SET reclamations_id=".$order->info['id'].",branches_id='".$bID."', date_saved=now(), editor_id='".$_SESSION['customer_id']."'");
                        $messageStack->add_session(MSG_SUCCESS_OTC_RECLAMATION ,'success');
                        xtc_redirect(xtc_href_link('reclamations.php', 'action=edit&rID='.$order->info['id']));
                }
        }// END BUCHEN
    xtc_redirect(xtc_href_link('otc.php', xtc_get_all_get_params(array('bID','action')).'bID='.$_POST['branch']));
break;
}

if( xtc_not_null($_GET['oID']) ){
	$oID = (int)xtc_db_input($_GET['oID']);

	// DARF NICHT IM VERSANDMODUL ZUR ABWICKLUNG BEREIT LIEGEN
	$shippings_query = xtc_db_query(sprintf(
		"SELECT id FROM shippings WHERE orders_id='%s' and reclamations_id < 1 AND status=0",
		$oID
	));
	if(xtc_db_num_rows($shippings_query)){
	    $messageStack->add_session(MSG_ERROR_ORDER_IN_SHIPPINGS,'error');
	    xtc_redirect(xtc_href_link(FILENAME_ORDERS,'action=edit&oID='.$oID));
	}
}
if( xtc_not_null($_GET['rID']) ){
	$rID = (int)xtc_db_input($_GET['rID']);
	// DARF NICHT IM VERSANDMODUL ZUR ABWICKLUNG BEREIT LIEGEN
	$shippings_query = xtc_db_query(sprintf(
		"SELECT id FROM shippings WHERE reclamations_id='%s' AND status=0",
		$rID
	));
	if(xtc_db_num_rows($shippings_query)){
	    $messageStack->add_session(MSG_ERROR_RECLAMATION_IN_SHIPPINGS,'error');
	    xtc_redirect(xtc_href_link(FILENAME_RECLAMATIONS,'action=edit&rID='.$rID));
	}
}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<?php
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$smarty->assign('HEADING_TITLE',HEADING_TITLE);
$buttons = array();
if($oID > 0){
    $buttons[] = array('text'=>LINK_BACK_TO_ORDER,
        'link'=>xtc_href_link('orders.php','action=edit&oID='.$oID),
        'lbOn'=>false,
        'auth'=>true
    );
}elseif($rID > 0){
    $buttons[] = array('text'=>LINK_BACK_TO_RECLAMATION,
        'link'=>xtc_href_link('reclamations.php','action=edit&rID='.$rID),
        'lbOn'=>false,
        'auth'=>true
    );
}
$smarty->assign([
    'SEARCH_FORM'=>xtc_draw_form('otc_o','otc.php','','GET','class="otc_form"'),
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'SEARCH_FORM_RECLAMATIONS'=>xtc_draw_form('otc_r','otc.php','','GET','class="otc_form"'),
    'FORM_END'=>'</form>',
    'TEXT_INPUT_ORDERS_ID'=>TEXT_INPUT_ORDERS_ID,
    'TEXT_INPUT_RECLAMATIONS_ID'=>TEXT_INPUT_RECLAMATIONS_ID,
    'INPUT_ORDERS_ID'=>$oID,
    'INPUT_RECLAMATIONS_ID'=>$rID,
    'TEXT_OTC'=>BUTTON_OTC,
]);

if( $rID > 0 or $oID > 0 ){
    $bID = intval(xtc_db_input($_GET['bID'] ?? ''));
    $smarty->assign(array(
        'TEXT_CUSTOMER_DATA'=>TEXT_CUSTOMER_DATA,
        'TEXT_DELIVERY_DATA'=>TEXT_DELIVERY_DATA,
        'TEXT_BILLING_DATA'=>TEXT_BILLING_DATA,
        'TEXT_ERROR'=>TEXT_ERROR,
        'SEPARATOR'=>xtc_draw_separator('pixel_black.gif'),
        'TEXT_CHANGE'=>TEXT_SWITCH,
        'TEXT_PROCESS_NOT_ALLOWED'=>TEXT_PROCESS_NOT_ALLOWED,
        'TEXT_OTC_FROM'=>TEXT_OTC_FROM,
        'TEXT_MAINSTORAGE'=>TEXT_MAINSTORAGE,
        'BUTTON_OTC'=>BUTTON_OTC,
        'TEXT_OTC_PROCESS_INTRO'=>TEXT_OTC_PROCESS_INTRO,
        'TEXT_OTC_PROCESS_RECLAMATION_INTRO'=>TEXT_OTC_PROCESS_RECLAMATION_INTRO,
        'BID'=>($bID>0)?$bID:''
    ));
}

if( $oID > 0 ){
    $O = new order($oID);
    $ebay_trans_status_check = array();
    foreach($O->get_auction_array() as $ebay_id){
        $query = xtc_db_query(sprintf(
            "SELECT transactionid FROM ebay_transactions WHERE ebayid='%s' AND orders_id='%d'",
            $ebay_id, $oID
        ));
        while($record = xtc_db_fetch_array($query)){
            $ebay_trans_status_check[] = array(
                'ebay_id'=>$ebay_id,
                'transaction_id'=>$record['transactionid']
            );
        }
    }
    if(sizeOf($ebay_trans_status_check)){
        $trans_status = array();
        foreach($ebay_trans_status_check as $tr){
            $trans_status[] = $EBAYAPI->get_item_transaction_status($tr['ebay_id'],$tr['transaction_id']);
        }
        $smarty->assign('EBAY_TRANSACTION_STATUSES',$trans_status);
    }
    $xtPrice = new xtcPrice($O->info['currency'],$O->info['status']);

    $smarty->assign('INPUT_ID',xtc_draw_hidden_field('orders_id[]',$oID));
    $smarty->assign('CUSTOMER_ADDRESS',xtc_address_format($O->customer['format_id'], $O->customer, 1, '', '<br />'));
    $smarty->assign('DELIVERY_ADDRESS',xtc_address_format($O->delivery['format_id'], $O->delivery, 1, '', '<br />'));
    $smarty->assign('BILLING_ADDRESS',xtc_address_format($O->billing['format_id'], $O->billing, 1, '', '<br />'));
    $smarty->assign('OID',$O->info['id']);
    $smarty->assign('EBAY_ID',$O->info['ebay_id']);

    $smarty->assign('FORM',xtc_draw_form('wa','otc.php',xtc_get_all_get_params(array('action')).'&action=save'));
    $smarty->assign('PRODUCTS',$O->products);


    foreach($O->products as $k=>$prod){
        $O->products[$k]['final_price_formated'] = $xtPrice->xtcFormat($prod['final_price'],true);

        $collies = xtc_get_product_collies($prod['id']);
        $O->products[$k]['collies'] = $collies;
        $O->products[$k]['collies_rowspan'] = (sizeOf($collies)+1);
        $default_qty = $O->products[$k]['qty']-$O->products[$k]['quantity_shipped']-$O->products[$k]['not_ship'];
        $qty_values = array();
        for($dq=0;$dq<=$default_qty;$dq++){
            $qty_values[] = array(
                'id'=>$dq,
                'text'=>$dq
            );
        }
        if(sizeOf($qty_values) == 1){
            $O->products[$k]['qty_input_str'] = '0';
        }else{
            $O->products[$k]['qty_input_str'] = xtc_draw_pull_down_menu('qty['.$O->products[$k]['opID'].']',$qty_values,$default_qty);
        }
    }
    $smarty->assign('PRODUCTS',$O->products);
    $totals = array();
    $gesamt = 0;
    foreach($O->totals as $k=>$total){
        if($total['class'] == 'ot_total'){
                $gesamt += $total['value'];
        }
        $totals[] = array('title'=>$total['title'],'text'=>$total['text']);
    }
    $smarty->assign('TOTALS',$totals);
    $smarty->assign('FINAL_SUM',$gesamt);

    $process_allow = true;
    if($O->info['orders_status'] != ORDERS_STATUS_BEZAHLT ) {
        if(!xtc_is_shipping_before_payment($O->info['payment_method']) and ($O->info['orders_status'] == 1 or $O->info['orders_status'] == 2 or $O->info['orders_status'] == ORDERS_STATUS_UPSELLING ) ){
            $process_allow = false;
        }
    }
    $smarty->assign('PROCESS_ALLOW',$process_allow);
    if($process_allow){
        if(!$bID or $bID < 1){
            $branches = array();
            $allocated_branches = yes_get_customer_branches($_SESSION['customer_id']);
            for($ib=0;$ib<sizeOf($allocated_branches);$ib++){
                    $branches[] = array('branches_id'=>$allocated_branches[$ib],'title'=>xtc_get_branch_title($allocated_branches[$ib]));
            }
            $smarty->assign('BRANCHES_ARRAY',$branches);
            if(main::get_admin_access('f_branches_mainstorage')){
                $smarty->assign('ALLOW_MAINSTORAGE',true);
            }
        }else{
            $smarty->assign('BRANCH_TITLE',xtc_get_branch_title($bID));
        }
        $smarty->assign('INPUT_BRANCHES_ID',xtc_draw_radio_field('branch','0',((!$bID or $bID == 0)?true:false) ));
    }
}else if( $rID > 0 ){
    $R = new reclamation($rID);

    $smarty->assign('INPUT_ID',xtc_draw_hidden_field('reclamations_id[]',$rID));
    $smarty->assign('CUSTOMER_ADDRESS',xtc_address_format($R->customer['format_id'], $R->customer, 1, '', '<br />'));
    $smarty->assign('DELIVERY_ADDRESS',xtc_address_format($R->delivery['format_id'], $R->delivery, 1, '', '<br />'));
    $smarty->assign('BILLING_ADDRESS',xtc_address_format($R->billing['format_id'], $R->billing, 1, '', '<br />'));
    $smarty->assign('RID',$R->info['id']);
    $smarty->assign('EBAY_ID',$R->info['ebay_id']);

    $smarty->assign('FORM',xtc_draw_form('wa','otc.php',xtc_get_all_get_params(array('action')).'&action=save'));
    $smarty->assign('PRODUCTS',$O->products);


    foreach($R->products as $k=>$prod){
            $R->products[$k]['final_price_formated'] = number_format($prod['final_price'],2,',','.');
            $collies = xtc_get_product_collies($prod['id']);
            $R->products[$k]['collies'] = $collies;
            $R->products[$k]['collies_rowspan'] = (sizeOf($collies)+1);
            $default_qty = $R->products[$k]['qty'];
            $qty_values = array();
            for($dq=0;$dq<=$default_qty;$dq++){
                $qty_values[] = array(
                    'id'=>$dq,
                    'text'=>$dq
                );
            }
            $R->products[$k]['qty_input_str'] = xtc_draw_pull_down_menu('qty['.$R->products[$k]['rpID'].']',$qty_values,$default_qty);
    }
    $gesamt = 0;
    $smarty->assign('PRODUCTS',$R->products);
    $totals = array();
    foreach($R->totals as $k=>$total){
            if($total['class'] == 'ot_total'){
                    $gesamt += $total['value'];
            }
            $totals[] = array('title'=>$total['title'],'text'=>$total['text']);
    }
    $smarty->assign('TOTALS',$totals);
    $smarty->assign('FINAL_SUM',$gesamt);

    $process_allow = true;
    if($R->info['reclamations_status'] != 2 ) {
            $process_allow = false;
    }
    $smarty->assign('PROCESS_ALLOW',$process_allow);
    if($process_allow){
        if(!$bID or $bID < 1){
            $branches = array();
            $allocated_branches = yes_get_customer_branches($_SESSION['customer_id']);
            for($ib=0;$ib<sizeOf($allocated_branches);$ib++){
                $branches[] = array('branches_id'=>$allocated_branches[$ib],'title'=>xtc_get_branch_title($allocated_branches[$ib]));
            }
            $smarty->assign('BRANCHES_ARRAY',$branches);
            if(main::get_admin_access('f_branches_mainstorage')){
                $smarty->assign('ALLOW_MAINSTORAGE',true);
            }
        }else{
            $smarty->assign('BRANCH_TITLE',xtc_get_branch_title($bID));
        }
        $smarty->assign('INPUT_BRANCHES_ID',xtc_draw_radio_field('branch','0',((!$bID or $bID == 0)?true:false) ));
    }
}
$smarty->display('otc.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');