<?php
/*------------------------------------------------------------------------------

   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *

                                              Author M. ASPELEITER <dazze@gmx.de>
                                              Copyright (c) 2004 mario aspeleiter

   ---------------------------------------------------------------------------*/
include('includes/application_top.php');
include('admin/includes/classes/class.ebay.php');
include('includes/classes/class.textitems.php');

require(DIR_FS_INC.'xtc_get_ebay_link.inc.php');
require(DIR_FS_INC.'yes_write_notice.inc.php');
require(DIR_FS_INC.'xtc_get_auction_site.inc.php');

$EBAYAPI = new ebayAPI;

define('TABLE_EBAY_FEEDBACK','ebay_feedback');
define('FILENAME_EBAY_FEEDBACK','ebayapi_feedback.php');

if(!defined('EBAY_AUTOMATIC_FEEDBACK') or constant('EBAY_AUTOMATIC_FEEDBACK') != 'true'){
	die('EBAY_AUTOMATIC_FEEDBACK ist deaktiviert.');
}
// CHECK OB GENUG POSITIVE BEWERTUNGEN HINTERLEGT
$feedback_array = array();
$feedbacks_query = xtc_db_query("SELECT text FROM ebay_textitems WHERE module='feedback' and value='positive'");
while($feedbacks = xtc_db_fetch_array( $feedbacks_query ) ){
	$feedback_array[] = xtc_db_prepare_input($feedbacks['text']);
}

$recs = main::get_notice_recipients('ebayapi_feedback');

if(sizeOf($feedback_array) < 6){
	yes_write_notice('Automatisches Bewertungssystem Fehler','Es wurde automatisches Mahnwesen aktiviert aber es sind nur '.sizeOf($feedback_array).'/6 Textbausteine fuer positive Bewertungen hinterlegt.',0,$recs);
	exit;
}

/**
 * Mit diesem Query werden alle Bewertungen ausgelesen die von Kaeufern
 * abgegeben wurden. Bei diesen wird nun im 2. Schritt geprueft ob wir schon zurueck bewertet
 * haben.
 */
$records = array();
$open_feedbacks_query = xtc_db_query("SELECT * FROM ebay_feedback WHERE status=0 AND FeedbackRole='Seller' and CommentType='Positive' ORDER BY ebay_user");
$current_ebay_user = '';
while($row = xtc_db_fetch_array($open_feedbacks_query)){
	$records[] = $row;
}
if(!sizeOf($records)){
	die('Nothing to do.');
}
foreach($records as $open_feedback){
	/**
	 * haben wir schon bewertet?
	 * Bei FeedbackRole = 'Buyer' hat der Seller den Buyer bewertet
	 */
	$check_query = xtc_db_query(sprintf(
		"SELECT id FROM ebay_feedback WHERE FeedbackRole='Buyer' and ItemNumber='%s' and TransactionId='%s'",
		$open_feedback['ItemNumber'],$open_feedback['TransactionId']
	));
	if(xtc_db_num_rows($check_query)){
		continue;
	}

	if(ebayApi::oauth2_refreshtoken_exists($open_feedback['ebay_user'])){
		if(!ebayApi::oauth2_usertoken_exists($open_feedback['ebay_user']) or ebayApi::get_oauth2_usertoken_lifetime($open_feedback['ebay_user']) < 1){
			try{
				ebayApi::refresh_oauth2_usertoken($open_feedback['ebay_user']);
			}catch(Exception $e){
				$api_error = 'refresh_oauth2_usertoken() for seller '.$open_feedback['ebay_user'].'  '.$e->getMessage();
			}
		}
	}
	$ebaycalls = new \YES4Trade\Model\ebaycalls();
	$comment_text = $feedback_array[ array_rand($feedback_array,1) ];
	$res = $ebaycalls->tradingQuery($open_feedback['ebay_user'],
		'LeaveFeedback',
		$EBAYAPI->get_site_id_from_name(constant('EBAY_SITE')),
		[
			'ItemID' => $open_feedback['ItemNumber'],
			'TargetUser' => $open_feedback['CommentingUser'],
			'TransactionID' => ((xtc_not_null($open_feedback['TransactionId']))?$open_feedback['TransactionId']:'0'),
			'CommentType' => 'Positive',
			'CommentText' => substr($comment_text,0,80)
		]
	);
	if ($EBAYAPI->isGood($res)) {
		//yes_mail_debug(print_r($res,true));
	} else {
        $errstr = implode('<br />',$EBAYAPI->getResponseErrors($res));
		$body = 'Auktion: '.$open_feedback['ItemNumber'].'<br />';
                $body .= 'Transaktion: '.((xtc_not_null($open_feedback['TransactionId']))?$open_feedback['TransactionId']:'0').'<br />';
		$body .= 'K&auml;ufer: '.$open_feedback['CommentingUser'].'<br />';
                $body .= 'Bewertungstext: '.substr($comment_text,0,80).'<br />';
		$body .= 'Bewertung durch K&auml;ufer am: '.$open_feedback['TimeOfComment'].'<br />';
		$body .= 'Bewertungstext des K&auml;ufers: '.$open_feedback['CommentText'].'<br />';
		$body .= 'Ebay-Seller: '.$open_feedback['ebay_user'].'<br />';
		$body .= 'Es gab einen Fehler [CRON] von Ebay, hier die Meldung:<br /><br />';
		$body .= $errstr;
		yes_write_notice('CRON: Automatisches Bewertungssystem - Fehlermeldung',$body,0,$recs);
	}
	xtc_db_query("UPDATE ".TABLE_EBAY_FEEDBACK." SET status=1 WHERE id='".$open_feedback['id']."'");
}
exit;

