<?php
  /*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                              Author M. ASPELEITER <dazze@gmx.de
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

function xtc_get_product_collie_qty($products_id){
    $collies = xtc_get_product_collies($products_id);
    $p = yes_query(
        "SELECT p.products_quantity FROM products p WHERE p.products_id=:products_id",
        [ 'products_id'=>(int)$collies[0]['collie_products_id'] ],
        true
    );
    $qty = (int)$p['products_quantity'];
    $qty_left = $qty%(int)$collies[0]['quantity'];
    if($qty < $collies[0]['quantity']){
        $qty_available = 0;
    }else{
        $qty_available = ($qty-$qty_left)/$collies[0]['quantity'];
    }
    $qty_available_final = $qty_available;

    foreach($collies as $k=>$collie){
        $pc = yes_query(
            "SELECT p.products_quantity FROM products p WHERE p.products_id=:products_id",
            [ 'products_id'=>(int)$collie['collie_products_id'] ],
            true
        );
        $qty = (int)$pc['products_quantity'];
        $qty_left = $qty%(int)$collie['quantity'];
        if($qty < $collie['quantity']){
            $qty_available = 0;
        }else{
            $qty_available = ($qty-$qty_left)/$collie['quantity'];
        }
			
        if($qty_available <= $qty_available_final){
            $qty_available_final = $qty_available;
        }
    }
    return $qty_available_final;
}

function xtc_get_product_collies($products_id){
    $collies = array();
    $collies_query = yes_query(
        "SELECT collie_products_id,quantity FROM products_collies WHERE products_id=:products_id ORDER BY sort_order",
        ['products_id'=>(int)$products_id]
    );
    foreach($collies_query as $collie){
        $collies[] = $collie;
    }
    return $collies;
}
  
function xtc_get_product_in_collies($products_id){
    $in_collies = array();
    $in_collies_query = yes_query(
        "SELECT products_id,quantity FROM products_collies WHERE collie_products_id=:products_id",
        ['products_id'=>(int)$products_id ]
    );
    foreach($in_collies_query as $in_collie){
        $in_collies[] = $in_collie;
    }
    return $in_collies;
}
  
  function xtc_get_ext_products_weight_netto($products_id){
      return xtc_get_ext_products_weight($products_id,true);
  }
  
  function xtc_get_ext_products_weight($products_id,$netto = false){
	$collies = xtc_get_product_collies($products_id);
	$pweight = 0;
	$select_field = ($netto) ? 'products_weight_netto' : 'products_weight';
	if(sizeOf($collies)>0){
		$pweight = 0;
		foreach($collies as $k=>$collie){
		    $weight_query = xtc_db_query(sprintf(
			    "SELECT products_weight_netto,products_weight,packagings_id FROM %s WHERE products_id='%s'",
			    TABLE_PRODUCTS,$collie['collie_products_id']
		    ));
		    $weight_res = xtc_db_fetch_array($weight_query);
		    $packaging_weight = 0;
		    if($weight_res['packagings_id'] > 0){
                $pquery = xtc_db_query(sprintf(
                    "SELECT weight FROM packagings WHERE packagings_id='%s'",
                    $weight_res['packagings_id']
                ));
			    $pres = xtc_db_fetch_array($pquery);
			    $packaging_weight = floatval($pres['weight']);
		    }
		    if($weight_res['products_weight_netto'] > 0){
    			$pweight += floatval($weight_res['products_weight_netto'])*intval($collie['quantity']);
		    }else{
			    $pweight += floatval($weight_res['products_weight'])*intval($collie['quantity']);
		    }
		    if(!$netto){
			    if($packaging_weight > 0){
			        $pweight += (floatval($packaging_weight)*intval($collie['quantity']));
			    }
		    }
		}
	}else{
		$weight_res = yes_query(sprintf(
                    "SELECT products_weight_netto,products_weight,packagings_id FROM %s WHERE products_id=:products_id",
                        TABLE_PRODUCTS
                    ),['products_id'=>$products_id],
                    true
                );
		$packaging_weight = 0;
		if($weight_res['packagings_id'] > 0){
		    $pquery = xtc_db_query(sprintf(
			    "SELECT weight FROM packagings WHERE packagings_id='%s'",
			    $weight_res['packagings_id']
		    ));
		    $pres = xtc_db_fetch_array($pquery);
		    $packaging_weight = floatval($pres['weight']);
		}
		$pweight = floatval($weight_res[$select_field]);
		if(!$netto){
		    if($packaging_weight > 0){
			    $pweight += floatval($packaging_weight);
		    }
		}
	}
	return $pweight;
  }

  function xtc_get_orders_product_collies_tax_value($collies,$xtPrice){
	$sum_tax_classes = array();
	foreach($collies as $k=>$v){
		$pID = $v['collie_products_id'];
		$qty = $v['quantity'];
                if($xtPrice->getCountry_id() > 0){
                    $country_id = $xtPrice->getCountry_id();
                    $zone_id = $xtPrice->getZone_id();
                }else{
                    $country_id = STORE_COUNTRY;
                    $zone_id = 0;
                }
                $tax_class_id = yes_eu_oss_get_products_tax_class_id($pID, $country_id, $zone_id);
                $tax_rate = xtc_get_tax_rate($tax_class_id, $country_id, $zone_id);
		$sum_tax_classes[ ''.$tax_rate ] += $xtPrice->xtcGetPrice($pID,$format=false,$qty,$tax_class_id,$pPrice=0);
	}
	$max_tax = 0;
	$max_sum = 0;
	foreach($sum_tax_classes as $tax=>$sum){
		if($sum > $max_sum){
			$max_tax = $tax;
			$max_sum = $sum;
		}
	}
	return $max_tax;
  }

function xtc_get_product_collies_tax_value($collies, $country_id, $zone_id = 0){
    $sum_tax_classes = array();
    foreach($collies as $k=>$v){
        $pID = $v['collie_products_id'];
        $qty = $v['quantity'];
        $tax_class_id = yes_eu_oss_get_products_tax_class_id($pID, $country_id, $zone_id);
        $tax = yes_query(
            "SELECT products_price FROM products WHERE products_id=:products_id",
            ['products_id'=>(int)$pID],
            true
        );
        
        $tax_rate = xtc_get_tax_rate($tax_class_id, $country_id, $zone_id);
        if(!isset($sum_tax_classes[ ''.$tax_rate ])){
            $sum_tax_classes[ ''.$tax_rate ] = 0;
        }
        $sum_tax_classes[ ''.$tax_rate ] += $qty*$tax['products_price'];
    }
    $max_tax = 0;
    $max_sum = 0;
    foreach($sum_tax_classes as $tax=>$sum){
            if($sum > $max_sum){
                    $max_tax = $tax;
                    $max_sum = $sum;
            }
    }
    return $max_tax;
}

function xtc_get_product_collies_tax_class($collies, $country_id, $zone_id = 0){
    $sum_tax_classes = array();
    foreach($collies as $k=>$v){
        $pID = $v['collie_products_id'];
        $qty = $v['quantity'];
        $tax_class_id = yes_eu_oss_get_products_tax_class_id($pID, $country_id, $zone_id);
        $tax = yes_query(
            "SELECT products_price FROM products WHERE products_id=:products_id",
            ['products_id'=>(int)$pID],
            true
        );
        $tax_rate = xtc_get_tax_rate($tax_class_id, $country_id, $zone_id);
        if(!isset($sum_tax_classes[ ''.$tax_class_id ])){
            $sum_tax_classes[ ''.$tax_class_id ] = 0;
        }
        $sum_tax_classes[ ''.$tax_class_id ] += $qty*$tax['products_price'];
    }
    $max_tax_class_id = 0;
    $max_sum = 0;
    foreach($sum_tax_classes as $tax_class_id=>$sum){
        if($sum > $max_sum){
            $max_tax_class_id = $tax_class_id;
            $max_sum = $sum;
        }
    }
    return $max_tax_class_id;
}
