<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_expire_specials.inc.php,v 1.10 2018/08/16 07:36:55 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(specials.php,v 1.5 2003/02/11); www.oscommerce.com 
   (c) 2003	 nextcommerce (xtc_expire_specials.inc.php,v 1.5 2003/08/13); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
require_once(DIR_FS_INC . 'xtc_set_specials_status.inc.php');
require_once(DIR_FS_CATALOG.'admin/includes/classes/specials_ebay_revise.php');
require_once(DIR_FS_CATALOG.'admin/includes/classes/class.ebay_auction.php');
// Auto expire products on special
function xtc_expire_specials() {
    global $InstanceCache;
    if(!function_exists('xtc_get_tax_rate')){
            require_once(DIR_FS_INC.'xtc_get_tax_rate.inc.php');
    }
    $cache_specials_expire_duration = 60*5; // 5 min
    $key = 'shop.specials.expire.deactivate';
    $CachedString = $InstanceCache->getItem($key);
    if (!$CachedString->isHit()) {
        // DEAKTIVIEREN VON LAUFENDEN SPECIALS NACH ABLAUFDATUM
	$specials_query = xtc_db_query("select specials_id,products_id,ebay_price_revise from " . TABLE_SPECIALS . " where status = '1' and now() >= expires_date and expires_date > 0");
	if (xtc_db_num_rows($specials_query)) {
            $specials_array = array();
            while ($specials = xtc_db_fetch_array($specials_query)) {
                    $specials_array[] = $specials;
            }
            for($i=0;$i<sizeOf($specials_array);$i++){
                xtc_set_specials_status($specials_array[$i]['specials_id'], '0');
                if($specials_array[$i]['ebay_price_revise'] == 0)
                        continue;
                $status = 0;
                $is_revised = 1;
                $affected_ser = specials_ebay_revise::get_items_by_status_and_products_id($status, $is_revised, $specials_array[$i]['products_id']);
                foreach($affected_ser as $specials_ebay_revise_id){
                    $ser = new specials_ebay_revise( $specials_ebay_revise_id );
                    $ser->update_status(1);
                }
            }
        } // EOF DEAKTIVIEREN LAUFENDER SPECIALS NACH ABLAUF DES ENDDATUMS
        

        // SPECIALS MIT STATUS 0 AUF 1 SETZEN WENN STARTDATE ERREICHT IST UND 
        // ABLAUFDATUM NICHT UEBERSCHRITTEN IST (ODER ABLAUFDATUM 0)
        $specials_query = xtc_db_query("select specials_id,s.products_id, ebay_price_revise from " . TABLE_SPECIALS . " s LEFT JOIN products p USING(products_id) where status = '0' and now() >= start_date and start_date > 0 and (now() <= expires_date or expires_date=0)");
        if (xtc_db_num_rows($specials_query)) {
            if(!class_exists('xtcPrice')){
                require_once(DIR_FS_CATALOG.'includes/classes/xtcPrice.php');
            }
            if(!class_exists('product')){
                require_once(DIR_FS_CATALOG.'includes/classes/product.php');
            }
            $xtPrice = new xtcPrice(DEFAULT_CURRENCY, EBAY_CUSTOMERS_STATUS);
            $specials_array = array();
            while ($specials = xtc_db_fetch_array($specials_query)) {
                $specials_array[] = $specials;
            }
            for($i=0;$i<sizeOf($specials_array);$i++){
                xtc_set_specials_status($specials_array[$i]['specials_id'], '1');
                if($specials_array[$i]['ebay_price_revise'] == 0){
                    continue;
                }
                $p = new product( $specials_array[$i]['products_id'] );
                $runnings = $p->get_running_auctions_list();
                foreach($runnings as $auction_info){
                    switch($auction_info['variation']){
                        case 1:
                            $ser_exists = specials_ebay_revise::exists($auction_info['id'],$specials_array[$i]['specials_id'], $specials_array[$i]['products_id']);
                            break;
                        default:
                            $ser_exists = specials_ebay_revise::exists($auction_info['id'],$specials_array[$i]['specials_id'], '');
                            break;
                    }
                    if($ser_exists){
                        continue;
                    }
                    $ea = new ebay_auction( $auction_info['id'] );

                    $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                            $specials_array[$i]['products_id'],STORE_COUNTRY
                    );
                    $products_query = xtc_db_query(sprintf(
                        "SELECT products_price FROM products WHERE products_id='%d'",
                        $specials_array[$i]['products_id']
                    ));
                    $products_record = xtc_db_fetch_array($products_query);
                    $price = $xtPrice->xtcGetPrice($specials_array[$i]['products_id'], $format = false, 1, $products_tax_class_id, $products_record['products_price'],0,false);

                    switch($auction_info['variation']){
                        case 1:
                            $sku = $specials_array[$i]['products_id'];
                            break;
                        default:
                            $sku = '';
                            break;
                    }
                    specials_ebay_revise::add_entry($specials_array[$i]['products_id'], 
                            $auction_info['ebay_id'], 
                            $ea->getAuctionprice(), 
                            $price, 
                            $sku
                    );
                }
            }
        }
        $CachedString->set('1')->expiresAfter($cache_specials_expire_duration)->addTag('shop');//shop.specials.expire.deactivate
        $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
    }
}