<?php
function yes_get_customers_email_aliases($customers_id, $include_account_email = false){
    $aliases = array();
    if($customers_id < 1) {
        return $aliases;
    }
    
    if($include_account_email){
        $cust = \YES4Trade\Model\customers::get_by_customers_id($customers_id,[
            'customers_email_address'
        ]);
        $aliases[] = $cust->customers_email_address;
    }
    
    
    $query = yes_query(
        "SELECT email_address FROM customers_email_aliases WHERE customers_id=:customers_id",
        ['customers_id'=>$customers_id]
    );
    foreach($query as $record){
	$aliases[] = $record['email_address'];
    }
    return $aliases;
}

function yes_add_customers_email_alias($email_address,$customers_id,$editor_id=0){
    $cust = \YES4Trade\Model\customers::get_by_email_address($email_address);
    if($cust !== null){
	    return false; // ist kunden login adresse
    }
    $record = yes_get_customers_email_alias_data_by_email_address($email_address);
    if(sizeOf($record)) {
        return false; // existiert
    }
    $insert_sql_array = array(
	'customers_id'=>(int)$customers_id,
	'email_address'=>$email_address
    );
    yes_db_perform('customers_email_aliases',$insert_sql_array);
    $new = new \YES4Trade\Model\customers_memo([
	'customers_id'=>(int)$customers_id,
	'memo_date'=>date('Y-m-d H:i:s'),
	'memo_title'=>'Email Alias erzeugt',
	'memo_text'=>sprintf('Email Alias %s erzeugt',$email_address),
	'poster_id'=>(int)$editor_id
    ]);
    $new->create();
    return true;
}

function yes_get_customers_email_alias_data_by_email_address($email_address){
    $query = yes_query(
        "SELECT customers_email_aliases_id,customers_id FROM customers_email_aliases WHERE email_address=:email",
        ['email'=>$email_address]
    );
    if(!sizeOf($query)) {
        return array();
    }
    return current($query);
}

function yes_remove_customers_email_alias($email_address,$editor_id=0){
    $record = yes_get_customers_email_alias_data_by_email_address($email_address);
    if(!sizeOf($record)) {
        return false;
    }
    xtc_db_query(sprintf(
        "DELETE FROM customers_email_aliases WHERE customers_email_aliases_id='%s'",
        $record['customers_email_aliases_id']
    ));
    $new = new \YES4Trade\Model\customers_memo([
	'customers_id'=>(int)$record['customers_id'],
	'memo_date'=>date('Y-m-d H:i:s'),
	'memo_title'=>'Email Alias entfernt',
	'memo_text'=>sprintf('Email Alias %s entfernt',$email_address),
	'poster_id'=>(int)$editor_id
    ]);
    $new->create();
    return true;
}