<?php
class amazon {

    var $code, $title, $description, $enabled;

    /*
     *  um bei Modul Konfigurationen eigene Save Routinen zu haben, muss das
     * Modul diese Funktion enthalten
     * Die admin/modules.php prueft auf diese Funktion und fuehrt sie bei 
     * Vorhandensein aus. (derzeit nur fuer set=other)
     */
    function configuration_save_handler(){
    	if(!isset($_REQUEST['marketplace_id'])){
    		return true;
    	}
        $secure_path = main::get_secure_path();
        $file = $secure_path.'AMAZON_SP_AUTH.json';
        if(!is_file($file)){
            $json = new stdClass();
            $json->users = [];
            for($i=0;$i<AMAZONUSER_COUNTER; $i++){
                $json->users[$i]->lwaClientId = '';
                $json->users[$i]->lwaClientSecret = '';
                $json->users[$i]->marketplace_id = '';
            }
        }else{
            $json = json_decode(file_get_contents($file));
        }
	for($i=0;$i<AMAZONUSER_COUNTER;$i++){
            $json->users[ $i ]->marketplace_id = $_REQUEST['marketplace_id'][$i];
	}
        $json_pretty = json_encode($json,JSON_PRETTY_PRINT);
        file_put_contents($file, $json_pretty);
    }

    function __construct() {
      require_once(DIR_FS_CATALOG.'lang/german/modules/other/amazon.php');
      $this->code = 'amazon';
      $this->title = MODULE_OTHER_AMAZON_TEXT_TITLE;
      $this->description = MODULE_OTHER_AMAZON_TEXT_DESCRIPTION;
      if(defined('MODULE_OTHER_AMAZON_STATUS')){
        $this->sort_order = MODULE_OTHER_AMAZON_SORT_ORDER;
        $this->enabled = ((MODULE_OTHER_AMAZON_STATUS == 'True') ? true : false);
      }
    }


    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_OTHER_AMAZON_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_AMAZON_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_AMAZON_SORT_ORDER', '0',  '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID', '',  '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added,use_function,set_function) values ('MODULE_OTHER_AMAZON_CUSTOMERS_STATUS_ID', '2',  '6', '0', now(),'xtc_get_customers_status_name','xtc_cfg_pull_down_customers_status_list(')");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_AMAZON_PRODUCTS_NAME_FROM_AMAZON', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_AMAZON_REVISE', 'False',  '6', '11', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_AMAZON_REVISE_QTY', '0',  '6', '12', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_AMAZON_FBA_SHIP_PROMOTION_DISCOUNT_PRODUCTS_ID', '0',  '6', '13', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_AMAZON_FBA_ITEM_PROMOTION_DISCOUNT_PRODUCTS_ID', '0',  '6', '14', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_AMAZON_FBA_GIFT_WRAP_PRODUCTS_ID', '0',  '6', '15', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_AMAZON_FULFILLMENT_LATENCY', '3',  '6', '16', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_AMAZON_EMAIL_SUBJECT', '',  '6', '17', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, use_function,set_function, date_added) values ('MODULE_OTHER_AMAZON_ORDER_STATUS', '',  '6', '18', 'xtc_get_orders_status_name','xtc_cfg_pull_down_order_statuses(', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " SET configuration_key='MODULE_OTHER_AMAZON_MARKETPLACE_IDS',sort_order=10, configuration_value='',configuration_group_id=6,date_added=now()");
      
   }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array(
        'MODULE_OTHER_AMAZON_STATUS', 'MODULE_OTHER_AMAZON_SORT_ORDER',
        'MODULE_OTHER_AMAZON_CUSTOMERS_STATUS_ID',
        'MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID',
        'MODULE_OTHER_AMAZON_PRODUCTS_NAME_FROM_AMAZON',
        'MODULE_OTHER_AMAZON_REVISE',
        'MODULE_OTHER_AMAZON_REVISE_QTY',
        'MODULE_OTHER_AMAZON_FBA_SHIP_PROMOTION_DISCOUNT_PRODUCTS_ID',
        'MODULE_OTHER_AMAZON_FBA_ITEM_PROMOTION_DISCOUNT_PRODUCTS_ID',
        'MODULE_OTHER_AMAZON_FBA_GIFT_WRAP_PRODUCTS_ID',
        'MODULE_OTHER_AMAZON_FULFILLMENT_LATENCY',
        'MODULE_OTHER_AMAZON_EMAIL_SUBJECT',
        'MODULE_OTHER_AMAZON_ORDER_STATUS',
        'MODULE_OTHER_AMAZON_MARKETPLACE_IDS'
      );
    }
  }
