<?php
require_once(DIR_FS_CATALOG.'lang/german/modules/other/'.basename(__FILE__));
class staffelpreise_als_varianten {
	var $code, $title, $description, $enabled, $variation_name_de, $variation_name_en, $quantity_suffix_de, $quantity_suffix_en; 

	function __construct() {
		$this->code = 'staffelpreise_als_varianten';
		$this->title = MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_TEXT_TITLE;
		$this->description = MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_TEXT_DESCRIPTION;
                if(defined('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS')){
        		$this->sort_order = MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_SORT_ORDER;
                	$this->enabled = ((MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS == 'True') ? true : false);
                }
	}


	function check() {
		if (!isset($this->_check)) {
			$check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS'");
			$this->_check = xtc_db_num_rows($check_query);
		}
		return $this->_check;
	}

	function install() {
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_SORT_ORDER', '0',  '6', '2', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_VARIATION_NAME_DE', 'Menge',  '6', '3', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_VARIATION_NAME_EN', 'Quantity',  '6', '4', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_QUANTITY_SUFFIX_DE', ' Stk',  '6', '5', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_QUANTITY_SUFFIX_EN', ' pcs',  '6', '6', now())");
	}

	function remove() {
		xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
	}

	function keys() {
		return array(
			'MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS', 
			'MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_SORT_ORDER',
			'MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_VARIATION_NAME_DE',
			'MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_VARIATION_NAME_EN',
			'MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_QUANTITY_SUFFIX_DE',
			'MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_QUANTITY_SUFFIX_EN'
		);
	}
}
