<?php
/* ---------------------------------------------------------------------------------------
$Id: dhlgkapi.php,v 1.23 2020/08/03 08:20:24 ssh-511548-cvs Exp $   

Autor: Nico Bauer (c) 2016 D�rfelt GmbH for DHL Paket GmbH
   
-----------------------------------------------------------------------------------------
based on:

zones.php

(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
(c) 2002-2003 osCommerce(zones.php,v 1.19 2003/02/05); www.oscommerce.com 
(c) 2003      nextcommerce (zones.php,v 1.7 2003/08/24); www.nextcommerce.org
(c) 2006      xtcommerce (zones.php 899 2005-04-29);

Released under the GNU General Public License
[http://www.gnu.org/licenses/gpl-2.0.html] 
-----------------------------------------------------------------------------------------*/
class dhlgkapi {
    var $code, $title, $description, $icon, $enabled, $dhl_types, $quotes,
            $InstanceCache, $order, $sort_order, $store_country;


    function __construct() {
        global $order, $shipping_weight, $InstanceCache; 
        if(!defined('MODULE_SHIPPING_DHLGKAPI_TEXT_TITLE')){
            require_once(DIR_FS_CATALOG.'lang/german/modules/shipping/dhlgkapi.php');
        }
        $this->code = 'dhlgkapi';
        $this->title = MODULE_SHIPPING_DHLGKAPI_TEXT_TITLE;
        $this->description = MODULE_SHIPPING_DHLGKAPI_TEXT_DESCRIPTION;
        $this->sort_order = (defined('MODULE_SHIPPING_DHLGKAPI_SORT_ORDER'))?intval(constant('MODULE_SHIPPING_DHLGKAPI_SORT_ORDER')):0;
        $this->icon = '';
        $this->enabled = ((defined('MODULE_SHIPPING_DHLGKAPI_STATUS') and constant('MODULE_SHIPPING_DHLGKAPI_STATUS') == 'True') ? true : false);

        //uncomment if needed
        //require_once(DIR_FS_INC."xtc_get_countries.inc.php");
        require_once(DIR_FS_INC."xtc_get_countries_with_iso_codes.inc.php");
        
        $countries = xtc_db_query("select countries_iso_code_2,countries_iso_code_3 from " . TABLE_COUNTRIES . " where countries_id = '" . STORE_COUNTRY . "'");
        $countries_values = xtc_db_fetch_array($countries);
        $this->store_country=$countries_values;


        if (isset($_POST['PreferredNeighbour'])) {
            $_SESSION['dhlgkapi']['PreferredNeighbour']=$_POST['PreferredNeighbour'];
        }

        if (isset($_POST['PreferredLocation'])) {
            $_SESSION['dhlgkapi']['PreferredLocation']=$_POST['PreferredLocation'];
        }

        if (isset($_POST['PreferredDay'])) {
            $_SESSION['dhlgkapi']['PreferredDay']=$_POST['PreferredDay'];
        }

        if (isset($_POST['PreferredTime'])) {
            $_SESSION['dhlgkapi']['PreferredTime']=$_POST['PreferredTime'];
        }


        switch ($this->store_country['countries_iso_code_2']) {
            case 'DE':
                $this->dhl_types = array('V01PAK', 'V53WPAK(Z1)', 'V53WPAK(Z2)', 'V53WPAK(Z3)', 'V53WPAK(Z4)','V62WP');
                break;

            case 'AT':
                $this->dhl_types = array('V86PARCEL', 'V87PARCEL', 'V82PARCEL(Z1)', 'V82PARCEL(Z2)');
                break;

            default:
                $this->enabled = false;
        }
        $this->order = $order;
        $this->InstanceCache = $InstanceCache;
    }


    function quote($method = '') {
        global $xtPrice, $order, $shipping_weight;
        if($this->enabled === false){
            return null;
        }
        $dest_country = $order->delivery['country']['iso_code_2'];
        $dest_zones = array();
        $error = false;
        if (isset($method) && $method!='') {
            $selected_type='';
            foreach ($this->dhl_types as $type) {
                if ($type == $method) {
                    $selected_type = $type;
                    break;
                } 
            } 

            if ($selected_type!='') {
                $this->dhl_types=array($type); 
            }

        }

        foreach ($this->dhl_types as $type) {
            $countries_table = constant('MODULE_SHIPPING_DHLGKAPI_'.$type.'_COUNTRIES');
            $country_zones = explode(",", $countries_table);
            $zone_enabled = constant('MODULE_SHIPPING_DHLGKAPI_'.$type.'_ENABLED');
            if (in_array($dest_country, $country_zones) && $zone_enabled == 'True') {
                $dest_zones[] = $type;
            }
        }
        if (!$dest_zones) {
            $error = true;
        } else {
            $shipping_methods=array();
            foreach ($dest_zones as $type) {

                $shipping_method_addon='';
                $shipping_method_text='';
                $shipping_method_text_array=array();
                if ($type=='V01PAK' && MODULE_SHIPPING_DHLGKAPI_WUNSCHPAKET_ENABLED=='True') {
                    if ($method=='' && strstr($_SERVER["PHP_SELF"],'checkout_shipping')) {
                        $dhl_smarty=new yesSmarty;
                        $dhl_smarty->assign('tpl_path',DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/');
                        $dhl_smarty->assign('logo_path', HTTP_SERVER.DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');
                        $dhl_smarty->assign('language', $order->info['language']);

                        $dhl_smarty->assign('WUNSCHPAKET_TEXT_TITLE', MODULE_SHIPPING_DHLGKAPI_WUNSCHPAKET_TEXT_TITLE);
                        $dhl_smarty->assign('WUNSCHPAKET_TEXT_DESC', MODULE_SHIPPING_DHLGKAPI_WUNSCHPAKET_TEXT_DESC);
                        $dhl_smarty->assign('PD_TITLE', MODULE_SHIPPING_DHLGKAPI_PD_TITLE);
                        $dhl_smarty->assign('PD_DESC', MODULE_SHIPPING_DHLGKAPI_PD_DESC);
                        $dhl_smarty->assign('PD_TOOLTIP', MODULE_SHIPPING_DHLGKAPI_PD_TOOLTIP);
                        $dhl_smarty->assign('PT_TITLE', MODULE_SHIPPING_DHLGKAPI_PT_TITLE);
                        $dhl_smarty->assign('PT_DESC', MODULE_SHIPPING_DHLGKAPI_PT_DESC);
                        $dhl_smarty->assign('PT_TOOLTIP', MODULE_SHIPPING_DHLGKAPI_PT_TOOLTIP);
                        $dhl_smarty->assign('PN_TITLE', MODULE_SHIPPING_DHLGKAPI_PN_TITLE);
                        $dhl_smarty->assign('PN_DESC', MODULE_SHIPPING_DHLGKAPI_PN_DESC);
                        $dhl_smarty->assign('PN_TOOLTIP', MODULE_SHIPPING_DHLGKAPI_PN_TOOLTIP);
                        $dhl_smarty->assign('PL_TITLE', MODULE_SHIPPING_DHLGKAPI_PL_TITLE);
                        $dhl_smarty->assign('PL_DESC', MODULE_SHIPPING_DHLGKAPI_PL_DESC);
                        $dhl_smarty->assign('PL_TOOLTIP', MODULE_SHIPPING_DHLGKAPI_PL_TOOLTIP);
                        $dhl_smarty->assign('BUTTON_PSF', '<a href="'.xtc_href_link(FILENAME_CHECKOUT_SHIPPING_ADDRESS, null, 'SSL').'">'.MODULE_SHIPPING_DHLGKAPI_PSF_BUTTON.'</a>');
                        $dhl_smarty->assign('PSF_TITLE', MODULE_SHIPPING_DHLGKAPI_PSF_TITLE);
                        $dhl_smarty->assign('PSF_DESC', MODULE_SHIPPING_DHLGKAPI_PSF_DESC);


                        $days=0;
                        $count=2;
                        if (time() > strtotime(MODULE_SHIPPING_DHLGKAPI_WUNSCHPAKET_TIME)) {
                            $count=3;
                        }
                        $daynames=unserialize(MODULE_SHIPPING_DHLGKAPI_DAYNAMES);

                        $pd_data=array();
                        
                        while($days<6) {
                            $date=strtotime('+'.$count.' days');
                            $delivery_date=date('d.m.y', $date);
                            $delivery_date_shown=date('d', $date);
                            $weekday=date('w', $date);
                            if ($weekday!=0) {
                                $pd_data[]=xtc_draw_checkbox_field('PreferredDay',$delivery_date,null,'id="PreferredDay'.$delivery_date.'" onClick="clear_select(\'PreferredDay\',\'PreferredDay'.$delivery_date.'\')"').'<label for="PreferredDay'.$delivery_date.'">'.$delivery_date_shown.'<br>'.$daynames[$weekday].'</label>';
                                $days++;
                            }
                            $count++;
                        }
                        $dhl_smarty->assign('PD_DATA', $pd_data);

                        $pt_data=array(); 
                        $pt_data[]=xtc_draw_checkbox_field('PreferredTime','18002000',null,'id="PreferredTime18002000" onClick="clear_select(\'PreferredTime\',\'PreferredTime18002000\')"').
                        '<label for="PreferredTime18002000">18 - 20</label>';
                        $pt_data[]=xtc_draw_checkbox_field('PreferredTime','19002100',null,'id="PreferredTime19002100" onClick="clear_select(\'PreferredTime\',\'PreferredTime19002100\')"').
                        '<label for="PreferredTime19002100">19 - 21</label>';

                        $dhl_smarty->assign('PT_DATA', $pt_data);

                        $dhl_smarty->assign('PN_DATA',xtc_draw_input_field('PreferredNeighbour',null,'id="PreferredNeighbour" maxlength="32" onInput="checkempty();" placeholder="'.MODULE_SHIPPING_DHLGKAPI_PN_PLACEHOLDER.'"'));

                        $dhl_smarty->assign('PL_DATA',xtc_draw_input_field('PreferredLocation',null,'id="PreferredLocation" maxlength="32" onInput="checkempty();" placeholder="'.MODULE_SHIPPING_DHLGKAPI_PL_PLACEHOLDER.'"'));
                        if(is_file(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/module/dhlgkapi.html')){
                            $shipping_method_addon = $dhl_smarty->fetch(CURRENT_TEMPLATE.'/module/dhlgkapi.html'); 
                        }else{
                            $shipping_method_addon = '';
                        }
                    } else {
                        if (isset($_SESSION['dhlgkapi']['PreferredDay']) && $_SESSION['dhlgkapi']['PreferredDay']!='') 
                            $shipping_method_text_array[]='PD:'.$_SESSION['dhlgkapi']['PreferredDay'];

                        if (isset($_SESSION['dhlgkapi']['PreferredTime']) && $_SESSION['dhlgkapi']['PreferredTime']!='') 
                            $shipping_method_text_array[]='PT:'.$_SESSION['dhlgkapi']['PreferredTime'];

                        if (isset($_SESSION['dhlgkapi']['PreferredNeighbour']) && $_SESSION['dhlgkapi']['PreferredNeighbour']!='') 
                            $shipping_method_text_array[]='PN:'.$_SESSION['dhlgkapi']['PreferredNeighbour'];

                        if (isset($_SESSION['dhlgkapi']['PreferredNeighbour']) && $_SESSION['dhlgkapi']['PreferredLocation']!='')    
                            $shipping_method_text_array[]='PL:'.$_SESSION['dhlgkapi']['PreferredLocation'];

                        if (!empty($shipping_method_text_array)) $shipping_method_text=' ['.implode('~',$shipping_method_text_array).']'; 

                    }

                }

                $shipping = -1;
                $zones_cost = constant('MODULE_SHIPPING_DHLGKAPI_'.$type.'_COST');

                $zones_table = preg_split('/[:,]/' , $zones_cost);
                $size = sizeof($zones_table);
                for ($i=0; $i<$size; $i+=2) {
                    if ($shipping_weight <= $zones_table[$i]) {
                        $shipping = $zones_table[$i+1];
                        //$shipping_method = trim(MODULE_SHIPPING_DHLGKAPI_TEXT_WAY . ' ' . constant('MODULE_SHIPPING_DHLGKAPI_TYPE_'.$type.'_TITLE') . ' (' .$type. ') ' . $dest_country . ' : ' . $shipping_weight . ' ' . MODULE_SHIPPING_DHLGKAPI_TEXT_UNITS . $shipping_method_text);
                        $shipping_method = trim(MODULE_SHIPPING_DHLGKAPI_TEXT_WAY . ' ' . constant('MODULE_SHIPPING_DHLGKAPI_TYPE_'.$type.'_TITLE') . ' '. $dest_country . ' ' . $shipping_weight . ' ' . MODULE_SHIPPING_DHLGKAPI_TEXT_UNITS . $shipping_method_text);
                        break;
                    }
                }

                if ($shipping == -1) {
                    $shipping_cost = 0;
                    $shipping_method = MODULE_SHIPPING_DHLGKAPI_UNDEFINED_RATE;
                } else {
                    if (($xtPrice->xtcRemoveCurr($_SESSION['cart']->show_total()) >= constant('MODULE_SHIPPING_DHLGKAPI_'.$type.'_FREEAMOUNT')) && (constant('MODULE_SHIPPING_DHLGKAPI_'.$type.'_FREEAMOUNT') > 0)) {
                        $shipping_cost = 0.00; 
                    } else {
                        // KEINE AHNUNG, WANN HABEN WIR EINE DEST_ZONE?
                        if(isset($dest_zone)){
                            $shipping_cost = ($shipping + constant('MODULE_SHIPPING_DHLGKAPI_HANDLING_' . $dest_zone));
                        }else{
                            $shipping_cost = $shipping;
                        }
                    }
                }
                $shipping_methods[]=array('id' => $type,
                    'title' => $shipping_method.$shipping_method_addon,
                    'cost' => $shipping_cost,
                    'additional_params'=>$this->get_wunschpaket_checkout_html($order->delivery['postcode'],
                            array('standortsuche'=>true)
                    )
                    
                );
            }
        }
        $this->quotes = array('id' => $this->code,
            'module' => MODULE_SHIPPING_DHLGKAPI_TEXT_TITLE,
            'methods' => $shipping_methods
        );
        
        $tax_class = $order->get_shipping_tax_class();
        if ($tax_class > 0) {
            $country_id = $order->delivery['country']['id'];
            $zone_id = $order->delivery['zone_id'];
            $this->quotes['tax'] = xtc_get_tax_rate($tax_class, $country_id, $zone_id);
        }

        if (xtc_not_null($this->icon)) {
            $this->quotes['icon'] = xtc_image($this->icon, $this->title);
        }

        if ($error == true) {
            $this->quotes['error'] = MODULE_SHIPPING_DHLGKAPI_INVALID_ZONE;
        }
        //$this->standortsuche_query('25469', 'Eidelstedter Weg', '218');

        return $this->quotes;    
    }
    
    function wunschpaket_call($service,$zip, $date = null, $startParcelCenter = 0){
        if($this->enabled === false){
            return null;
        }
        global $secure_path;
        $secure_path = main::get_secure_path();
        $test = main::isDev(); // irrelevant
        $url = $test ? 'https://cig.dhl.de/services/sandbox/rest/' : 'https://cig.dhl.de/services/production/rest/';
        // evtl yes4trade_1
        $user = $test ? 'yes4trade.de' : MODULE_SHIPPING_DHLGKAPI_USER;
        $pass = $test ? 'Filu-1605!' : MODULE_SHIPPING_DHLGKAPI_PASSWORD;
        return $this->wunschpaket_query($user, $pass,$service,$zip, $date, $startParcelCenter);
    }
    
    function get_intransit_orders_from_shipment_id($tracking_id){
        $secure_path = main::get_secure_path();
        $test = main::isDev(); // irrelevant
        $url = $test ? 'https://cig.dhl.de/services/sandbox/rest/' : 'https://cig.dhl.de/services/production/rest/';
        // evtl yes4trade_1
        $user = $test ? 'yes4trade.de' : DHL_VERSENDEN_APPLICATION_ID;
        $pass = $test ? 'Filu-1605!' : DHL_VERSENDEN_APPLICATION_TOKEN;
        return $this->intransit_query($user, $pass,$tracking_id);
    }
    
    function standortsuche_query($zip, $street='', $street_no=''){
        //$type Auspraegungen - diese gibt es auch jeweils fuer coordinate
        // getPackstationsByAddress:
        // Mit dieser Funktion werden Packstationen im Umkreis von 15 km um die angegebene Adresse gefunden.
        // getPaketboxesByAddress:
        // Mit dieser Funktion werden Paketboxen im Umkreis von 15 km um die angegebene Adresse gefunden.
        // getPackstationsPaketboxesByAddress:
        // Mit dieser Funktion werden Packstationen und Paketboxen im Umkreis von 15 km um die angegebene Adresse gefunden.
        // getPackstationsFilialeDirektByAddress:
        // Mit dieser Funktion werden Postfiliale Direkt-Filialen und Packstationen im Umkreis von 15 km um die angegebene Koordinate gefunden.
        // getBranchesByAddress:
        // Mit dieser Funktion werden Filialen im Umkreis von 15 km um die angegebene Adresse gefunden.
        if($this->enabled === false){
            return null;
        }
        require_once('admin/includes/classes/yes_dhl_api.php');
        require_once ('admin/includes/classes/reclamation.php');
        require_once (DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
        $yes_dhl_api = new yes_dhl_api;
        if(sizeOf($yes_dhl_api->getErrors())){
            die(implode('<br />',$yes_dhl_api->getErrors()));
        }
        $sID = 0;
        $test_mode = main::isDev(); // irrelevant
        $function='getPackstationsFilialeDirektByAddress';
        $dhl_xml = new \stdClass();
        $dhl_xml->getPackstationsFilialeDirektByAddress = new \stdClass();
        $dhl_xml->getPackstationsFilialeDirektByAddress->key = '';
        $dhl_xml->getPackstationsFilialeDirektByAddress->address = new \stdClass();
        $dhl_xml->getPackstationsFilialeDirektByAddress->address->street = $street;
        $dhl_xml->getPackstationsFilialeDirektByAddress->address->streetNo = $street_no;
        $dhl_xml->getPackstationsFilialeDirektByAddress->address->zip = $zip;
        $result= $yes_dhl_api->soap_request($dhl_xml, $function, $sID, $test_mode);
        if(!sizeOf($result->packstation_filialedirekt)){
            die('Keine Filialen / Packstationen gefunden.');
        }
        echo '<div class="dhl_standorte">'."\r\n";
        foreach($result->packstation_filialedirekt as $ps){
            $times = '';
            if(isset($ps->timeinfos->timeinfo) and sizeOf($ps->timeinfos->timeinfo)){
                $t = [];
                $dowMap = array('Mo', 'Di', 'Mi', 'Do', 'Fr', 'Sa','So');
                foreach($ps->timeinfos->timeinfo as $time){
                    $day = $dowMap[($time->dayTo-1)];
                    $t['DAY'.$time->dayTo] = sprintf('<span class="time_type_%d">%s: %s</span>',
                            $time->type,
                            $day,
                            ((isset($time->timeFrom))?$time->timeFrom:'?').' - '.$time->timeTo
                    );
                }
                ksort($t);
                $times = implode('<br />',$t);
            }
            $address_get_params  = 'street='.urlencode($ps->address->street);
            $address_get_params .= '&streetNo='.urlencode($ps->address->streetNo);
            $address_get_params .= '&zip='.urlencode($ps->address->zip);
            $address_get_params .= '&city='.urlencode($ps->address->city);
            $marker = ($ps->externalMarker != '')?$ps->externalMarker.'<br />' : '';
            $address = sprintf('%s%s %s<br />%s %s',
                    $marker,
                    $ps->address->street, $ps->address->streetNo,
                    $ps->address->zip, $ps->address->city
            );
            if(strtoupper(gettype($ps->branchTypePF)) == 'NULL'){
                if(strtoupper(gettype($ps->packstationId)) != 'NULL'){
                    $address_name = sprintf('<b>DHL PACKSTATION %s</b>',$ps->packstationId);
                }
            }else{
                switch($ps->branchTypePF){
                    case 'dhlpaketshop':
                    case 'postbank_finanzcenter':
                        $address_name = sprintf('<b>DHL PAKETSHOP %s</b>',$ps->depotServiceNo);
                        break;
                    case 'serviceoutlet':
                    case 'partneroutlet':
                        $address_name = sprintf('<b>Postfiliale %s</b>',$ps->depotServiceNo);
                        break;
                    default:
                        $address_name = sprintf('<b>%s</b>',strtoupper($ps->branchTypePF));
                        break;
                }
            }
            if(strtoupper(gettype($ps->address->remark)) != 'NULL'){
                $address = $ps->address->remark.'<br />'.$address;
            }
            $address = $address_name.'<br />'.$address;
            
            $address_get_params .= '&name='.urlencode($address_name);
            printf("\t<div id=\"%s\" class=\"dhl_standort\">\r\n"
                    ."\t\t<div class=\"dhl_standort_address\"><a href=\"javascript:select_standort('%s')\" style=\"text-decoration: none;\" title=\"Auswahl Filiale/Packstation\">%s</a></div>\r\n"
                    ."\t\t<div class=\"dhl_standort_distance\">%sm entfernt</div>\r\n"
                    . "\t</div>\r\n",
                    $ps->id,
                    $address_get_params,
                    $address,
                    $ps->distance
            );
        }
        echo '</div>';
        $valid_nr = 0;
        if(sizeOf($yes_dhl_api->getErrors())){
                //echo implode("\r\n",$yes_dhl_api->getErrors());
        }
        exit;
    }
    
    function intransit_query($user, $pass,$tracking_id){
	$url = sprintf('https://cig.dhl.de/services/sandbox/rest/shipments/%s/offers',
                $tracking_id
        );
	echo '<h4>DHL intransit_query()</h4>';
        printf('user:pass %s:%s url: %s',$user,$pass,$url);
	$xml_header_doku = sprintf('<?xml version="1.0" encoding="UTF-8" standalone="no"?> <data appname="%s" language-code="de" password="%s" piece-code="%s" request="d-get-piece-detail"/>',
		$user,$pass,$tracking_id
	);
        $ch = curl_init();
// DEBUG
curl_setopt($ch, CURLOPT_VERBOSE, true);
$verbose = fopen('php://temp', 'w+');
curl_setopt($ch, CURLOPT_STDERR, $verbose);


        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER,array('Content-type: application/json'));
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        $headers = [
            'Content-Type:application/json',
            'X-EKP: 0',
        //    'X-Request-ID: 0',
            'Authorization: Basic '.base64_encode("$user:$pass")
        ];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        // grab URL and pass it to the browser
        $a = curl_exec($ch);

if ($a === FALSE) {
    printf("cUrl error (#%d): %s<br>\n", curl_errno($ch),
           htmlspecialchars(curl_error($ch)));
}

rewind($verbose);
$verboseLog = stream_get_contents($verbose);

echo "Verbose information:\n<pre>", htmlspecialchars($verboseLog), "</pre>\n";
$info = curl_getinfo($ch);


        if($a === NULL){
            $info = curl_getinfo($ch);
            $str = sprintf("Took %d seconds to send a request to %s\r\nErrors: %s", 
                    $info['total_time'], $info['url'],
                    print_r(curl_error($ch),true)
            );
            yes_mail_debug($str);
            return false;
        }

        // close cURL resource, and free up system resources
        curl_close($ch);
        return $a;
    }
    
    function wunschpaket_query($user, $pass,$service, $zip, $date = null, $startParcelCenter = 0){
        $ch = curl_init();
        $date_str = ($date !== null) ? sprintf('?startDate=%s',$date) : '';
        $startParcelCenter_str = ($startParcelCenter > 0) ? '&startParcelCenter='.$startParcelCenter : '';
        // set URL and other appropriate options
        $test = main::isDev(); // irrelevant
	$ekp = ($test) ? '0' : MODULE_SHIPPING_DHLGKAPI_EKP;
	$curl_url = sprintf('https://cig.dhl.de/services/%s/rest/checkout/%d/%s%s%s',
		($test) ? 'sandbox' : 'production',
                $zip,
                $service,
                $date_str,
                $startParcelCenter_str
        );
//printf('user %s / pass %s / EKP: %s<br />URL: %s',$user, $pass,$ekp, $curl_url);
        curl_setopt($ch, CURLOPT_URL, $curl_url);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER,array('Content-type: application/json'));
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        $headers = [
            'Content-Type:application/json',
            'X-EKP: '.$ekp,
            'Authorization: Basic '.base64_encode("$user:$pass")
        ];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        // grab URL and pass it to the browser
        $a = curl_exec($ch);
        $response = json_decode($a);
        if(isset($response->statusCode) and stristr($response->statusText,'error')){
            return false;
        }
        if($a === NULL){
            $info = curl_getinfo($ch);
            $str = sprintf("Took %d seconds to send a request to %s\r\nErrors: %s", 
                    $info['total_time'], $info['url'],
                    print_r(curl_error($ch),true)
            );
            yes_mail_debug($str);
            return false;
        }

        // close cURL resource, and free up system resources
        curl_close($ch);
        return $a;
    }
    
    function get_wunschpaket_checkout_html($zip = '25469', $defaults = array()){
        if($this->enabled === false){
            return null;
        }
            if(strlen($zip) != 5){
                return 'PLZ ist nicht valid';
            }
        $cache_key = sprintf('WUNSCHPAKET_SERVICES_%s',$zip);
        $er = error_reporting();
        error_reporting(E_ERROR);
        $CachedString_WUNSCHPAKET_SERVICES = $this->InstanceCache->getItem($cache_key);
        error_reporting($er);
        if (is_null($CachedString_WUNSCHPAKET_SERVICES->get())) {
            $a = $this->wunschpaket_call('availableServices',$zip, date('Y-m-d'));
            if($a !== false){
                $CachedString_WUNSCHPAKET_SERVICES->set($a)->expiresAfter(60*60); // 1 std
                $this->InstanceCache->save($CachedString_WUNSCHPAKET_SERVICES); // Save the cache item just like you do with doctrine and entities
            }else{
                $a = [];
            }
        }else{
            $a = $CachedString_WUNSCHPAKET_SERVICES->get();
        }
        $b = $this->wunschpaket_call('deliveryDayEstimation',$zip, date('Y-m-d'),1);
        return $this->parseWunschpaketCheckoutResponse(
                json_decode($a),
                json_decode($b),
                $zip,
                $defaults
        );
    }
    
    private function getPreferredDaySelect($days){
        $strs = [];
        if(!is_array($days) or !sizeOf($days)){
            return $strs;
        }
        foreach($days as $day){
            $strs[] = array('id'=>$day->start,'text'=> xtc_date_short($day->start));
        }
        return $strs;
    }
    
    private function getSameDaySelect($days){
        $strs = [];
        if(!is_array($days) or !sizeOf($days)){
            return $strs;
        }
        foreach($days as $day){
            $strs[] = array('id'=>$day->code, 'text'=>$day->start.' - '.$day->end.' ('.$day->DenselyPopulatedAreaName.')');
        }
        return $strs;
    }
    
    private function getPreferredTimeSelect($times){
        $strs = [];
        if(!is_array($times) or !sizeOf($times)){
            return $strs;
        }
        foreach($times as $time){
            $strs[] = array('id'=>$time->code,'text'=>$time->start.' - '. $time->end);
        }
        return $strs;
    }
    
    private function parseWunschpaketCheckoutResponse($response, $deliveryDayResponse, $zip, $defaults=array()){
        $template = DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/module/checkout_dhl_wunschpaket.html';
        if(!is_file($template) or ! is_readable($template)){
            return sprintf('Error: Template %s not exists',basename($template));
        }
        $days = $this->getPreferredDaySelect($response->preferredDay->validDays);
        $times = $this->getPreferredTimeSelect($response->preferredTime->timeframes);
        $sameday = $this->getSameDaySelect($response->sameDayDelivery->sameDayTimeframes);
        $smarty = new yesSmarty;
        
        $street = '';
        $streetNo = '';
        $str_parts = explode(' ',$this->order->delivery['street_address']);
        if(sizeOf($str_parts)>1){
            $streetNo = $str_parts[ sizeOf($str_parts)-1 ];
            for($i=0;$i<sizeOf($str_parts)-1;$i++){
                $street .= $str_parts[$i].' ';
            }
        }
        
        $smarty->assign(array(
            'estimatedDeliveryDay'=>xtc_date_short($deliveryDayResponse->estimatedDeliveryDay->start),
            'preferredLocation'=>$response->preferredLocation->available,
            'preferredNeighbour'=>$response->preferredNeighbour->available,
            'noNeighbourDelivery'=>$response->noNeighbourDelivery->available,
            'inCarDelivery'=>$response->inCarDelivery->available,
            'preferredDay'=>$response->preferredDay->available,
            'days'=>$days,
            'preferredTime'=>$response->preferredTime->available,
            'times'=>$times,
            'sameDayDelivery'=>$response->sameDayDelivery->available,
            'samedays'=>$sameday,
            'ZIP'=>$zip,
            'STREET'=>$street,
            'STREETNO'=>$streetNo,
            'DEFAULTS'=>$defaults,
            'SAVED_DHL_POSTFILIALE'=>(isset($_SESSION['dhl_postfiliale'])) ? $_SESSION['dhl_postfiliale'] : []
        ));
        return $smarty->fetch($template);
    }
    
    // existiert bereits eine shipments_id, das heisst wurden die daten schon
    // an die dhlgkapi gesendet?
    function shipment_id_exists($orders_id){
        $query = yes_query(
                "SELECT status FROM shippings WHERE orders_id=:orders_id",
                ['orders_id'=>(int)$orders_id]
        );
        if(!sizeOf($query)){
            return false;
        }
        $record = current($query);
        return ($record['status'] == 0) ? false : true;
    }
    
    function get_saved_wunschpaket_data_from_orders_id($orders_id){
        $query = yes_query(
                "SELECT * FROM orders_dhl_paketsteuerung WHERE orders_id=:orders_id",
                ['orders_id'=>(int)$orders_id]
        );
        if(!sizeOf($query)){
            return [];
        }
        return current($query);
    }
    
    function get_wunschpaket_account_html($orders_id, $zip){
        $data = $this->get_saved_wunschpaket_data_from_orders_id($orders_id);
        return $this->get_wunschpaket_checkout_html($zip, $data);
    }
    
    
    function check() {
        if (!isset($this->_check)) {
            $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_DHLGKAPI_STATUS'");
            $this->_check = xtc_db_num_rows($check_query);
        }
        return $this->_check;
    }



    function install() {

        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_SHIPPING_DHLGKAPI_STATUS', 'True', '6', '0', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_ALLOWED', '', '6', '0', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_SORT_ORDER', '0', '6', '0', now())");


        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_SHIPPING_DHLGKAPI_EMAIL_ENABLED', 'True', '6', '0', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_SHIPPING_DHLGKAPI_DHL_EMAIL_ENABLED', 'False', '6', '0', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_EKP', '', '6', '0', now())"); 
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_USER', '', '6', '0', now())"); 
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_PASSWORD', '', '6', '0', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_SHIPPER_NAME', '', '6', '0', now())");                    
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_SHIPPER_STREETNAME', '', '6', '0', now())");                    
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_SHIPPER_STREETNUMBER', '', '6', '0', now())");                    
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_SHIPPER_ZIP', '', '6', '0', now())");                    
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_SHIPPER_CITY', '', '6', '0', now())");                    
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_SHIPPER_COUNTRY', '".$this->store_country['countries_iso_code_3']."', '6', '0', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_CONTACT_PERSON', '', '6', '0', now())");                    
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_CONTACT_EMAIL', '', '6', '0', now())");                    
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_CONTACT_PHONE', '', '6', '0', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_SHIPPING_DHLGKAPI_RETURN_ENABLED', 'True', '6', '0', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_RETURN_NAME', '', '6', '0', now())");                    
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_RETURN_STREETNAME', '', '6', '0', now())");                    
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_RETURN_STREETNUMBER', '', '6', '0', now())");                    
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_RETURN_ZIP', '', '6', '0', now())");                    
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_RETURN_CITY', '', '6', '0', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_RETURN_COUNTRY', '".$this->store_country['countries_iso_code_3']."', '6', '0', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_SHIPPING_DHLGKAPI_COD_ENABLED', 'True', '6', '0', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_COD_PAYMENT_MODULE', 'cod', '6', '0', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_COD_DHL_FEE', '2', '6', '0', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_BANKDATA_ACCOUNTOWNER', '', '6', '0', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_BANKDATA_BANKNAME', '', '6', '0', now())");                        
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_BANKDATA_IBAN', '', '6', '0', now())");                    
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_DHLGKAPI_BANKDATA_BIC', '', '6', '0', now())");                                       
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_SHIPPING_DHLGKAPI_PARCELOUTLETROUTING_ENABLED', 'False', '6', '60', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
        xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (`configuration_key`, `configuration_value`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) VALUES ('MODULE_SHIPPING_DHLGKAPI_TEILNAHME', '', '6', '50', '', '2024-03-02 19:11:24', 'yes_dhlgkapi_teilnahme_config_get', 'yes_dhlgkapi_teilnahme_config_save(')");
        
        
        // START SORTIERUNG 100, EIGENE
        // MANUELL EINFUEGEN: 
        //DELETE FROM configuration WHERE configuration_key='MODULE_SHIPPING_DHLGKAPI_SPERRGUT_YES_PACKAGINGS_ID';
        //insert into configuration (configuration_key, configuration_value, configuration_group_id, sort_order, use_function, set_function,date_added) values ('MODULE_SHIPPING_DHLGKAPI_SPERRGUT_YES_PACKAGINGS_ID', '0', '6', '200', 'yes_get_packaging_name', 'xtc_cfg_pull_down_packagings(',now());
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, use_function, set_function,date_added) values ('MODULE_SHIPPING_DHLGKAPI_SPERRGUT_YES_PACKAGINGS_ID', '0', '6', '200', 'yes_get_packaging_name', 'xtc_cfg_pull_down_packagings(',now())");


    }

    function remove() {
        xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
//        xtc_db_query("alter table " . TABLE_ADMIN_ACCESS . " drop dhlgkapi_print_label");
    }

    function keys() {
        $keys =array ('MODULE_SHIPPING_DHLGKAPI_STATUS',
            'MODULE_SHIPPING_DHLGKAPI_ALLOWED', 
            'MODULE_SHIPPING_DHLGKAPI_SORT_ORDER',
            'MODULE_SHIPPING_DHLGKAPI_EMAIL_ENABLED',
            'MODULE_SHIPPING_DHLGKAPI_DHL_EMAIL_ENABLED',
            'MODULE_SHIPPING_DHLGKAPI_EKP',
            'MODULE_SHIPPING_DHLGKAPI_USER',
            'MODULE_SHIPPING_DHLGKAPI_PASSWORD',
            'MODULE_SHIPPING_DHLGKAPI_SHIPPER_NAME',
            'MODULE_SHIPPING_DHLGKAPI_SHIPPER_STREETNAME',
            'MODULE_SHIPPING_DHLGKAPI_SHIPPER_STREETNUMBER',
            'MODULE_SHIPPING_DHLGKAPI_SHIPPER_ZIP',
            'MODULE_SHIPPING_DHLGKAPI_SHIPPER_CITY',
            'MODULE_SHIPPING_DHLGKAPI_SHIPPER_COUNTRY',
            'MODULE_SHIPPING_DHLGKAPI_CONTACT_PERSON',
            'MODULE_SHIPPING_DHLGKAPI_CONTACT_EMAIL',
            'MODULE_SHIPPING_DHLGKAPI_CONTACT_PHONE',
            'MODULE_SHIPPING_DHLGKAPI_RETURN_ENABLED',
            'MODULE_SHIPPING_DHLGKAPI_RETURN_NAME',
            'MODULE_SHIPPING_DHLGKAPI_RETURN_STREETNAME',
            'MODULE_SHIPPING_DHLGKAPI_RETURN_STREETNUMBER',
            'MODULE_SHIPPING_DHLGKAPI_RETURN_ZIP',
            'MODULE_SHIPPING_DHLGKAPI_RETURN_CITY',
            'MODULE_SHIPPING_DHLGKAPI_RETURN_COUNTRY',
            'MODULE_SHIPPING_DHLGKAPI_COD_ENABLED',
            'MODULE_SHIPPING_DHLGKAPI_COD_PAYMENT_MODULE',
            'MODULE_SHIPPING_DHLGKAPI_COD_DHL_FEE',
            'MODULE_SHIPPING_DHLGKAPI_BANKDATA_ACCOUNTOWNER',
            'MODULE_SHIPPING_DHLGKAPI_BANKDATA_BANKNAME',    
            'MODULE_SHIPPING_DHLGKAPI_BANKDATA_IBAN',
            'MODULE_SHIPPING_DHLGKAPI_BANKDATA_BIC',
            'MODULE_SHIPPING_DHLGKAPI_SPERRGUT_YES_PACKAGINGS_ID',
            'MODULE_SHIPPING_DHLGKAPI_PARCELOUTLETROUTING_ENABLED',
            'MODULE_SHIPPING_DHLGKAPI_TEILNAHME'
        );
        return $keys;
    }

}

