<?php
/*------------------------------------------------------------------------------
   $Id: password_double_opt.php,v 1.0 

   XTC-NEWSLETTER_RECIPIENTS RC1 - Contribution for XT-Commerce http://www.xt-commerce.com
   by Matthias Hinsche http://www.gamesempire.de

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce www.oscommerce.com 
   (c) 2003  nextcommerce www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

require('includes/application_top.php');
$captcha_lang = (isset($_SESSION['language']) and $_SESSION['language'] == 'english') ? 'english' : 'german';
require_once(DIR_WS_CLASSES.'yesCaptcha.php');
$captcha = new yesTextCaptcha($captcha_lang);

if(defined('MODULE_OTHER_TURNSTILE_STATUS') and constant('MODULE_OTHER_TURNSTILE_STATUS') == 'True'){
    require_once(DIR_WS_MODULES.'other/turnstile.php');
    require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/other/turnstile.php');
    $turnstile = true;
    $turnstile_class = new \turnstile();
}

$smarty = new yesSmarty;
$YesBoxes->load( $smarty, basename(__FILE__) );

                
// include needed functions
require_once(DIR_FS_INC . 'xtc_image_button.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_radio_field.inc.php');
require_once(DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
require_once(DIR_FS_INC . 'xtc_render_vvcode.inc.php');
require_once(DIR_FS_INC . 'xtc_random_charcode.inc.php');
require_once(DIR_FS_INC . 'xtc_encrypt_password.inc.php');
require_once(DIR_FS_INC . 'xtc_validate_password.inc.php');
require_once(DIR_FS_INC . 'xtc_rand.inc.php');
$case= 'double_opt';
$info_message = TEXT_PASSWORD_FORGOTTEN;
if (isset($_GET['action']) && ($_GET['action'] == 'first_opt_in')) {
    $vlcode = xtc_random_charcode(32);

    // assign language to template for caching
    $smarty->assign('language', $_SESSION['language']); 
    $smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
    $smarty->assign('logo_path',HTTP_SERVER.DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');
    $smarty->assign('STORE_NAME_ADDRESS',STORE_NAME_ADDRESS);
    // dont allow cache
    $smarty->caching = false;
    if(!isset($_POST['email']) or empty($_POST['email'])){
        xtc_redirect(xtc_href_link('index.php?error_message=Fehlende%20Emailadresse'));
    }
    $cust = \YES4Trade\Model\customers::get_by_email_address($_POST['email']);
    if($cust !== null){
        $check_customer = $cust->toArray();
        $link = xtc_href_link(FILENAME_PASSWORD_DOUBLE_OPT, 'action=verified&customers_id='.$check_customer['customers_id'].'&key='.$vlcode, 'NONSSL');
        $smarty->assign('EMAIL',$_POST['email']);
        $smarty->assign('LINK',$link);
        
        $smarty->assign('CUSTOMERS_LASTNAME',$check_customer['customers_lastname']);
        $smarty->assign('CUSTOMERS_FIRSTNAME',$check_customer['customers_firstname']);
        // create mails
        $html_mail=$smarty->fetch(CURRENT_TEMPLATE.'/mail/'.$_SESSION['language'].'/password_verification_mail.html');
        $txt_mail=$smarty->fetch(CURRENT_TEMPLATE.'/mail/'.$_SESSION['language'].'/password_verification_mail.txt');
        if(!$turnstile){
            $msg = $captcha->check(false); // false = _POST
            if(isset($_POST['captcha_result'])){
                $captcha_success = ($msg == $captcha->lng['captcha_incorrect']) ? false : true;
            }else{
                if(!isset($_SESSION['vvcode']) or empty($_SESSION['vvcode'])){
                    $captcha_success = false;    		
                }else{
                    $captcha_success = $_POST['vvcode'] == $_SESSION['vvcode'];
                }
            }
        }else{
            $captcha_success = false;
            if($turnstile_class->verify()){
                $captcha_success = true;
            }
        }
        if($captcha_success){
            $case = 'first_opt_in';
            $upd = new \YES4Trade\Model\customers([
                'customers_id'=>$check_customer['customers_id'],
                'password_request_key'=>$vlcode
            ]);
            $upd->update();
            if(!main::isDev(true)){
                xtc_php_mail(EMAIL_SUPPORT_ADDRESS, EMAIL_SUPPORT_NAME, $_POST['email'], '', '', EMAIL_SUPPORT_REPLY_ADDRESS, EMAIL_SUPPORT_REPLY_ADDRESS_NAME, '', '', TEXT_EMAIL_PASSWORD_FORGOTTEN, $html_mail, $txt_mail);
            }else{
                echo $html_mail;
            }
        } else { 
            $case = 'code_error';
            if(!$turnstile){
                $info_message = TEXT_CODE_ERROR;
            }else{
                $info_message = TEXT_CAPTCHA_FAILED;
            }
        }
    }else{
        $case = 'wrong_mail';
        $info_message = TEXT_EMAIL_ERROR;                          
    }
}


    // Verification
if (isset($_GET['action']) && ($_GET['action'] == 'verified')) {
    if(isset($_GET['key']) and !empty($_GET['key']) and isset($_GET['customers_id']) and intval($_GET['customers_id']) > 0 ){
        $cust = \YES4Trade\Model\customers::get_by_customers_id_and_password_request_key(
            (int)$_GET['customers_id'], $_GET['key']
        );
    }
    if ($cust === null) {
        $case = 'no_account';
        $info_message = TEXT_NO_ACCOUNT;
    }else{
        $check_customer = $cust->toArray();
        $newpass = xtc_create_random_value(ENTRY_PASSWORD_MIN_LENGTH);
        $crypted_password = xtc_encrypt_password($newpass);
        $upd = new \YES4Trade\Model\customers([
            'customers_password' => $crypted_password,
            'password_request_key'=>'',
            'customers_id'=>$check_customer['customers_id']
        ]);
        $upd->update();
        // assign language to template for caching
        $smarty->assign('language', $_SESSION['language']); 
        $smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
        $smarty->assign('logo_path',HTTP_SERVER.DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');
        // assign vars
        $smarty->assign('STORE_NAME_ADDRESS',STORE_NAME_ADDRESS);

        $smarty->assign('EMAIL',$check_customer['customers_email_address']);
        $smarty->assign('NEW_PASSWORD',$newpass);
        // dont allow cache
        $smarty->caching = false;     
        // create mails
        $html_mail=$smarty->fetch(CURRENT_TEMPLATE.'/mail/'.$_SESSION['language'].'/new_password_mail.html');
        $txt_mail=$smarty->fetch(CURRENT_TEMPLATE.'/mail/'.$_SESSION['language'].'/new_password_mail.txt');
        if(!main::isDev(true)){
            xtc_php_mail(EMAIL_SUPPORT_ADDRESS, EMAIL_SUPPORT_NAME, $check_customer['customers_email_address'], '', '', EMAIL_SUPPORT_REPLY_ADDRESS, EMAIL_SUPPORT_REPLY_ADDRESS_NAME, '', '', TEXT_EMAIL_PASSWORD_NEW_PASSWORD, $html_mail, $txt_mail);    
        }else{
            echo $html_mail;exit;
        }
        if (!isset($mail_error)) {
              xtc_redirect(xtc_href_link(FILENAME_LOGIN, 'info_message=' . urlencode(TEXT_PASSWORD_SENT), 'SSL', true, false)); 
        }
    }
}

$ssl_mode = empty($_SERVER['HTTPS']) ? 'NONSSL' : 'SSL';
$breadcrumb->add(NAVBAR_TITLE_PASSWORD_DOUBLE_OPT, xtc_href_link(FILENAME_PASSWORD_DOUBLE_OPT, '', 'NONSSL'));

require(DIR_WS_INCLUDES . 'header.php');

switch ($case) {
case 'first_opt_in':
    $smarty->assign('text_heading', HEADING_PASSWORD_FORGOTTEN);
    if(!empty($info_message)){
        $smarty->assign('info_message', $info_message);
    }else{
        $smarty->assign('info_message', TEXT_LINK_MAIL_SENDED);
    }
    $smarty->assign('language', $_SESSION['language']);
    $smarty->caching = 0;
    $main_content=$smarty->fetch(CURRENT_TEMPLATE . '/module/password_messages.html');
    break;
case 'second_opt_in':
    $smarty->assign('text_heading', HEADING_PASSWORD_FORGOTTEN);
    $smarty->assign('info_message', $info_message);
//    $smarty->assign('info_message', TEXT_PASSWORD_MAIL_SENDED);
    $smarty->assign('language', $_SESSION['language']);
    $smarty->caching = 0;
    $main_content=$smarty->fetch(CURRENT_TEMPLATE . '/module/password_messages.html');
   break;
case 'code_error':
    $smarty->assign(array(
        'VVIMG'=>(!$turnstile)?'<img src="' . main::get_url_with_random_params(FILENAME_DISPLAY_VVCODES) . '">':'',
        'YES_CAPTCHA'=>($turnstile)?$turnstile_class->create():$captcha->create(),
        'text_heading'=>HEADING_PASSWORD_FORGOTTEN,
        'info_message'=>$info_message,
        'message'=>TEXT_PASSWORD_FORGOTTEN,
        'SHOP_NAME'=>STORE_NAME,
        'FORM_ACTION'=>xtc_draw_form('sign', xtc_href_link(FILENAME_PASSWORD_DOUBLE_OPT, 'action=first_opt_in',$ssl_mode)),
        'INPUT_EMAIL'=>xtc_draw_input_field('email', $_POST['email']),
        'INPUT_CODE'=>(!$turnstile)?xtc_draw_input_field('vvcode','','size="6" maxlenght="6"',false,'',false):'',
        'BUTTON_SEND'=>xtc_image_submit('button_send.gif', IMAGE_BUTTON_LOGIN),
        'language'=>$_SESSION['language']
    ));
    $smarty->caching = 0;
    $main_content=$smarty->fetch(CURRENT_TEMPLATE . '/module/password_double_opt_in.html');
   break;
case 'wrong_mail':
    $smarty->assign(array(
        'VVIMG'=>(!$turnstile)?'<img src="' . main::get_url_with_random_params(FILENAME_DISPLAY_VVCODES) . '">':'',
        'text_heading'=>HEADING_PASSWORD_FORGOTTEN,
        'info_message'=> $info_message,
        'message'=>TEXT_PASSWORD_FORGOTTEN,
        'SHOP_NAME'=>STORE_NAME,
        'FORM_ACTION'=>xtc_draw_form('sign', xtc_href_link(FILENAME_PASSWORD_DOUBLE_OPT, 'action=first_opt_in', $ssl_mode)),
        'INPUT_EMAIL'=>xtc_draw_input_field('email', $_POST['email']),
        'INPUT_CODE'=>(!$turnstile)?xtc_draw_input_field('vvcode','','size="6" maxlenght="6"',false,'',false):'',
        'BUTTON_SEND'=>xtc_image_submit('button_send.gif', IMAGE_BUTTON_LOGIN),
        'YES_CAPTCHA'=>($turnstile)?$turnstile_class->create():$captcha->create(),
        'language'=>$_SESSION['language']
    ));
    $smarty->caching = 0;
    $main_content=$smarty->fetch(CURRENT_TEMPLATE . '/module/password_double_opt_in.html'); 
    break; 
case 'no_account': 
    $smarty->assign('text_heading', HEADING_PASSWORD_FORGOTTEN);
    $smarty->assign('info_message', $info_message);
    $smarty->assign('language', $_SESSION['language']);
    $smarty->caching = 0;
    $main_content=$smarty->fetch(CURRENT_TEMPLATE . '/module/password_messages.html');
    break;        
case 'double_opt':
    $smarty->assign(array(
        'YES_CAPTCHA'=>($turnstile)?$turnstile_class->create():$captcha->create(),
        'VVIMG'=>(!$turnstile)?'<img src="' . main::get_url_with_random_params(FILENAME_DISPLAY_VVCODES) . '">':'',
        'text_heading'=>HEADING_PASSWORD_FORGOTTEN,
        'message'=>TEXT_PASSWORD_FORGOTTEN,
        'SHOP_NAME'=>STORE_NAME,
        'FORM_ACTION'=>xtc_draw_form('sign', xtc_href_link(FILENAME_PASSWORD_DOUBLE_OPT, 'action=first_opt_in',$ssl_mode)),
        'INPUT_EMAIL'=>xtc_draw_input_field('email', $_POST['email']),
        'INPUT_CODE'=>(!$turnstile)?xtc_draw_input_field('vvcode','','size="6" maxlenght="6"',false,'',false):'',
        'BUTTON_SEND'=>xtc_image_submit('button_continue.gif', IMAGE_BUTTON_LOGIN),
        'language'=>$_SESSION['language']
    ));
    $smarty->caching = 0;
    $main_content=$smarty->fetch(CURRENT_TEMPLATE . '/module/password_double_opt_in.html');
    break;  
}

$smarty->assign(array(
    'FORM_END'=>'</form>',
    'main_content'=>$main_content,
    'language'=>$_SESSION['language'],
));
$smarty->caching = 0;
if (!defined('RM')) {
    $smarty->load_filter('output', 'note'); 
}
$smarty->display(CURRENT_TEMPLATE . '/index.html');
include ('includes/application_bottom.php');
