<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                              Author M. ASPELEITER <dazze@gmx.de
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

/**
  * WAS MUSS PASSIEREN?
  * Tabelle 'orders' aktualisieren mit der neuen Bezahlart
  * Tabelle 'orders' aktualisieren mit der Versandadresse
  * Notiz anlegen falls 'buyer_message' gefüllt ist
**/
ob_start();
require_once(DIR_WS_CLASSES . 'ebay_order.php');
require_once (DIR_FS_INC.'yes_write_notice.inc.php');
function _get_country_name_from_code($iso_code){
	$countryname_query = xtc_db_query("SELECT countries_name FROM countries WHERE countries_iso_code_2='".$iso_code."'");
	$countryname = xtc_db_fetch_array($countryname_query);
	return $countryname['countries_name'];
}
function strip_cdata($string) {
    preg_match_all('/<!\[cdata\[(.*?)\]\]>/is', $string, $matches);
    return str_replace($matches[0], $matches[1], $string);
}

$item = $SOAP->root['GetItemTransactionsResponse']['Item'];
$TransactionArray = $SOAP->root['GetItemTransactionsResponse']['TransactionArray'];
$Transaction = $TransactionArray['Transaction'];

// BOF - verhindern das Notizen an admin versendet werden in der nur die Mail steht
$SellerEmail = $SOAP->root['GetItemTransactionsResponse']['Item']['Seller']['Email']['value'];
// EOF - verhindern das Notizen an admin versendet werden in der nur die Mail steht






function get_amt_str_from_ebay_transaction_data($element){
	return sprintf('%s %s',
		$element['value'],
		$element['attr']['currencyID']
	);
}
function get_address_string_from_ebay_address_data( $element ){
    $street = (isset($element['Street']['value']) and $element['Street']['value'] != '')  ? $element['Street']['value'] : $element['Street1']['value'] . ' '.$element['Street2']['value'];
	$tel = (isset($element['Phone']) and $element['Phone']['value'] != '' and $element['Phone']['value'] != 'Invalid Request') ? $element['Phone']['value'] : '';
	return trim(sprintf(
		'%s, %s, %s %s (%s) %s',
		$element['Name']['value'],
		$street,
		$element['PostalCode']['value'],
		$element['CityName']['value'],
		$element['Country']['value'],
		$tel
	));
}

function get_shipping_info_from_ebay_transaction_data($element){
	return sprintf(
		'Versandart %s, Betrag %s, Versanddauer %s - %s Tage',
		$element['ShippingService']['value'],
		get_amt_str_from_ebay_transaction_data($element['ShippingServiceCost']),
		$element['ShippingTimeMin']['value'],
		$element['ShippingTimeMax']['value']
	);
}

function get_transactionstatus_from_ebay_transaction_data($element){
	return sprintf(
		'eBay Checkoutstatus "%s", verw. Bezahlart "%s", Paymentstatus: "%s"',
		$element['CheckoutStatus']['value'],
		$element['PaymentMethodUsed']['value'],
		$element['CompleteStatus']['value']
	);
}

function get_ext_transactioninfo_from_ebay_transaction_data($element){
    if(!isset($element['ExternalTransactionID']['value']) or $element['ExternalTransactionID']['value'] == ''){
        return '- Keine Informationen -';
    }
	return sprintf(
		'ExternalTransactionID: %s, FeeOrCreditAmount: %s, PaymentOrRefundAmount: %s',
		$element['ExternalTransactionID']['value'],
		get_amt_str_from_ebay_transaction_data($element['FeeOrCreditAmount']),
		get_amt_str_from_ebay_transaction_data($element['PaymentOrRefundAmount'])
	);
}

$trans_reg_address_str = get_address_string_from_ebay_address_data($Transaction['Buyer']['RegistrationAddress']);
$trans_ship_address_str = get_address_string_from_ebay_address_data($Transaction['Buyer']['BuyerInfo']['ShippingAddress']);
$address_info_string = sprintf(
	'eBay User "%s" (Bewertung %s)<br />Adresse Registr.: %s<br />Adresse Versand: %s<br />Versandinfo: %s<br />Transaktionsstatus: %s<br />%s',
	$Transaction['Buyer']['UserID']['value'],
	$Transaction['Buyer']['PositiveFeedbackPercent']['value'],
	$trans_reg_address_str,
	$trans_ship_address_str,
	get_shipping_info_from_ebay_transaction_data($Transaction['ShippingDetails']['ShippingServiceOptions']),
	get_transactionstatus_from_ebay_transaction_data($Transaction['Status']),
	get_ext_transactioninfo_from_ebay_transaction_data($Transaction['ExternalTransaction'])
);

$ship_address = $Transaction['Buyer']['BuyerInfo']['ShippingAddress'];

// get orders_id
$order_query = yes_db_query(sprintf(
	"SELECT orders_id,products_id FROM ebay_transactions WHERE ebayid='%s' and transactionid='%s'",
	$item['ItemID']['value'],
	$Transaction['TransactionID']['value']
));

// WENN DIE GEMELDETE TRANSAKTION NICHT EXISTIERT WIRD EINE EMAIL
// MIT DEN DEBUGDATEN VERSENDET
if(!yes_db_num_rows($order_query)){
    $txt = "AuctionCheckoutComplete unbekannte Auktion\r\n";
    ob_start();
    print_r($Transaction);
    $txt .= ob_get_contents();
    ob_end_clean();
// artet in Spam aus - Stichprobenartig geprueft, Meldung ist nicht wichtig
//    mail('m.aspeleiter@yes-websolutions.de',basename(__FILE__).' '.STORE_NAME,$txt);
    die($txt);
}

$order = current($order_query);
$orders_id = $order['orders_id'];
$products_id = $order['products_id'];

$query = xtc_db_query(sprintf(
        "SELECT orders_status,currency,billing_company,billing_name,combined_orders_id FROM orders WHERE orders_id='%s'",
        $orders_id
));
$record = xtc_db_fetch_array($query);

$billing_str = $record['billing_name'];
if($record['billing_company'] != ''){
    $billing_str = $record['billing_company'].' '.$record['billing_name'];
}

$currency = $record['currency'];
switch($record['orders_status']){
        case ORDERS_STATUS_UPSELLING:
        case ORDERS_STATUS_BEZAHLT:
                // nix
                break;
        default:
                $mail_header = array(
                    "MIME-Version: 1.0",
                    "Content-type: text/html; charset=".CHARSET,
                    'X-Mailer: PHP/' . phpversion()
                );
                //mail('m.aspeleiter@yes-websolutions.de',basename(__FILE__).' '.substr(STORE_NAME,0,15),yes_decode_string($address_info_string),implode("\r\n",$mail_header));
                require_once(DIR_FS_CATALOG.'lang/german/german.php');
                $rec_array = array();
                $admin_access_query = xtc_db_query("SELECT customers_id FROM admin_access WHERE orders=1");
                while($admin_access = xtc_db_fetch_array($admin_access_query)){
                        $rec_array[] = $admin_access['customers_id'];
                }
                $notice_text = sprintf(TEXT_EBAY_SOAP_AUCTIONCHECKOUTCOMPLETE_NOTICE_TEXT,'<a href="'.xtc_href_link(FILENAME_ORDERS,'action=edit&oID='.$orders_id).'">'.$orders_id.'</a>');
                $notice_text .= '<br /><hr noshade="noshade" />'.$address_info_string;
                if(strtolower($Transaction['Status']['PaymentMethodUsed']['value']) == 'paypal'){
                    $PP_transactionID = $Transaction['ExternalTransaction']['ExternalTransactionID']['value'];
                    $PP_amount = $Transaction['ExternalTransaction']['PaymentOrRefundAmount']['value'];
                    $update_sql_array = array(
                        'payment_transaction_id'=>$PP_transactionID,
                        'last_modified'=>'now()'
                    );
                    xtc_db_perform(TABLE_ORDERS,$update_sql_array,'update',"orders_id='".$orders_id."'");
                    $hist_text = sprintf(TEXT_EBAY_SOAP_AUCTIONCHECKOUTCOMPLETE_NOTICE_TEXT,$orders_id);
                    $hist_text .= '<br /><hr noshade="noshade" />'.yes_decode_string($address_info_string);
                    $insert_sql_array = array(
                        'orders_id'=>$orders_id,
                        'orders_status_id'=>$record['orders_status'],
                        'date_added'=>'now()',
                        'customer_notified'=>0,
                        'comments'=>$hist_text,
                        'editor_id'=>0
                    );
                    xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY,$insert_sql_array);
                    
		    $insert_sql_array = array(
			'betrag'=>$PP_amount,
			'waehrung'=>$Transaction['ExternalTransaction']['PaymentOrRefundAmount']['attr']['currencyID'],
			'buchungstag'=>date('d.m.Y'),
			'bankleitzahl'=>'',
			'kontonummer'=>'',
			'name'=>(($trans_reg_address_str != '') ? yes_decode_string($trans_reg_address_str) : yes_decode_string($trans_ship_address_str)),
			'verwendungszweck1'=>'Paypal Transaktion '.$PP_transactionID,
			'confirmed'=>1,
			'sorting'=>0,
			'buchungstag_date'=>date('Y-m-d')
		    );
		    xtc_db_perform('incoming_payments',$insert_sql_array);
		    $payment_id = xtc_db_insert_id();
		    $insert_sql_array = array(
			'payment_id'=>$payment_id,
			'orders_id'=>$orders_id,
			'created'=>'now()'
		    );
		    xtc_db_perform('payment_orders',$insert_sql_array);
                }
                yes_write_notice(sprintf(TEXT_EBAY_SOAP_AUCTIONCHECKOUTCOMPLETE_NOTICE_TITLE,$orders_id),yes_decode_string($notice_text),0,$rec_array);
                die('invalid orders_status');
                break;
}

$text1 = ''; // zum pruefen
if( isset($Transaction['BuyerCheckoutMessage']['value']) and $Transaction['BuyerCheckoutMessage']['value'] != '' and $Transaction['BuyerCheckoutMessage']['value'] != 'null'){
        $rec_array = array();
        $admin_access_query = xtc_db_query("SELECT customers_id FROM admin_access WHERE ebayapi_cart=1");
        while($admin_access = xtc_db_fetch_array($admin_access_query)){
                $rec_array[] = $admin_access['customers_id'];
        }
        $text = strip_cdata($Transaction['BuyerCheckoutMessage']['value']);
        $text1 = $text; // zum pruefen

        // NUR SPEICHERN WENNS NICHT NUR DIE EMAIL IS
        if(trim(strtolower($text)) != strtolower($SellerEmail)){

                yes_write_notice('eBay K&auml;ufer Nachricht Re-Nr '.$orders_id,$text,0,$rec_array);

                $check_cv_query = xtc_db_query(sprintf(
                        "SELECT comments_visible FROM %s WHERE orders_id='%s'",
                        TABLE_ORDERS,$orders_id
                ));
                if(xtc_db_num_rows($check_cv_query)){
                    $check_cv = xtc_db_fetch_array($check_cv_query);
                    $cv = '';
                    if($check_cv['comments_visible'] != ''){
                        $cv = $check_cv['comments_visible'].' ';
                    }
                    $update_sql_array = array(
                        'comments_visible'=>$cv.$text
                    );
                    xtc_db_perform(TABLE_ORDERS,$update_sql_array,'update',"orders_id='".$orders_id."'");
                }

                $order_history_sql_array = array(
                        'orders_id' => $orders_id,
                        'orders_status_id' => $record['orders_status'],
                        'date_added' => 'now()',
                        'customer_notified' => 0,
                        'comments' => 'eBay Kunde Kommentar: '.$text
                );
                xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY, $order_history_sql_array);
        }
}

if(isset($Transaction['BuyerMessage']['value']) and $Transaction['BuyerMessage']['value'] != '' and $Transaction['BuyerMessage']['value'] != 'null'){
        $text = strip_cdata($Transaction['BuyerMessage']['value']);
        if(trim(strtolower($text)) != strtolower($SellerEmail)){
                $rec_array = array();
                $admin_access_query = xtc_db_query("SELECT customers_id FROM admin_access WHERE ebayapi_cart=1");
                while($admin_access = xtc_db_fetch_array($admin_access_query)){
                        $rec_array[] = $admin_access['customers_id'];
                }
                yes_write_notice('eBay BuyerMessage Re-Nr '.$orders_id,$text,0,$rec_array);
                $order_history_sql_array = array(
                        'orders_id' => $orders_id,
                        'orders_status_id' => $record['orders_status'],
                        'date_added' => 'now()',
                        'customer_notified' => 0,
                        'comments' => 'eBay K&auml;ufer Kommentar: '.$text
                );
                xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY, $order_history_sql_array);
        }
}

/// TESTMODUS - ebay_orders
if(isset($Transaction['ContainingOrder'])){

    $check_query = yes_db_query(sprintf("SELECT ebay_orders_id FROM ebay_orders WHERE OrderID='%s'",
            $Transaction['ContainingOrder']['OrderID']['value']
    ));
    if(yes_db_num_rows($check_query)){
                $check_record = current($check_query);
                $update_sql_array = array(
                        'OrderStatus' => $Transaction['ContainingOrder']['OrderStatus']['value']
                );
                xtc_db_perform('ebay_orders',$update_sql_array,'update',"ebay_orders_id='".$check_record['ebay_orders_id']."'");
                // NEU
                $order_history_sql_array = array(
                        'orders_id' => $orders_id,
                        'orders_status_id' => $record['orders_status'],
                        'date_added' => 'now()',
                        'customer_notified' => 0,
                        'comments' => 'Komb. eBay Order Update Status: '.$update_sql_array['OrderStatus']
                );
                xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY, $order_history_sql_array);
    }else{
                $insert_sql_array = array(
                        'OrderID'=>$Transaction['ContainingOrder']['OrderID']['value'],
                        'OrderStatus' => $Transaction['ContainingOrder']['OrderStatus']['value'],
                        'date_added'=>'now()',
                        'ebay_id'=>$item['ItemID']['value'],
                        'user'=>$SOAP->root['GetItemTransactionsResponse']['Item']['Seller']['UserID']['value'],
                        'transaction_id'=>$Transaction['TransactionID']['value']
                );
                xtc_db_perform('ebay_orders',$insert_sql_array);
                // NEU
                $order_history_sql_array = array(
                        'orders_id' => $orders_id,
                        'orders_status_id' => $record['orders_status'],
                        'date_added' => 'now()',
                        'customer_notified' => 0,
                        'comments' => 'Komb. eBay Order '.$insert_sql_array['OrderID'].' Status: '.$insert_sql_array['OrderStatus']
                );
                xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY, $order_history_sql_array);
    }
}


/**
FUER HISTORIENEINTRAG DIE "ALTE" BEZAHLART ERMITTELN
**/
$query = yes_db_query(sprintf("SELECT orders_status,payment_method,shipping_method FROM orders WHERE orders_id='%s'",
        $orders_id
));
$record = current($query);
if(defined('EBAY_SET_ORDERS_STATUS_BEZAHLT_BY_PAYPAL_PAYMENT') and EBAY_SET_ORDERS_STATUS_BEZAHLT_BY_PAYPAL_PAYMENT == 'True'){
        $new_orders_status = (stristr($Transaction['Status']['PaymentMethodUsed']['value'],'paypal') and $record['orders_status'] != ORDERS_STATUS_STORNIERT and $Transaction['Status']['eBayPaymentStatus']['value'] == 'NoPaymentFailure') ? ORDERS_STATUS_BEZAHLT : $record['orders_status'];
}else{
        $new_orders_status = $record['orders_status'];
        if(stristr($Transaction['Status']['PaymentMethodUsed']['value'],'COD')){
            $new_orders_status = '1';
        }
}

$update_sql_array = array(
        'delivery_name'=>yes_decode_string($ship_address['Name']['value']),
        'delivery_company'=>yes_decode_string($ship_address['Company']['value']),
        'delivery_street_address'=>yes_decode_string($ship_address['Street1']['value']),
        'delivery_suburb'=>yes_decode_string($ship_address['Street2']['value']),
        'delivery_city'=>yes_decode_string($ship_address['CityName']['value']),
        'delivery_postcode'=>yes_decode_string($ship_address['PostalCode']['value']),
        'delivery_state'=>yes_decode_string($ship_address['StateOrProvince']['value']),
        'delivery_country'=>_get_country_name_from_code( $ship_address['Country']['value'] ),
        'payment_method'=>$Transaction['Status']['PaymentMethodUsed']['value'],
        'payment_class'=>$Transaction['Status']['PaymentMethodUsed']['value'],
        'last_modified'=>'now()',
        'orders_status'=>$new_orders_status
);

$allow_check_shipping = true;
if(strtolower($Transaction['Status']['PaymentMethodUsed']['value']) == 'cod'){
        $update_sql_array['shipping_method'] = 'cod_cod';
        $update_sql_array['shipping_class'] = 'cod_cod';
        $allow_check_shipping = false;
        $update_sql_array['orders_status'] = '1';
}
if( !stristr($Transaction['ShippingServiceSelected']['ShippingService']['value'],'customcode') and (stristr($Transaction['ShippingServiceSelected']['ShippingService']['value'],'cod') or stristr($Transaction['ShippingServiceSelected']['ShippingService']['value'],'nachname') ) ){
    if(stristr($Transaction['Status']['PaymentMethodUsed']['value'],'moneyxfer')){
        $update_sql_array['payment_method'] = 'COD';
        $update_sql_array['payment_class'] = 'COD';
        $allow_check_shipping = false;
        $update_sql_array['orders_status'] = '1';
    }
}

// UPDATE SHIPPING METHOD
$order_history_shipping_text = '';
if($allow_check_shipping and $record['shipping_method'] != $Transaction['ShippingServiceSelected']['ShippingService']['value']){
    $update_sql_array['shipping_method'] = $Transaction['ShippingServiceSelected']['ShippingService']['value'];
    $update_sql_array['shipping_class'] = $update_sql_array['shipping_method'];

    $umrechnungskurs = $Transaction['ConvertedTransactionPrice']['value'] / $Transaction['TransactionPrice']['value'];
    $new_shipping_costs = ((float) $Transaction['ShippingServiceSelected']['ShippingInsuranceCost']['value'] + (float)$Transaction['ShippingServiceSelected']['ShippingServiceCost']['value'])*$umrechnungskurs;
    $ot_query = xtc_db_query(sprintf(
           "SELECT value FROM orders_total WHERE orders_id='%s' AND class='ot_shipping'",
            $orders_id
    ));
    $ot = xtc_db_fetch_array($ot_query);
    if( (float) $new_shipping_costs != (float) $ot['value'] ){

        xtc_db_query(sprintf(
            "UPDATE orders_total SET value='%s',text='%s' WHERE orders_id='%s' AND class='ot_shipping'",
            $new_shipping_costs,
            number_format($new_shipping_costs,2,',','.').' '.$currency,
            $orders_id
        ));

        $ot_query = xtc_db_query(sprintf(
                "SELECT SUM(value) as total_value FROM orders_total WHERE orders_id='%s' AND class != 'ot_total' AND class != 'ot_tax'",
                $orders_id
        ));
        $ot = xtc_db_fetch_array($ot_query);

        // BOF - TAX RATE
        $use_dummy_pid = false;
        if($products_id < 1 and defined('EBAY_DEFAULT_DUMMY_PRODUCTS_ID') and EBAY_DEFAULT_DUMMY_PRODUCTS_ID > 0){
                $use_dummy_pid = true;
                $transaction_pID = EBAY_DEFAULT_DUMMY_PRODUCTS_ID;
        }else{
                $transaction_pID = $products_id;
        }

        $tax_query = xtc_db_query(sprintf(
            "SELECT products_tax FROM orders_products WHERE orders_id='%s' AND products_id='%s'",
            $orders_id,$transaction_pID
        ));
        $tax_result = xtc_db_fetch_array($tax_query);
        $tax = $tax_result['products_tax'];
        // EOF - TAX RATE
        $ot_tax_value = $ot['total_value'] - ( $ot['total_value'] / ((100+$tax)/100) );

        xtc_db_query(sprintf(
            "UPDATE orders_total SET value='%s',text='%s' WHERE orders_id='%s' AND class='ot_tax'",
            $ot_tax_value,
            number_format($ot_tax_value,2,',','.').' '.$currency,
            $orders_id
        ));

        xtc_db_query(sprintf(
            "UPDATE orders_total SET value='%s',text='%s' WHERE orders_id='%s' AND class='ot_total'",
            $ot['total_value'],
            number_format($ot['total_value'],2,',','.').' '.$currency,
            $orders_id
        ));
        $order_history_shipping_text = sprintf(
                "\r\nVersandkosten %s (%s)",
                number_format($ot['total_value'],2,',','.').' '.$currency,
                $update_sql_array['shipping_method']
        );
    }
}



xtc_db_perform('orders',$update_sql_array,'update',"orders_id='".$orders_id."'");

$order_history_text = 'SOAP CC: Kunde bezahlte via eBay Payment. Verwendete Bezahlart: '.$Transaction['Status']['PaymentMethodUsed']['value'].' / vorh. Bezahlart: '.$record['payment_method'];

$et = $Transaction['ExternalTransaction'];
if(is_array($et) and sizeOf($et)){
        if( isset($et['ExternalTransactionID']['value']) and $et['ExternalTransactionID']['value'] != ''){
            // BOF - PAYPAL ZAHLUNG IN ZEP 10.09.14
            if($et['ExternalTransactionStatus']['value'] == 'Succeeded' and strtolower($Transaction['Status']['PaymentMethodUsed']['value']) == 'paypal'){
                $insert_sql_array = array(
                    'betrag'=>$et['FinalValueFee']['value'],
                    'waehrung'=>$currency,
                    'buchungstag'=>date('d.m.Y'),
                    'bankleitzahl'=>'',
                    'kontonummer'=>'',
                    'name'=>$billing_str,
                    'verwendungszweck1'=>'Paypal Transaktion '.$et['ExternalTransactionID']['value'],
                    'confirmed'=>1,
                    'sorting'=>0,
                    'buchungstag_date'=>date('Y-m-d')
                );
                xtc_db_perform('incoming_payments',$insert_sql_array);
                $payment_id = xtc_db_insert_id();
                $insert_sql_array = array(
                    'payment_id'=>$payment_id,
                    'orders_id'=>$orders_id,
                    'created'=>'now()'
                );
                xtc_db_perform('payment_orders',$insert_sql_array);
                //mail('m.aspeleiter@yes-websolutions.de','ebay paypal zep succ '.$orders_id,$et['FinalValueFee']['value']);
            }else{
                //mail('m.aspeleiter@yes-websolutions.de','ebay paypal zep fail '.$orders_id,$et['ExternalTransactionStatus']['value']);
            }
            // EOF - PAYPAL ZAHLUNG IN ZEP
            $order_history_text .= " Paypal Transaction ID: ".$et['ExternalTransactionID']['value'];
            xtc_db_query(sprintf(
                    "UPDATE orders SET payment_transaction_id='%s' WHERE orders_id='%s'",
                    $et['ExternalTransactionID']['value'],$orders_id
            ));
        }
}



$insert_sql_array = array(
        'orders_id'=>$orders_id,
        'orders_status_id'=>$new_orders_status,
        'date_added'=>'now()',
        'customer_notified'=>0,
        'comments'=>$order_history_text,
        'editor_id'=>0
);
xtc_db_perform('orders_status_history',$insert_sql_array);


// BOF - REAL SHIPPING COSTS
$order = new order($orders_id);
$order->save_real_shipping_cost();
unset($order);
// EOF - REAL SHIPPING COSTS


// MANCHMAL WIRD DIE VERSANDART BSP COD NICHT UEBERGEBEN
if($Transaction['ShippingServiceSelected']['ShippingService']['value'] != 'CustomCode'){
    xtc_db_query(sprintf(
            "UPDATE ebay_transactions SET checkoutstatus='%s' WHERE ebayid='%s' AND transactionid='%s'",
            $Transaction['Status']['CheckoutStatus']['value'],$item['ItemID']['value'],$Transaction['TransactionID']['value']
    ));
}



$text = ob_get_contents();
ob_end_clean();
exit;
mail('m.aspeleiter@yes-websolutions.de', 'AuctionCheckoutComplete '.date('d.m.Y H:i:s'), $text);


