<?php
/**
 * VendorShippingV1Api
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Retail Procurement Shipments
 *
 * The Selling Partner API for Retail Procurement Shipments provides programmatic access to retail shipping data for vendors.
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Api;

use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use SellingPartnerApi\ApiException;
use SellingPartnerApi\ObjectSerializer;

/**
 * VendorShippingV1Api Class Doc Comment
 *
 * @category Class
 * @package  SellingPartnerApi
 */
class VendorShippingV1Api extends BaseApi
{
    /**
     * Operation getShipmentDetails
     *
     * @param  int $limit The limit to the number of records returned. Default value is 50 records. (optional)
     * @param  string $sort_order Sort in ascending or descending order by purchase order creation date. (optional)
     * @param  string $next_token Used for pagination when there are more shipments than the specified result size limit. (optional)
     * @param  string $created_after Get Shipment Details that became available after this timestamp will be included in the result. Must be in ISO-8601 date/time format. (optional)
     * @param  string $created_before Get Shipment Details that became available before this timestamp will be included in the result. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipment_confirmed_before Get Shipment Details by passing Shipment confirmed create Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipment_confirmed_after Get Shipment Details by passing Shipment confirmed create Date After. Must be in ISO-8601 date/time format. (optional)
     * @param  string $package_label_created_before Get Shipment Details by passing Package label create Date by buyer. Must be in ISO-8601 date/time format. (optional)
     * @param  string $package_label_created_after Get Shipment Details by passing Package label create Date After by buyer. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipped_before Get Shipment Details by passing Shipped Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipped_after Get Shipment Details by passing Shipped Date After. Must be in ISO-8601 date/time format. (optional)
     * @param  string $estimated_delivery_before Get Shipment Details by passing Estimated Delivery Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $estimated_delivery_after Get Shipment Details by passing Estimated Delivery Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipment_delivery_before Get Shipment Details by passing Shipment Delivery Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipment_delivery_after Get Shipment Details by passing Shipment Delivery Date After. Must be in ISO-8601 date/time format. (optional)
     * @param  string $requested_pick_up_before Get Shipment Details by passing Before Requested pickup date. Must be in ISO-8601 date/time format. (optional)
     * @param  string $requested_pick_up_after Get Shipment Details by passing After Requested pickup date. Must be in ISO-8601 date/time format. (optional)
     * @param  string $scheduled_pick_up_before Get Shipment Details by passing Before scheduled pickup date. Must be in ISO-8601 date/time format. (optional)
     * @param  string $scheduled_pick_up_after Get Shipment Details by passing After Scheduled pickup date. Must be in ISO-8601 date/time format. (optional)
     * @param  string $current_shipment_status Get Shipment Details by passing Current shipment status. (optional)
     * @param  string $vendor_shipment_identifier Get Shipment Details by passing Vendor Shipment ID (optional)
     * @param  string $buyer_reference_number Get Shipment Details by passing buyer Reference ID (optional)
     * @param  string $buyer_warehouse_code Get Shipping Details based on buyer warehouse code. This value should be same as 'shipToParty.partyId' in the Shipment. (optional)
     * @param  string $seller_warehouse_code Get Shipping Details based on vendor warehouse code. This value should be same as 'sellingParty.partyId' in the Shipment. (optional)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse
     */
    public function getShipmentDetails($limit = null, $sort_order = null, $next_token = null, $created_after = null, $created_before = null, $shipment_confirmed_before = null, $shipment_confirmed_after = null, $package_label_created_before = null, $package_label_created_after = null, $shipped_before = null, $shipped_after = null, $estimated_delivery_before = null, $estimated_delivery_after = null, $shipment_delivery_before = null, $shipment_delivery_after = null, $requested_pick_up_before = null, $requested_pick_up_after = null, $scheduled_pick_up_before = null, $scheduled_pick_up_after = null, $current_shipment_status = null, $vendor_shipment_identifier = null, $buyer_reference_number = null, $buyer_warehouse_code = null, $seller_warehouse_code = null)
    {
        $response = $this->getShipmentDetailsWithHttpInfo($limit, $sort_order, $next_token, $created_after, $created_before, $shipment_confirmed_before, $shipment_confirmed_after, $package_label_created_before, $package_label_created_after, $shipped_before, $shipped_after, $estimated_delivery_before, $estimated_delivery_after, $shipment_delivery_before, $shipment_delivery_after, $requested_pick_up_before, $requested_pick_up_after, $scheduled_pick_up_before, $scheduled_pick_up_after, $current_shipment_status, $vendor_shipment_identifier, $buyer_reference_number, $buyer_warehouse_code, $seller_warehouse_code);
        return $response;
    }

    /**
     * Operation getShipmentDetailsWithHttpInfo
     *
     * @param  int $limit The limit to the number of records returned. Default value is 50 records. (optional)
     * @param  string $sort_order Sort in ascending or descending order by purchase order creation date. (optional)
     * @param  string $next_token Used for pagination when there are more shipments than the specified result size limit. (optional)
     * @param  string $created_after Get Shipment Details that became available after this timestamp will be included in the result. Must be in ISO-8601 date/time format. (optional)
     * @param  string $created_before Get Shipment Details that became available before this timestamp will be included in the result. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipment_confirmed_before Get Shipment Details by passing Shipment confirmed create Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipment_confirmed_after Get Shipment Details by passing Shipment confirmed create Date After. Must be in ISO-8601 date/time format. (optional)
     * @param  string $package_label_created_before Get Shipment Details by passing Package label create Date by buyer. Must be in ISO-8601 date/time format. (optional)
     * @param  string $package_label_created_after Get Shipment Details by passing Package label create Date After by buyer. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipped_before Get Shipment Details by passing Shipped Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipped_after Get Shipment Details by passing Shipped Date After. Must be in ISO-8601 date/time format. (optional)
     * @param  string $estimated_delivery_before Get Shipment Details by passing Estimated Delivery Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $estimated_delivery_after Get Shipment Details by passing Estimated Delivery Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipment_delivery_before Get Shipment Details by passing Shipment Delivery Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipment_delivery_after Get Shipment Details by passing Shipment Delivery Date After. Must be in ISO-8601 date/time format. (optional)
     * @param  string $requested_pick_up_before Get Shipment Details by passing Before Requested pickup date. Must be in ISO-8601 date/time format. (optional)
     * @param  string $requested_pick_up_after Get Shipment Details by passing After Requested pickup date. Must be in ISO-8601 date/time format. (optional)
     * @param  string $scheduled_pick_up_before Get Shipment Details by passing Before scheduled pickup date. Must be in ISO-8601 date/time format. (optional)
     * @param  string $scheduled_pick_up_after Get Shipment Details by passing After Scheduled pickup date. Must be in ISO-8601 date/time format. (optional)
     * @param  string $current_shipment_status Get Shipment Details by passing Current shipment status. (optional)
     * @param  string $vendor_shipment_identifier Get Shipment Details by passing Vendor Shipment ID (optional)
     * @param  string $buyer_reference_number Get Shipment Details by passing buyer Reference ID (optional)
     * @param  string $buyer_warehouse_code Get Shipping Details based on buyer warehouse code. This value should be same as 'shipToParty.partyId' in the Shipment. (optional)
     * @param  string $seller_warehouse_code Get Shipping Details based on vendor warehouse code. This value should be same as 'sellingParty.partyId' in the Shipment. (optional)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getShipmentDetailsWithHttpInfo($limit = null, $sort_order = null, $next_token = null, $created_after = null, $created_before = null, $shipment_confirmed_before = null, $shipment_confirmed_after = null, $package_label_created_before = null, $package_label_created_after = null, $shipped_before = null, $shipped_after = null, $estimated_delivery_before = null, $estimated_delivery_after = null, $shipment_delivery_before = null, $shipment_delivery_after = null, $requested_pick_up_before = null, $requested_pick_up_after = null, $scheduled_pick_up_before = null, $scheduled_pick_up_after = null, $current_shipment_status = null, $vendor_shipment_identifier = null, $buyer_reference_number = null, $buyer_warehouse_code = null, $seller_warehouse_code = null)
    {
        $request = $this->getShipmentDetailsRequest($limit, $sort_order, $next_token, $created_after, $created_before, $shipment_confirmed_before, $shipment_confirmed_after, $package_label_created_before, $package_label_created_after, $shipped_before, $shipped_after, $estimated_delivery_before, $estimated_delivery_after, $shipment_delivery_before, $shipment_delivery_after, $requested_pick_up_before, $requested_pick_up_after, $scheduled_pick_up_before, $scheduled_pick_up_after, $current_shipment_status, $vendor_shipment_identifier, $buyer_reference_number, $buyer_warehouse_code, $seller_warehouse_code);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
                $this->writeDebug($response);
                $this->writeDebug((string) $response->getBody());
            } catch (RequestException $e) {
                $hasResponse = !empty($e->hasResponse());
                $body = (string) ($hasResponse ? $e->getResponse()->getBody() : '[NULL response]');
                $this->writeDebug($e->getResponse());
                $this->writeDebug($body);
                throw new ApiException(
                    "[{$e->getCode()}] {$body}",
                    $e->getCode(),
                    $hasResponse ? $e->getResponse()->getHeaders() : [],
                    $body
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse', $response->getHeaders());
                case 401:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse', $response->getHeaders());
                case 415:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            $this->writeDebug($e);
            throw $e;
        }
    }

    /**
     * Operation getShipmentDetailsAsync
     *
     * 
     *
     * @param  int $limit The limit to the number of records returned. Default value is 50 records. (optional)
     * @param  string $sort_order Sort in ascending or descending order by purchase order creation date. (optional)
     * @param  string $next_token Used for pagination when there are more shipments than the specified result size limit. (optional)
     * @param  string $created_after Get Shipment Details that became available after this timestamp will be included in the result. Must be in ISO-8601 date/time format. (optional)
     * @param  string $created_before Get Shipment Details that became available before this timestamp will be included in the result. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipment_confirmed_before Get Shipment Details by passing Shipment confirmed create Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipment_confirmed_after Get Shipment Details by passing Shipment confirmed create Date After. Must be in ISO-8601 date/time format. (optional)
     * @param  string $package_label_created_before Get Shipment Details by passing Package label create Date by buyer. Must be in ISO-8601 date/time format. (optional)
     * @param  string $package_label_created_after Get Shipment Details by passing Package label create Date After by buyer. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipped_before Get Shipment Details by passing Shipped Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipped_after Get Shipment Details by passing Shipped Date After. Must be in ISO-8601 date/time format. (optional)
     * @param  string $estimated_delivery_before Get Shipment Details by passing Estimated Delivery Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $estimated_delivery_after Get Shipment Details by passing Estimated Delivery Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipment_delivery_before Get Shipment Details by passing Shipment Delivery Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipment_delivery_after Get Shipment Details by passing Shipment Delivery Date After. Must be in ISO-8601 date/time format. (optional)
     * @param  string $requested_pick_up_before Get Shipment Details by passing Before Requested pickup date. Must be in ISO-8601 date/time format. (optional)
     * @param  string $requested_pick_up_after Get Shipment Details by passing After Requested pickup date. Must be in ISO-8601 date/time format. (optional)
     * @param  string $scheduled_pick_up_before Get Shipment Details by passing Before scheduled pickup date. Must be in ISO-8601 date/time format. (optional)
     * @param  string $scheduled_pick_up_after Get Shipment Details by passing After Scheduled pickup date. Must be in ISO-8601 date/time format. (optional)
     * @param  string $current_shipment_status Get Shipment Details by passing Current shipment status. (optional)
     * @param  string $vendor_shipment_identifier Get Shipment Details by passing Vendor Shipment ID (optional)
     * @param  string $buyer_reference_number Get Shipment Details by passing buyer Reference ID (optional)
     * @param  string $buyer_warehouse_code Get Shipping Details based on buyer warehouse code. This value should be same as 'shipToParty.partyId' in the Shipment. (optional)
     * @param  string $seller_warehouse_code Get Shipping Details based on vendor warehouse code. This value should be same as 'sellingParty.partyId' in the Shipment. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShipmentDetailsAsync($limit = null, $sort_order = null, $next_token = null, $created_after = null, $created_before = null, $shipment_confirmed_before = null, $shipment_confirmed_after = null, $package_label_created_before = null, $package_label_created_after = null, $shipped_before = null, $shipped_after = null, $estimated_delivery_before = null, $estimated_delivery_after = null, $shipment_delivery_before = null, $shipment_delivery_after = null, $requested_pick_up_before = null, $requested_pick_up_after = null, $scheduled_pick_up_before = null, $scheduled_pick_up_after = null, $current_shipment_status = null, $vendor_shipment_identifier = null, $buyer_reference_number = null, $buyer_warehouse_code = null, $seller_warehouse_code = null)
    {
        return $this->getShipmentDetailsAsyncWithHttpInfo($limit, $sort_order, $next_token, $created_after, $created_before, $shipment_confirmed_before, $shipment_confirmed_after, $package_label_created_before, $package_label_created_after, $shipped_before, $shipped_after, $estimated_delivery_before, $estimated_delivery_after, $shipment_delivery_before, $shipment_delivery_after, $requested_pick_up_before, $requested_pick_up_after, $scheduled_pick_up_before, $scheduled_pick_up_after, $current_shipment_status, $vendor_shipment_identifier, $buyer_reference_number, $buyer_warehouse_code, $seller_warehouse_code);
    }

    /**
     * Operation getShipmentDetailsAsyncWithHttpInfo
     *
     * 
     *
     * @param  int $limit The limit to the number of records returned. Default value is 50 records. (optional)
     * @param  string $sort_order Sort in ascending or descending order by purchase order creation date. (optional)
     * @param  string $next_token Used for pagination when there are more shipments than the specified result size limit. (optional)
     * @param  string $created_after Get Shipment Details that became available after this timestamp will be included in the result. Must be in ISO-8601 date/time format. (optional)
     * @param  string $created_before Get Shipment Details that became available before this timestamp will be included in the result. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipment_confirmed_before Get Shipment Details by passing Shipment confirmed create Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipment_confirmed_after Get Shipment Details by passing Shipment confirmed create Date After. Must be in ISO-8601 date/time format. (optional)
     * @param  string $package_label_created_before Get Shipment Details by passing Package label create Date by buyer. Must be in ISO-8601 date/time format. (optional)
     * @param  string $package_label_created_after Get Shipment Details by passing Package label create Date After by buyer. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipped_before Get Shipment Details by passing Shipped Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipped_after Get Shipment Details by passing Shipped Date After. Must be in ISO-8601 date/time format. (optional)
     * @param  string $estimated_delivery_before Get Shipment Details by passing Estimated Delivery Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $estimated_delivery_after Get Shipment Details by passing Estimated Delivery Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipment_delivery_before Get Shipment Details by passing Shipment Delivery Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipment_delivery_after Get Shipment Details by passing Shipment Delivery Date After. Must be in ISO-8601 date/time format. (optional)
     * @param  string $requested_pick_up_before Get Shipment Details by passing Before Requested pickup date. Must be in ISO-8601 date/time format. (optional)
     * @param  string $requested_pick_up_after Get Shipment Details by passing After Requested pickup date. Must be in ISO-8601 date/time format. (optional)
     * @param  string $scheduled_pick_up_before Get Shipment Details by passing Before scheduled pickup date. Must be in ISO-8601 date/time format. (optional)
     * @param  string $scheduled_pick_up_after Get Shipment Details by passing After Scheduled pickup date. Must be in ISO-8601 date/time format. (optional)
     * @param  string $current_shipment_status Get Shipment Details by passing Current shipment status. (optional)
     * @param  string $vendor_shipment_identifier Get Shipment Details by passing Vendor Shipment ID (optional)
     * @param  string $buyer_reference_number Get Shipment Details by passing buyer Reference ID (optional)
     * @param  string $buyer_warehouse_code Get Shipping Details based on buyer warehouse code. This value should be same as 'shipToParty.partyId' in the Shipment. (optional)
     * @param  string $seller_warehouse_code Get Shipping Details based on vendor warehouse code. This value should be same as 'sellingParty.partyId' in the Shipment. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShipmentDetailsAsyncWithHttpInfo($limit = null, $sort_order = null, $next_token = null, $created_after = null, $created_before = null, $shipment_confirmed_before = null, $shipment_confirmed_after = null, $package_label_created_before = null, $package_label_created_after = null, $shipped_before = null, $shipped_after = null, $estimated_delivery_before = null, $estimated_delivery_after = null, $shipment_delivery_before = null, $shipment_delivery_after = null, $requested_pick_up_before = null, $requested_pick_up_after = null, $scheduled_pick_up_before = null, $scheduled_pick_up_after = null, $current_shipment_status = null, $vendor_shipment_identifier = null, $buyer_reference_number = null, $buyer_warehouse_code = null, $seller_warehouse_code = null)
    {
        $returnType = '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentDetailsResponse';
        $request = $this->getShipmentDetailsRequest($limit, $sort_order, $next_token, $created_after, $created_before, $shipment_confirmed_before, $shipment_confirmed_after, $package_label_created_before, $package_label_created_after, $shipped_before, $shipped_after, $estimated_delivery_before, $estimated_delivery_after, $shipment_delivery_before, $shipment_delivery_after, $requested_pick_up_before, $requested_pick_up_after, $scheduled_pick_up_before, $scheduled_pick_up_after, $current_shipment_status, $vendor_shipment_identifier, $buyer_reference_number, $buyer_warehouse_code, $seller_warehouse_code);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $this->writeDebug($response);
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $hasResponse = !empty($response);
                    $body = (string) ($hasResponse ? $response->getBody() : '[NULL response]');
                    $this->writeDebug($response);
                    $statusCode = $hasResponse ? $response->getStatusCode() : $exception->getCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $hasResponse ? $response->getHeaders() : [],
                        $body
                    );
                }
            );
    }

    /**
     * Create request for operation 'getShipmentDetails'
     *
     * @param  int $limit The limit to the number of records returned. Default value is 50 records. (optional)
     * @param  string $sort_order Sort in ascending or descending order by purchase order creation date. (optional)
     * @param  string $next_token Used for pagination when there are more shipments than the specified result size limit. (optional)
     * @param  string $created_after Get Shipment Details that became available after this timestamp will be included in the result. Must be in ISO-8601 date/time format. (optional)
     * @param  string $created_before Get Shipment Details that became available before this timestamp will be included in the result. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipment_confirmed_before Get Shipment Details by passing Shipment confirmed create Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipment_confirmed_after Get Shipment Details by passing Shipment confirmed create Date After. Must be in ISO-8601 date/time format. (optional)
     * @param  string $package_label_created_before Get Shipment Details by passing Package label create Date by buyer. Must be in ISO-8601 date/time format. (optional)
     * @param  string $package_label_created_after Get Shipment Details by passing Package label create Date After by buyer. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipped_before Get Shipment Details by passing Shipped Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipped_after Get Shipment Details by passing Shipped Date After. Must be in ISO-8601 date/time format. (optional)
     * @param  string $estimated_delivery_before Get Shipment Details by passing Estimated Delivery Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $estimated_delivery_after Get Shipment Details by passing Estimated Delivery Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipment_delivery_before Get Shipment Details by passing Shipment Delivery Date Before. Must be in ISO-8601 date/time format. (optional)
     * @param  string $shipment_delivery_after Get Shipment Details by passing Shipment Delivery Date After. Must be in ISO-8601 date/time format. (optional)
     * @param  string $requested_pick_up_before Get Shipment Details by passing Before Requested pickup date. Must be in ISO-8601 date/time format. (optional)
     * @param  string $requested_pick_up_after Get Shipment Details by passing After Requested pickup date. Must be in ISO-8601 date/time format. (optional)
     * @param  string $scheduled_pick_up_before Get Shipment Details by passing Before scheduled pickup date. Must be in ISO-8601 date/time format. (optional)
     * @param  string $scheduled_pick_up_after Get Shipment Details by passing After Scheduled pickup date. Must be in ISO-8601 date/time format. (optional)
     * @param  string $current_shipment_status Get Shipment Details by passing Current shipment status. (optional)
     * @param  string $vendor_shipment_identifier Get Shipment Details by passing Vendor Shipment ID (optional)
     * @param  string $buyer_reference_number Get Shipment Details by passing buyer Reference ID (optional)
     * @param  string $buyer_warehouse_code Get Shipping Details based on buyer warehouse code. This value should be same as 'shipToParty.partyId' in the Shipment. (optional)
     * @param  string $seller_warehouse_code Get Shipping Details based on vendor warehouse code. This value should be same as 'sellingParty.partyId' in the Shipment. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getShipmentDetailsRequest($limit = null, $sort_order = null, $next_token = null, $created_after = null, $created_before = null, $shipment_confirmed_before = null, $shipment_confirmed_after = null, $package_label_created_before = null, $package_label_created_after = null, $shipped_before = null, $shipped_after = null, $estimated_delivery_before = null, $estimated_delivery_after = null, $shipment_delivery_before = null, $shipment_delivery_after = null, $requested_pick_up_before = null, $requested_pick_up_after = null, $scheduled_pick_up_before = null, $scheduled_pick_up_after = null, $current_shipment_status = null, $vendor_shipment_identifier = null, $buyer_reference_number = null, $buyer_warehouse_code = null, $seller_warehouse_code = null)
    {
        if ($limit !== null && $limit > 50) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling VendorShippingV1Api.getShipmentDetails, must be smaller than or equal to 50.');
        }
        if ($limit !== null && $limit < 1) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling VendorShippingV1Api.getShipmentDetails, must be bigger than or equal to 1.');
        }


        $resourcePath = '/vendor/shipping/v1/shipments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if (is_array($limit)) {
            $limit = ObjectSerializer::serializeCollection($limit, '', true);
        }
        if ($limit !== null) {
            $queryParams['limit'] = $limit;
        }

        // query params
        if (is_array($sort_order)) {
            $sort_order = ObjectSerializer::serializeCollection($sort_order, '', true);
        }
        if ($sort_order !== null) {
            $queryParams['sortOrder'] = $sort_order;
        }

        // query params
        if (is_array($next_token)) {
            $next_token = ObjectSerializer::serializeCollection($next_token, '', true);
        }
        if ($next_token !== null) {
            $queryParams['nextToken'] = $next_token;
        }

        // query params
        if (is_array($created_after)) {
            $created_after = ObjectSerializer::serializeCollection($created_after, '', true);
        }
        if ($created_after !== null) {
            $queryParams['createdAfter'] = $created_after;
        }

        // query params
        if (is_array($created_before)) {
            $created_before = ObjectSerializer::serializeCollection($created_before, '', true);
        }
        if ($created_before !== null) {
            $queryParams['createdBefore'] = $created_before;
        }

        // query params
        if (is_array($shipment_confirmed_before)) {
            $shipment_confirmed_before = ObjectSerializer::serializeCollection($shipment_confirmed_before, '', true);
        }
        if ($shipment_confirmed_before !== null) {
            $queryParams['shipmentConfirmedBefore'] = $shipment_confirmed_before;
        }

        // query params
        if (is_array($shipment_confirmed_after)) {
            $shipment_confirmed_after = ObjectSerializer::serializeCollection($shipment_confirmed_after, '', true);
        }
        if ($shipment_confirmed_after !== null) {
            $queryParams['shipmentConfirmedAfter'] = $shipment_confirmed_after;
        }

        // query params
        if (is_array($package_label_created_before)) {
            $package_label_created_before = ObjectSerializer::serializeCollection($package_label_created_before, '', true);
        }
        if ($package_label_created_before !== null) {
            $queryParams['packageLabelCreatedBefore'] = $package_label_created_before;
        }

        // query params
        if (is_array($package_label_created_after)) {
            $package_label_created_after = ObjectSerializer::serializeCollection($package_label_created_after, '', true);
        }
        if ($package_label_created_after !== null) {
            $queryParams['packageLabelCreatedAfter'] = $package_label_created_after;
        }

        // query params
        if (is_array($shipped_before)) {
            $shipped_before = ObjectSerializer::serializeCollection($shipped_before, '', true);
        }
        if ($shipped_before !== null) {
            $queryParams['shippedBefore'] = $shipped_before;
        }

        // query params
        if (is_array($shipped_after)) {
            $shipped_after = ObjectSerializer::serializeCollection($shipped_after, '', true);
        }
        if ($shipped_after !== null) {
            $queryParams['shippedAfter'] = $shipped_after;
        }

        // query params
        if (is_array($estimated_delivery_before)) {
            $estimated_delivery_before = ObjectSerializer::serializeCollection($estimated_delivery_before, '', true);
        }
        if ($estimated_delivery_before !== null) {
            $queryParams['estimatedDeliveryBefore'] = $estimated_delivery_before;
        }

        // query params
        if (is_array($estimated_delivery_after)) {
            $estimated_delivery_after = ObjectSerializer::serializeCollection($estimated_delivery_after, '', true);
        }
        if ($estimated_delivery_after !== null) {
            $queryParams['estimatedDeliveryAfter'] = $estimated_delivery_after;
        }

        // query params
        if (is_array($shipment_delivery_before)) {
            $shipment_delivery_before = ObjectSerializer::serializeCollection($shipment_delivery_before, '', true);
        }
        if ($shipment_delivery_before !== null) {
            $queryParams['shipmentDeliveryBefore'] = $shipment_delivery_before;
        }

        // query params
        if (is_array($shipment_delivery_after)) {
            $shipment_delivery_after = ObjectSerializer::serializeCollection($shipment_delivery_after, '', true);
        }
        if ($shipment_delivery_after !== null) {
            $queryParams['shipmentDeliveryAfter'] = $shipment_delivery_after;
        }

        // query params
        if (is_array($requested_pick_up_before)) {
            $requested_pick_up_before = ObjectSerializer::serializeCollection($requested_pick_up_before, '', true);
        }
        if ($requested_pick_up_before !== null) {
            $queryParams['requestedPickUpBefore'] = $requested_pick_up_before;
        }

        // query params
        if (is_array($requested_pick_up_after)) {
            $requested_pick_up_after = ObjectSerializer::serializeCollection($requested_pick_up_after, '', true);
        }
        if ($requested_pick_up_after !== null) {
            $queryParams['requestedPickUpAfter'] = $requested_pick_up_after;
        }

        // query params
        if (is_array($scheduled_pick_up_before)) {
            $scheduled_pick_up_before = ObjectSerializer::serializeCollection($scheduled_pick_up_before, '', true);
        }
        if ($scheduled_pick_up_before !== null) {
            $queryParams['scheduledPickUpBefore'] = $scheduled_pick_up_before;
        }

        // query params
        if (is_array($scheduled_pick_up_after)) {
            $scheduled_pick_up_after = ObjectSerializer::serializeCollection($scheduled_pick_up_after, '', true);
        }
        if ($scheduled_pick_up_after !== null) {
            $queryParams['scheduledPickUpAfter'] = $scheduled_pick_up_after;
        }

        // query params
        if (is_array($current_shipment_status)) {
            $current_shipment_status = ObjectSerializer::serializeCollection($current_shipment_status, '', true);
        }
        if ($current_shipment_status !== null) {
            $queryParams['currentShipmentStatus'] = $current_shipment_status;
        }

        // query params
        if (is_array($vendor_shipment_identifier)) {
            $vendor_shipment_identifier = ObjectSerializer::serializeCollection($vendor_shipment_identifier, '', true);
        }
        if ($vendor_shipment_identifier !== null) {
            $queryParams['vendorShipmentIdentifier'] = $vendor_shipment_identifier;
        }

        // query params
        if (is_array($buyer_reference_number)) {
            $buyer_reference_number = ObjectSerializer::serializeCollection($buyer_reference_number, '', true);
        }
        if ($buyer_reference_number !== null) {
            $queryParams['buyerReferenceNumber'] = $buyer_reference_number;
        }

        // query params
        if (is_array($buyer_warehouse_code)) {
            $buyer_warehouse_code = ObjectSerializer::serializeCollection($buyer_warehouse_code, '', true);
        }
        if ($buyer_warehouse_code !== null) {
            $queryParams['buyerWarehouseCode'] = $buyer_warehouse_code;
        }

        // query params
        if (is_array($seller_warehouse_code)) {
            $seller_warehouse_code = ObjectSerializer::serializeCollection($seller_warehouse_code, '', true);
        }
        if ($seller_warehouse_code !== null) {
            $queryParams['sellerWarehouseCode'] = $seller_warehouse_code;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getShipmentLabels
     *
     * @param  int $limit The limit to the number of records returned. Default value is 50 records. (optional)
     * @param  string $sort_order Sort in ascending or descending order by transport label creation date. (optional)
     * @param  string $next_token Used for pagination when there are more transport label than the specified result size limit. (optional)
     * @param  string $label_created_after transport Labels that became available after this timestamp will be included in the result. Must be in ISO-8601 date/time format. (optional)
     * @param  string $labelcreated_before transport Labels that became available before this timestamp will be included in the result. Must be in ISO-8601 date/time format. (optional)
     * @param  string $buyer_reference_number Get transport labels by passing Buyer Reference Number to retreive the corresponding transport label. (optional)
     * @param  string $vendor_shipment_identifier Get transport labels by passing Vendor Shipment ID to retreive the corresponding transport label. (optional)
     * @param  string $seller_warehouse_code Get Shipping labels based Vendor Warehouse code. This value should be same as 'shipFromParty.partyId' in the Shipment. (optional)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels
     */
    public function getShipmentLabels($limit = null, $sort_order = null, $next_token = null, $label_created_after = null, $labelcreated_before = null, $buyer_reference_number = null, $vendor_shipment_identifier = null, $seller_warehouse_code = null)
    {
        $response = $this->getShipmentLabelsWithHttpInfo($limit, $sort_order, $next_token, $label_created_after, $labelcreated_before, $buyer_reference_number, $vendor_shipment_identifier, $seller_warehouse_code);
        return $response;
    }

    /**
     * Operation getShipmentLabelsWithHttpInfo
     *
     * @param  int $limit The limit to the number of records returned. Default value is 50 records. (optional)
     * @param  string $sort_order Sort in ascending or descending order by transport label creation date. (optional)
     * @param  string $next_token Used for pagination when there are more transport label than the specified result size limit. (optional)
     * @param  string $label_created_after transport Labels that became available after this timestamp will be included in the result. Must be in ISO-8601 date/time format. (optional)
     * @param  string $labelcreated_before transport Labels that became available before this timestamp will be included in the result. Must be in ISO-8601 date/time format. (optional)
     * @param  string $buyer_reference_number Get transport labels by passing Buyer Reference Number to retreive the corresponding transport label. (optional)
     * @param  string $vendor_shipment_identifier Get transport labels by passing Vendor Shipment ID to retreive the corresponding transport label. (optional)
     * @param  string $seller_warehouse_code Get Shipping labels based Vendor Warehouse code. This value should be same as 'shipFromParty.partyId' in the Shipment. (optional)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels, HTTP status code, HTTP response headers (array of strings)
     */
    public function getShipmentLabelsWithHttpInfo($limit = null, $sort_order = null, $next_token = null, $label_created_after = null, $labelcreated_before = null, $buyer_reference_number = null, $vendor_shipment_identifier = null, $seller_warehouse_code = null)
    {
        $request = $this->getShipmentLabelsRequest($limit, $sort_order, $next_token, $label_created_after, $labelcreated_before, $buyer_reference_number, $vendor_shipment_identifier, $seller_warehouse_code);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
                $this->writeDebug($response);
                $this->writeDebug((string) $response->getBody());
            } catch (RequestException $e) {
                $hasResponse = !empty($e->hasResponse());
                $body = (string) ($hasResponse ? $e->getResponse()->getBody() : '[NULL response]');
                $this->writeDebug($e->getResponse());
                $this->writeDebug($body);
                throw new ApiException(
                    "[{$e->getCode()}] {$body}",
                    $e->getCode(),
                    $hasResponse ? $e->getResponse()->getHeaders() : [],
                    $body
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels', $response->getHeaders());
                case 401:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels', $response->getHeaders());
                case 415:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            $this->writeDebug($e);
            throw $e;
        }
    }

    /**
     * Operation getShipmentLabelsAsync
     *
     * 
     *
     * @param  int $limit The limit to the number of records returned. Default value is 50 records. (optional)
     * @param  string $sort_order Sort in ascending or descending order by transport label creation date. (optional)
     * @param  string $next_token Used for pagination when there are more transport label than the specified result size limit. (optional)
     * @param  string $label_created_after transport Labels that became available after this timestamp will be included in the result. Must be in ISO-8601 date/time format. (optional)
     * @param  string $labelcreated_before transport Labels that became available before this timestamp will be included in the result. Must be in ISO-8601 date/time format. (optional)
     * @param  string $buyer_reference_number Get transport labels by passing Buyer Reference Number to retreive the corresponding transport label. (optional)
     * @param  string $vendor_shipment_identifier Get transport labels by passing Vendor Shipment ID to retreive the corresponding transport label. (optional)
     * @param  string $seller_warehouse_code Get Shipping labels based Vendor Warehouse code. This value should be same as 'shipFromParty.partyId' in the Shipment. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShipmentLabelsAsync($limit = null, $sort_order = null, $next_token = null, $label_created_after = null, $labelcreated_before = null, $buyer_reference_number = null, $vendor_shipment_identifier = null, $seller_warehouse_code = null)
    {
        return $this->getShipmentLabelsAsyncWithHttpInfo($limit, $sort_order, $next_token, $label_created_after, $labelcreated_before, $buyer_reference_number, $vendor_shipment_identifier, $seller_warehouse_code);
    }

    /**
     * Operation getShipmentLabelsAsyncWithHttpInfo
     *
     * 
     *
     * @param  int $limit The limit to the number of records returned. Default value is 50 records. (optional)
     * @param  string $sort_order Sort in ascending or descending order by transport label creation date. (optional)
     * @param  string $next_token Used for pagination when there are more transport label than the specified result size limit. (optional)
     * @param  string $label_created_after transport Labels that became available after this timestamp will be included in the result. Must be in ISO-8601 date/time format. (optional)
     * @param  string $labelcreated_before transport Labels that became available before this timestamp will be included in the result. Must be in ISO-8601 date/time format. (optional)
     * @param  string $buyer_reference_number Get transport labels by passing Buyer Reference Number to retreive the corresponding transport label. (optional)
     * @param  string $vendor_shipment_identifier Get transport labels by passing Vendor Shipment ID to retreive the corresponding transport label. (optional)
     * @param  string $seller_warehouse_code Get Shipping labels based Vendor Warehouse code. This value should be same as 'shipFromParty.partyId' in the Shipment. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShipmentLabelsAsyncWithHttpInfo($limit = null, $sort_order = null, $next_token = null, $label_created_after = null, $labelcreated_before = null, $buyer_reference_number = null, $vendor_shipment_identifier = null, $seller_warehouse_code = null)
    {
        $returnType = '\SellingPartnerApi\Model\VendorShippingV1\GetShipmentLabels';
        $request = $this->getShipmentLabelsRequest($limit, $sort_order, $next_token, $label_created_after, $labelcreated_before, $buyer_reference_number, $vendor_shipment_identifier, $seller_warehouse_code);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $this->writeDebug($response);
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $hasResponse = !empty($response);
                    $body = (string) ($hasResponse ? $response->getBody() : '[NULL response]');
                    $this->writeDebug($response);
                    $statusCode = $hasResponse ? $response->getStatusCode() : $exception->getCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $hasResponse ? $response->getHeaders() : [],
                        $body
                    );
                }
            );
    }

    /**
     * Create request for operation 'getShipmentLabels'
     *
     * @param  int $limit The limit to the number of records returned. Default value is 50 records. (optional)
     * @param  string $sort_order Sort in ascending or descending order by transport label creation date. (optional)
     * @param  string $next_token Used for pagination when there are more transport label than the specified result size limit. (optional)
     * @param  string $label_created_after transport Labels that became available after this timestamp will be included in the result. Must be in ISO-8601 date/time format. (optional)
     * @param  string $labelcreated_before transport Labels that became available before this timestamp will be included in the result. Must be in ISO-8601 date/time format. (optional)
     * @param  string $buyer_reference_number Get transport labels by passing Buyer Reference Number to retreive the corresponding transport label. (optional)
     * @param  string $vendor_shipment_identifier Get transport labels by passing Vendor Shipment ID to retreive the corresponding transport label. (optional)
     * @param  string $seller_warehouse_code Get Shipping labels based Vendor Warehouse code. This value should be same as 'shipFromParty.partyId' in the Shipment. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getShipmentLabelsRequest($limit = null, $sort_order = null, $next_token = null, $label_created_after = null, $labelcreated_before = null, $buyer_reference_number = null, $vendor_shipment_identifier = null, $seller_warehouse_code = null)
    {
        if ($limit !== null && $limit > 50) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling VendorShippingV1Api.getShipmentLabels, must be smaller than or equal to 50.');
        }
        if ($limit !== null && $limit < 1) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling VendorShippingV1Api.getShipmentLabels, must be bigger than or equal to 1.');
        }


        $resourcePath = '/vendor/shipping/v1/transportLabels';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if (is_array($limit)) {
            $limit = ObjectSerializer::serializeCollection($limit, '', true);
        }
        if ($limit !== null) {
            $queryParams['limit'] = $limit;
        }

        // query params
        if (is_array($sort_order)) {
            $sort_order = ObjectSerializer::serializeCollection($sort_order, '', true);
        }
        if ($sort_order !== null) {
            $queryParams['sortOrder'] = $sort_order;
        }

        // query params
        if (is_array($next_token)) {
            $next_token = ObjectSerializer::serializeCollection($next_token, '', true);
        }
        if ($next_token !== null) {
            $queryParams['nextToken'] = $next_token;
        }

        // query params
        if (is_array($label_created_after)) {
            $label_created_after = ObjectSerializer::serializeCollection($label_created_after, '', true);
        }
        if ($label_created_after !== null) {
            $queryParams['labelCreatedAfter'] = $label_created_after;
        }

        // query params
        if (is_array($labelcreated_before)) {
            $labelcreated_before = ObjectSerializer::serializeCollection($labelcreated_before, '', true);
        }
        if ($labelcreated_before !== null) {
            $queryParams['labelcreatedBefore'] = $labelcreated_before;
        }

        // query params
        if (is_array($buyer_reference_number)) {
            $buyer_reference_number = ObjectSerializer::serializeCollection($buyer_reference_number, '', true);
        }
        if ($buyer_reference_number !== null) {
            $queryParams['buyerReferenceNumber'] = $buyer_reference_number;
        }

        // query params
        if (is_array($vendor_shipment_identifier)) {
            $vendor_shipment_identifier = ObjectSerializer::serializeCollection($vendor_shipment_identifier, '', true);
        }
        if ($vendor_shipment_identifier !== null) {
            $queryParams['vendorShipmentIdentifier'] = $vendor_shipment_identifier;
        }

        // query params
        if (is_array($seller_warehouse_code)) {
            $seller_warehouse_code = ObjectSerializer::serializeCollection($seller_warehouse_code, '', true);
        }
        if ($seller_warehouse_code !== null) {
            $queryParams['sellerWarehouseCode'] = $seller_warehouse_code;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation submitShipmentConfirmations
     *
     * @param  \SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsRequest $body body (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse
     */
    public function submitShipmentConfirmations($body)
    {
        $response = $this->submitShipmentConfirmationsWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation submitShipmentConfirmationsWithHttpInfo
     *
     * @param  \SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsRequest $body (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function submitShipmentConfirmationsWithHttpInfo($body)
    {
        $request = $this->submitShipmentConfirmationsRequest($body);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
                $this->writeDebug($response);
                $this->writeDebug((string) $response->getBody());
            } catch (RequestException $e) {
                $hasResponse = !empty($e->hasResponse());
                $body = (string) ($hasResponse ? $e->getResponse()->getBody() : '[NULL response]');
                $this->writeDebug($e->getResponse());
                $this->writeDebug($body);
                throw new ApiException(
                    "[{$e->getCode()}] {$body}",
                    $e->getCode(),
                    $hasResponse ? $e->getResponse()->getHeaders() : [],
                    $body
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 202:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse', $response->getHeaders());
                case 413:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse', $response->getHeaders());
                case 415:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 202:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            $this->writeDebug($e);
            throw $e;
        }
    }

    /**
     * Operation submitShipmentConfirmationsAsync
     *
     * 
     *
     * @param  \SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function submitShipmentConfirmationsAsync($body)
    {
        return $this->submitShipmentConfirmationsAsyncWithHttpInfo($body);
    }

    /**
     * Operation submitShipmentConfirmationsAsyncWithHttpInfo
     *
     * 
     *
     * @param  \SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function submitShipmentConfirmationsAsyncWithHttpInfo($body)
    {
        $returnType = '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse';
        $request = $this->submitShipmentConfirmationsRequest($body);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $this->writeDebug($response);
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $hasResponse = !empty($response);
                    $body = (string) ($hasResponse ? $response->getBody() : '[NULL response]');
                    $this->writeDebug($response);
                    $statusCode = $hasResponse ? $response->getStatusCode() : $exception->getCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $hasResponse ? $response->getHeaders() : [],
                        $body
                    );
                }
            );
    }

    /**
     * Create request for operation 'submitShipmentConfirmations'
     *
     * @param  \SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function submitShipmentConfirmationsRequest($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling submitShipmentConfirmations'
            );
        }

        $resourcePath = '/vendor/shipping/v1/shipmentConfirmations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation submitShipments
     *
     * @param  \SellingPartnerApi\Model\VendorShippingV1\SubmitShipments $body body (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse
     */
    public function submitShipments($body)
    {
        $response = $this->submitShipmentsWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation submitShipmentsWithHttpInfo
     *
     * @param  \SellingPartnerApi\Model\VendorShippingV1\SubmitShipments $body (required)
     *
     * @throws \SellingPartnerApi\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function submitShipmentsWithHttpInfo($body)
    {
        $request = $this->submitShipmentsRequest($body);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($signedRequest, $options);
                $this->writeDebug($response);
                $this->writeDebug((string) $response->getBody());
            } catch (RequestException $e) {
                $hasResponse = !empty($e->hasResponse());
                $body = (string) ($hasResponse ? $e->getResponse()->getBody() : '[NULL response]');
                $this->writeDebug($e->getResponse());
                $this->writeDebug($body);
                throw new ApiException(
                    "[{$e->getCode()}] {$body}",
                    $e->getCode(),
                    $hasResponse ? $e->getResponse()->getHeaders() : [],
                    $body
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $signedRequest->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()->getContents()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 202:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse', $response->getHeaders());
                case 400:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse', $response->getHeaders());
                case 403:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse', $response->getHeaders());
                case 404:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse', $response->getHeaders());
                case 413:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse', $response->getHeaders());
                case 415:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse', $response->getHeaders());
                case 429:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse', $response->getHeaders());
                case 500:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse', $response->getHeaders());
                case 503:
                    if ('\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse', $response->getHeaders());
            }

            $returnType = '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 202:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            $this->writeDebug($e);
            throw $e;
        }
    }

    /**
     * Operation submitShipmentsAsync
     *
     * 
     *
     * @param  \SellingPartnerApi\Model\VendorShippingV1\SubmitShipments $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function submitShipmentsAsync($body)
    {
        return $this->submitShipmentsAsyncWithHttpInfo($body);
    }

    /**
     * Operation submitShipmentsAsyncWithHttpInfo
     *
     * 
     *
     * @param  \SellingPartnerApi\Model\VendorShippingV1\SubmitShipments $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function submitShipmentsAsyncWithHttpInfo($body)
    {
        $returnType = '\SellingPartnerApi\Model\VendorShippingV1\SubmitShipmentConfirmationsResponse';
        $request = $this->submitShipmentsRequest($body);
        $signedRequest = $this->config->signRequest(
            $request
        );

        $this->writeDebug($signedRequest);
        $this->writeDebug((string) $signedRequest->getBody());

        return $this->client
            ->sendAsync($signedRequest, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $this->writeDebug($response);
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return ObjectSerializer::deserialize($content, $returnType, $response->getHeaders());
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $hasResponse = !empty($response);
                    $body = (string) ($hasResponse ? $response->getBody() : '[NULL response]');
                    $this->writeDebug($response);
                    $statusCode = $hasResponse ? $response->getStatusCode() : $exception->getCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $hasResponse ? $response->getHeaders() : [],
                        $body
                    );
                }
            );
    }

    /**
     * Create request for operation 'submitShipments'
     *
     * @param  \SellingPartnerApi\Model\VendorShippingV1\SubmitShipments $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function submitShipmentsRequest($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling submitShipments'
            );
        }

        $resourcePath = '/vendor/shipping/v1/shipments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

}
