<?php
/**
 * ListOffersSortKey
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Replenishment
 *
 * The Selling Partner API for Replenishment (Replenishment API) provides programmatic access to replenishment program metrics and offers. These programs provide recurring delivery (automatic or manual) of any replenishable item at a frequency chosen by the customer.
 *
 * The version of the OpenAPI document: 2022-11-07
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\ReplenishmentV20221107;
use ArrayAccess;

use SellingPartnerApi\Model\ModelInterface;

/**
 * ListOffersSortKey Class Doc Comment
 *
 * @category Class
 * @description The attribute to use to sort the results.
 * @package  SellingPartnerApi
 * @group 
 */
class ListOffersSortKey
{
    public $value;

    /**
     * Possible values of this enum
     */
    const ASIN = 'ASIN';
    const SELLING_PARTNER_FUNDED_BASE_DISCOUNT_PERCENTAGE = 'SELLING_PARTNER_FUNDED_BASE_DISCOUNT_PERCENTAGE';
    const SELLING_PARTNER_FUNDED_TIERED_DISCOUNT_PERCENTAGE = 'SELLING_PARTNER_FUNDED_TIERED_DISCOUNT_PERCENTAGE';
    const AMAZON_FUNDED_BASE_DISCOUNT_PERCENTAGE = 'AMAZON_FUNDED_BASE_DISCOUNT_PERCENTAGE';
    const AMAZON_FUNDED_TIERED_DISCOUNT_PERCENTAGE = 'AMAZON_FUNDED_TIERED_DISCOUNT_PERCENTAGE';
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public static function getAllowableEnumValues()
    {
        $baseVals = [
            self::ASIN,
            self::SELLING_PARTNER_FUNDED_BASE_DISCOUNT_PERCENTAGE,
            self::SELLING_PARTNER_FUNDED_TIERED_DISCOUNT_PERCENTAGE,
            self::AMAZON_FUNDED_BASE_DISCOUNT_PERCENTAGE,
            self::AMAZON_FUNDED_TIERED_DISCOUNT_PERCENTAGE,
        ];
        // This is necessary because Amazon does not consistently capitalize their
        // enum values, so we do case-insensitive enum value validation in ObjectSerializer
        $ucVals = array_map(function ($val) { return strtoupper($val); }, $baseVals);
        return array_merge($baseVals, $ucVals);
    }

    public function __construct($value)
    {
        if (is_null($value) || !in_array($value, self::getAllowableEnumValues(), true)) {
            throw new \InvalidArgumentException(sprintf("Invalid value %s for enum 'ListOffersSortKey', must be one of '%s'", $value, implode("', '", self::getAllowableEnumValues())));
        }

        $this->value = $value;
    }

    /**
     * Convert the enum value to a string.
     *
     * @return string
     */
    public function __toString()
    {
        return $this->value;
    }
}


